/****************************************************************************
**
** Copyright (C) 2010  Aimone Davide realsportcars@hotmail.com
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#include <QDBusConnection>
#include "keyboardmanager.h"
#include "ui_keyboardmanager.h"
#include "kb_alfanum.h"
#include "kb_qwerty.h"
#include "core.h"
#include "fastsmswidget.h"


KeyboardManager::KeyboardManager(QWidget *parent) :
        QWidget(parent),
        ui(new Ui::KeyboardManager)
{
    ui->setupUi(this);

    connect(ui->kbAlfanumeric,SIGNAL(inputStyleChanged(int)), this, SLOT(settingsChanged(int)));
    connect(ui->kbAlfanumeric,SIGNAL(input(QString,Core::Keyboards)),this,SLOT(processInput(QString,Core::Keyboards)));
    connect(ui->kbQwerty,SIGNAL(inputStyleChanged(int)), this, SLOT(settingsChanged(int)));
    connect(ui->kbQwerty,SIGNAL(input(QString,Core::Keyboards)),this,SLOT(processInput(QString,Core::Keyboards)));

//    QDBusConnection systemBus = QDBusConnection::systemBus();
//    systemBus.connect("com.nokia.mce",
//                      "/com/nokia/mce/signal",
//                      "com.nokia.mce.signal",
//                      "sig_device_orientation_ind",
//                      this, SLOT(orientationChanged(QString)));

    m_settings = new QSettings(Core::SETTING_ORG,Core::SETTING_APPNAME,this);

    //Open with last used keyboard
//    if(m_settings->value(Core::SETTING_CURRENT_KEYBOARD).toInt() == Core::Qwerty)
//        enableQwerty();
//    else
//        enableAlfanum();
}

KeyboardManager::~KeyboardManager()
{
    delete ui;
}

///** Show prefered keyboard for current orientation, only active if autorotation is active **/
//void KeyboardManager::orientationChanged(QString sOrientation)
//{
//    if(m_settings->value(Core::SETTING_ORIENTATION).toString().compare(Core::ORIENTATION_AUTO) != 0)
//        return;

//    m_sCurrentOrientation = sOrientation;

//    if(sOrientation.compare(Core::ORIENTATION_PORTRAIT) == 0)
//    {
//        int nPrefKb = m_settings->value(Core::PREF_PORTRAIT_KB).toInt();
//        if(nPrefKb == Core::Qwerty)
//            enableQwerty();
//        else
//            enableAlfaNum();
//    }
//    else if(sOrientation.compare(Core::ORIENTATION_LANDSCAPE) == 0)
//    {
//        int nPrefKb = m_settings->value(Core::PREF_LANDSCAPE_KB).toInt();
//        if(nPrefKb == Core::Qwerty)
//            enableQwerty();
//        else
//            enableAlfaNum();
//    }
//    else
//        qDebug() << "Unknown orientation:" << sOrientation;
//}

void KeyboardManager::enableQwerty()
{
    m_settings->setValue(Core::SETTING_CURRENT_KEYBOARD,Core::Qwerty);
    ui->stackedWidget->setCurrentIndex(1);
    Keyboard *kb = qobject_cast<Keyboard *>(ui->stackedWidget->widget(1));
    kb->updateSettingsMenu(Core::Qwerty);
    kb->show();
    ui->stackedWidget->widget(0)->hide();
    emit inputStyleChanged(SettingsMenu::QwertyOn);
}

void KeyboardManager::enableAlfanum()
{
    m_settings->setValue(Core::SETTING_CURRENT_KEYBOARD,Core::Alfanumeric);
    ui->stackedWidget->setCurrentIndex(0);
    Keyboard *kb = qobject_cast<Keyboard *>(ui->stackedWidget->widget(0));
    kb->updateSettingsMenu(Core::Alfanumeric);
    kb->show();
    ui->stackedWidget->widget(1)->hide();
    emit inputStyleChanged(SettingsMenu::AlfanumOn);
}

void KeyboardManager::settingsChanged(int nStyle)
{
    if(nStyle == SettingsMenu::QwertyOn)
    {
        enableQwerty();
//        if(m_sCurrentOrientation.compare(Core::ORIENTATION_LANDSCAPE)==0)
//            m_settings->setValue(Core::PREF_LANDSCAPE_KB,Core::Qwerty);
//        else if(m_sCurrentOrientation.compare(Core::ORIENTATION_PORTRAIT)==0)
//            m_settings->setValue(Core::PREF_PORTRAIT_KB,Core::Qwerty);
    }
    else if(nStyle == SettingsMenu::AlfanumOn)
    {
        enableAlfanum();
//        if(m_sCurrentOrientation.compare(Core::ORIENTATION_LANDSCAPE)==0)
//            m_settings->setValue(Core::PREF_LANDSCAPE_KB,Core::Alfanumeric);
//        else if(m_sCurrentOrientation.compare(Core::ORIENTATION_PORTRAIT)==0)
//            m_settings->setValue(Core::PREF_PORTRAIT_KB,Core::Alfanumeric);
    }
    else
    {
        emit inputStyleChanged(nStyle);
    }
}

void KeyboardManager::processInput(QString sInput, Core::Keyboards keyboard)
{
    emit input(sInput,keyboard);
}



















