/****************************************************************************
**
** Copyright (C) 2010  Aimone Davide realsportcars@hotmail.com
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#include "dialogsettings.h"
#include "ui_dialogsettings.h"
#include <QSettings>
#include <QDir>

DialogSettings::DialogSettings(QWidget *parent) :
        QDialog(parent),
        ui(new Ui::DialogSettings)
{
    ui->setupUi(this);

    connect(ui->btSave,SIGNAL(clicked()),this,SLOT(closeOptions()));
    QSettings settings;

    //Populate list of available languages
    QDir dictDir(QApplication::applicationDirPath() + "/data");
    QStringList dictList = dictDir.entryList(QStringList("*.idc"));

    m_sCurrLang = settings.value(Core::SETTING_LANGUAGE,"").toString();
    for(int i=0; i<dictList.size(); i++)
    {
        if(!dictList.at(i).contains("user"))
        {
            ui->cbLanguage->addItem(dictList.at(i));

            if(dictList.at(i).compare(m_sCurrLang) == 0)
                ui->cbLanguage->setCurrentIndex(i);
        }
    }

    //Orientation
    ui->cOrientationAuto->setChecked(true);
    QString sCurrOrient = settings.value(Core::SETTING_ORIENTATION,Core::ORIENTATION_AUTO).toString();
    if(sCurrOrient.compare(Core::ORIENTATION_LANDSCAPE) == 0)
        ui->cOrientationLandscape->setChecked(true);
    else if(sCurrOrient.compare(Core::ORIENTATION_PORTRAIT) == 0)
        ui->cOrientationPortrait->setChecked(true);

    //Phonebook
    ui->cbPhonebook->setCurrentIndex(settings.value(Core::SETTING_PHONEBOOK,0).toInt());

    //Font
    ui->cbFontSize->setCurrentIndex(settings.value(Core::SETTING_FONTSIZE,0).toInt());

    //Pref Landscape Kb
    ui->cbPrefLandscapeKb->setCurrentIndex(settings.value(Core::PREF_LANDSCAPE_KB,0).toInt());

    //Pref Portrait Kb
    ui->cbPrefPortraitKb->setCurrentIndex(settings.value(Core::PREF_PORTRAIT_KB,1).toInt());
}

DialogSettings::~DialogSettings()
{
    delete ui;
}

/** Close option dialog and save options in m_settings file **/
void DialogSettings::closeOptions()
{
    bool isLanguageChanged = false;
    QSettings settings;

    //Language
    QString sDictFile = ui->cbLanguage->currentText();
    settings.setValue(Core::SETTING_LANGUAGE,sDictFile);
    if(sDictFile.compare(m_sCurrLang) != 0)
        isLanguageChanged = true;

    //Phonebook
    int nPhoneBook = ui->cbPhonebook->currentIndex();
    settings.setValue(Core::SETTING_PHONEBOOK,nPhoneBook);

    //Orientation
    if(ui->cOrientationAuto->isChecked())
        settings.setValue(Core::SETTING_ORIENTATION,Core::ORIENTATION_AUTO);
    else if(ui->cOrientationLandscape->isChecked())
        settings.setValue(Core::SETTING_ORIENTATION,Core::ORIENTATION_LANDSCAPE);
    else if(ui->cOrientationPortrait->isChecked())
        settings.setValue(Core::SETTING_ORIENTATION,Core::ORIENTATION_PORTRAIT);

    //Font size
    settings.setValue(Core::SETTING_FONTSIZE,ui->cbFontSize->currentIndex());

    //Pref Landscape Kb
    settings.setValue(Core::PREF_LANDSCAPE_KB,ui->cbPrefLandscapeKb->currentIndex());

    //Pref Portrait Kb
    settings.setValue(Core::PREF_PORTRAIT_KB,ui->cbPrefPortraitKb->currentIndex());

    close();

    emit settingsChanged(isLanguageChanged);
}
