/****************************************************************************
**
** Copyright (C) 2010  Aimone Davide realsportcars@hotmail.com
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#ifndef FASTSMS_H
#define FASTSMS_H

#include <QMainWindow>
#include "dictionary.h"
#include "layoutmanager.h"
#include "textprocessor.h"

namespace Ui {
    class Fastsms;
}

class Fastsms : public QMainWindow
{
    Q_OBJECT

public:
    explicit Fastsms(QWidget *parent = 0);
    ~Fastsms();
    void enableQwerty();

public Q_SLOTS: // METHODS
    bool addRecipient(const QString &phone, const QString &name);


public slots:
    void insertNewWord();
    void openAboutDialog();
    void donate();
    void openOptionDialog();
    void loadSettings(bool bLoadDictionary = false);

private:
    Ui::Fastsms *ui;
    dictionary *m_dictionary;
    LayoutManager *m_layoutManager;
    TextProcessor *m_textProcessor;
    QDialog *m_dialNewWord;
    QLineEdit *m_inputNewWord;
    bool m_bDictionaryUpdated;

private slots:
    void saveDictionaryOnExit();
    void newWordInserted();
    void composite(QString,Core::Keyboards);

protected:
    bool registerService();

};

#endif // FASTSMS_H
