#ifndef PHONEBOOK_H
#define PHONEBOOK_H

#include <QWidget>

////////////////////////////////////NEW
#include <QContact>
#include <QContactManager>
#include <QContactPhoneNumber>
#include <QContactFetchRequest>
#include <QContactName>
#include <QContactDetailFilter>
//#include <QContactFilter>
#include <QContactUnionFilter>
#include <QDebug>
#include <QListWidgetItem>
#include "phonebook.h"
QTM_USE_NAMESPACE
////////////////////////////////

namespace Ui {
    class PhoneBook;
}

class PhoneBook : public QWidget
{
    Q_OBJECT

public:
    explicit PhoneBook(QWidget *parent = 0);
    ~PhoneBook();
    void updateContactsList(QString *sFilterText);

private:
    Ui::PhoneBook *ui;
//    QList<QContact> m_contacts;
    QList<QString> m_contacts;
    QContactFetchRequest *m_fetchRequest;
    void loadContacts();
    QContactManager *m_availableManagers;
    void open();


private slots:
    void contactsReady();
    void contactSelected(QListWidgetItem* item);

signals:
    void addRecipient(const QString sPhone, const QString sName);

};

#endif // PHONEBOOK_H
