#ifndef FASTSMS_H
#define FASTSMS_H

#include <QMainWindow>
#include <QtGui>
#include "dialogabout.h"
#include "dialogsettings.h"
#include "dictionary.h"
#include "layoutmanager.h"
#include "textprocessor.h"
#include "phonebook.h"



namespace Ui {
    class Fastsms;
}

class Fastsms : public QMainWindow
{
    Q_OBJECT

public:
    explicit Fastsms(QWidget *parent = 0);
    ~Fastsms();

public Q_SLOTS: // METHODS
    bool addRecipient(const QString &phone, const QString &name);

public slots:
    void insertNewWord();
    void openAboutDialog();
    void donate();
    void openOptionDialog();
    void loadSettings(bool bLoadDictionary = false);

private:
    Ui::Fastsms *ui;
    dictionary *m_dictionary;
    LayoutManager *m_layoutManager;
    TextProcessor *m_textProcessor;
    QDialog *m_dialNewWord;
    QLineEdit *m_inputNewWord;
    bool m_bDictionaryUpdated;
//    PhoneBook *m_phonebook;



private slots:
    void saveDictionaryOnExit();
    void newWordInserted();
    void composite(QString,Core::Keyboards);
//    void openPhoneBook();

protected:
    bool registerService();
};

#endif // FASTSMS_H
