#ifndef KEYBOARDMANAGER_H
#define KEYBOARDMANAGER_H

#include <QWidget>
#include <QSettings>
#include "core.h"

namespace Ui {
    class KeyboardManager;
}

class KeyboardManager : public QWidget
{
    Q_OBJECT

public:
    explicit KeyboardManager(QWidget *parent = 0);
    ~KeyboardManager();
    void enableQwerty();
    void enableAlfaNum();

public slots:
    void settingsChanged(int);
    void orientationChanged(QString);
    void processInput(QString, Core::Keyboards);

signals:
    void inputStyleChanged(int);
    void input(QString, Core::Keyboards);

private:
    Ui::KeyboardManager *ui;
    QString m_sCurrentOrientation;
    QSettings *m_settings;
};

#endif // KEYBOARDMANAGER_H
