#include "dialogsettings.h"
#include "ui_dialogsettings.h"

DialogSettings::DialogSettings(QWidget *parent) :
        QDialog(parent),
        ui(new Ui::DialogSettings)
{
    ui->setupUi(this);

    connect(ui->btSave,SIGNAL(clicked()),this,SLOT(closeOptions()));
    QSettings settings;

    //Populate list of available languages
    QDir dictDir(QApplication::applicationDirPath() + "/data");
    QStringList dictList = dictDir.entryList(QStringList("*.idc"));

    m_sCurrLang = settings.value(Core::SETTING_LANGUAGE,"").toString();
    for(int i=0; i<dictList.size(); i++)
    {
        if(!dictList.at(i).contains("user"))
        {
            ui->cbLanguage->addItem(dictList.at(i));

            if(dictList.at(i).compare(m_sCurrLang) == 0)
                ui->cbLanguage->setCurrentIndex(i);
        }
    }

    //Orientation
    ui->cOrientationAuto->setChecked(true);
    QString sCurrOrient = settings.value(Core::SETTING_ORIENTATION,Core::ORIENTATION_AUTO).toString();
    if(sCurrOrient.compare(Core::ORIENTATION_LANDSCAPE) == 0)
        ui->cOrientationLandscape->setChecked(true);
    else if(sCurrOrient.compare(Core::ORIENTATION_PORTRAIT) == 0)
        ui->cOrientationPortrait->setChecked(true);

    //Phonebook
    ui->cbPhonebook->setCurrentIndex(settings.value(Core::SETTING_PHONEBOOK,0).toInt());

    //Font
    ui->cbFontSize->setCurrentIndex(settings.value(Core::SETTING_FONTSIZE,0).toInt());
}

DialogSettings::~DialogSettings()
{
    delete ui;
}

/** Close option dialog and save options in m_settings file **/
void DialogSettings::closeOptions()
{
    bool isLanguageChanged = false;
    QSettings settings;

    //Language
    QString sDictFile = ui->cbLanguage->currentText();
    settings.setValue(Core::SETTING_LANGUAGE,sDictFile);
    if(sDictFile.compare(m_sCurrLang) != 0)
        isLanguageChanged = true;

    //Phonebook
    int nPhoneBook = ui->cbPhonebook->currentIndex();
    settings.setValue(Core::SETTING_PHONEBOOK,nPhoneBook);

    //Orientation
    if(ui->cOrientationAuto->isChecked())
        settings.setValue(Core::SETTING_ORIENTATION,Core::ORIENTATION_AUTO);
    else if(ui->cOrientationLandscape->isChecked())
        settings.setValue(Core::SETTING_ORIENTATION,Core::ORIENTATION_LANDSCAPE);
    else if(ui->cOrientationPortrait->isChecked())
        settings.setValue(Core::SETTING_ORIENTATION,Core::ORIENTATION_PORTRAIT);

    //Font size
    settings.setValue(Core::SETTING_FONTSIZE,ui->cbFontSize->currentIndex());

    close();

    emit settingsChanged(isLanguageChanged);
}
