/****************************************************************************
**
** Copyright (C) 2010  Aimone Davide realsportcars@hotmail.com
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#ifndef FASTSMS_H
#define FASTSMS_H

#include <QWidget>
#include <QtGui>
#include "dictionary.h"
#include "ui_dialogoptions.h"

class Button;

namespace Ui {
    class fastsms;
}

class fastsms : public QWidget
{
    Q_OBJECT

public:
    explicit fastsms(QWidget *parent = 0);
    ~fastsms();
    QList<QString> m_lWord;
    QTextEdit *m_smsEdit;
    QLineEdit *m_phoneNumber;
    dictionary *m_dict;

public Q_SLOTS: // METHODS
    bool addRecipient(const QString &phone, const QString &name);

protected:
    QString getWord(int nIndex);
    QLineEdit *inputNewWord;    
    QDialog* m_dialNewWord;
    void changeEvent(QEvent *e);
    bool registerService();

private slots:    
    void digitClicked();
    void nextWord();
    void prevWord();
    void sendSMS();
    void deleteChar();
    void insertNewWord();
    void newWordInserted();
    void saveDictionaryOnExit();
    void doNothing();
    void cursorPosChanged();
    void smsChanged();
    void openOptionDialog();
    void closeOptions();
    void moveCursorBt();
    void openPhoneBook();
    void openAboutDialog();

private:
    Ui::fastsms *m_ui;
    Ui::DialogOption m_uiOptions;
    Button *createButton(const QString &text, const char *member);
    void loadDict();
    void updateText(QString sWord);
    void addText(QString sWord);
    int m_nWordIndex;  
    bool m_bNeedSave;
    int m_nState;    
    QString m_sCompleteValue;
    QTextCursor m_cursorSmsText;
    QSettings *m_settings;
    QDialog *m_dialOptions;
    int m_nMsgLength;
    int m_nBeginWord;
    int m_nEndWord;
};

#endif // FASTSMS_H
