#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright (c) 2011 Marian Kluehspies <marian300@gmx.de>

# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:

# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.

# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.
#Importe

import sys
import time
import kissen
import pygame
import random
import osso
import dbus
#from PyQt4.phonon import Phonon
#import logging
import webbrowser
import subprocess
from PyQt4 import QtGui
from PyQt4.uic import loadUi


#Initialisierung der Module Pygame und Random

pygame.init()
random.seed()


#Logger einrichten
#logging.basicConfig(filename = "fartyprotokoll.log",
#                    level = logging.INFO,
#                    format = "%(asctime)s [%(levelname)-8s] %(message)s")


#Erstellen der Mainklasse
#vib=input("AN1/AUS0")

class MainWindow(QtGui.QMainWindow):
    def __init__(self, parent=None):
        QtGui.QMainWindow.__init__(self,parent)
       
        #MainWindow Initialisierung/Laden des Stylesheets
        self.ui=loadUi("/opt/farty/furzkissen.ui")
        self.ui.show()
        self.ui.showFullScreen()
        self.ui.viboff.setChecked(1)
        self.ui.vibon.setCheckable(True)
        
 
        #Vibration
        self._MCE_SERVICE = 'com.nokia.mce'
        self._MCE_REQUEST_PATH = '/com/nokia/mce/request'
        self._MCE_REQUEST_IF = 'com.nokia.mce.request'
        self._VIBRATE = 'req_vibrator_pattern_activate'
        self._VIBRATE_PATTERN= 'PatternChatAndEmail'
        self.osso_c = osso.Context('program', '1.0', False)
        self.rpc = osso.Rpc(self.osso_c)
        

        #Verstecken der Wolken, Aufruf durch Signal-Slot-System des Designers
        self.ui.wolke.hide()
        self.ui.wolke2.hide()
        self.ui.wolke3.hide()
       
        #Zuordnung der Buttons mit Verweis auf deren Methoden
       
        self.ui.fart.pressed.connect(self.fartrandom)
        self.ui.close.clicked.connect(self.closefunc)
        self.ui.minimize.clicked.connect(self.minimizefunc)
        self.ui.idea.clicked.connect(self.ideafunc)
        self.ui.about.clicked.connect(self.aboutfunc)
        self.ui.craveo.clicked.connect(self.craveobrowser)

        #Methoden
       
    def fartrandom(self):#Zufallsmechanismus für Abspielen der Furzsounds 10-81 
        
        if self.ui.vibon.isChecked():
            for _ in range(2):
                self.rpc.rpc_run(self._MCE_SERVICE, self._MCE_REQUEST_PATH,self._MCE_REQUEST_IF,
                                 self._VIBRATE,rpc_args=(self._VIBRATE_PATTERN,"",""),use_system_bus=True)
        else:
            pass        
        fartnumber=random.randint(10,81)
        path="/opt/farty/Furzsounds/furz0"+str(fartnumber)+".wav"
        sound=pygame.mixer.Sound(path)
        sound.play()
        pygame.time.delay(200)

       
    def closefunc(self):#Methode zum Schließen des Mainwindows
        sys.exit()
        
    def minimizefunc(self):#Experimentell, schließt statt zu minimieren
        subprocess.Popen(['dbus-send', '--type=signal', '--session', '/com/nokia/hildon_desktop', 'com.nokia.hildon_desktop.exit_app_view'])
                
         
    def ideafunc(self):
        QtGui.QMessageBox.about(self, "Farty the Farter:\n",
                 "Click me, in order to let me fart.\n"
                 "I can do more than 65 different\n"
                 "kind of fart sounds\n"
                 "Have fun and keep farting ;)\n")
    def craveobrowser(self):
        webbrowser.open("http://www.craveo.de")
        
    def aboutfunc(self):
        QtGui.QMessageBox.aboutQt(self) 
       
   
       
                            
    
app = QtGui.QApplication(sys.argv)
main = MainWindow()
sys.exit(app.exec_())
