/*
	This file is part of Faster Application Manager.

	Faster Application Manager is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Faster Application Manager is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Faster Application Manager.  If not, see <http://www.gnu.org/licenses/>.

	(C) Heikki Holstila 2010
*/

#include "sortselector.h"
#include "ui_sortselector.h"
#include "packageview.h"

SortSelector::SortSelector(PackageView::sortOrder currOrder, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SortSelector)
{
    ui->setupUi(this);

	if( currOrder == PackageView::SortAlpha )
		ui->radioButton_name->setChecked(true);
	else if( currOrder == PackageView::SortDateDesc )
		ui->radioButton_date->setChecked(true);
	else if( currOrder == PackageView::SortSizeDesc )
		ui->radioButton_size->setChecked(true);
}

SortSelector::~SortSelector()
{
    delete ui;
}

void SortSelector::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

PackageView::sortOrder SortSelector::selectedOperation()
{
	if( ui->radioButton_name->isChecked() )
		return PackageView::SortAlpha;
	else if( ui->radioButton_date->isChecked() )
		return PackageView::SortDateDesc;
	else if( ui->radioButton_size->isChecked() )
		return PackageView::SortSizeDesc;

	return PackageView::SortAlpha;
}
