/*
	This file is part of Faster Application Manager.

	Faster Application Manager is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Faster Application Manager is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Faster Application Manager.  If not, see <http://www.gnu.org/licenses/>.

	(C) Heikki Holstila 2010
*/

#ifndef ROTATINGBACKGROUND_H
#define ROTATINGBACKGROUND_H

#include <QWidget>

class RotatingBackground : public QWidget
{
    Q_OBJECT
public:
    explicit RotatingBackground(QWidget *parent = 0);
	virtual ~RotatingBackground();

	void loadWallpaper();
	void paintEvent(QPaintEvent*);
	void resizeEvent(QResizeEvent* event);

public slots:
	void orientationChanged();

private:
	RotatingBackground(const RotatingBackground& old);
	RotatingBackground operator= (const RotatingBackground& old);

	QPixmap iWallpaperLandscape;
	QPixmap iWallpaperPortrait;
};

#endif // ROTATINGBACKGROUND_H
