/*
	This file is part of Faster Application Manager.

	Faster Application Manager is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Faster Application Manager is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Faster Application Manager.  If not, see <http://www.gnu.org/licenses/>.

	(C) Heikki Holstila 2010
*/

#include "repoedit.h"
#include "ui_repoedit.h"
#include "repository.h"
#include "confirmdialog.h"
#include "aaptinterface.h"

RepoEdit::RepoEdit(AAptInterface* apt, Repository* repo, int pos, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::RepoEdit)
{
    ui->setupUi(this);
	iRepo = repo;
	iPos = pos;
	iAptInterface = apt;

	ui->lineEdit_name->setText( iRepo->name() );
	ui->lineEdit_url->setText( iRepo->url()+iRepo->dir() );
	ui->lineEdit_components->setText( iRepo->components() );
	ui->lineEdit_dist->setText( iRepo->dist() );
	ui->checkBox_Enabled->setChecked( iRepo->enabled() );
	iRevertEnabledTo = iRepo->enabled();

	on_lineEdit_name_textEdited("");
}

RepoEdit::~RepoEdit()
{
    delete ui;
}

void RepoEdit::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void RepoEdit::on_btn_OK_clicked()
{
		iRepo->set( ui->lineEdit_name->text().trimmed(), ui->lineEdit_url->text().trimmed(),
					ui->lineEdit_dist->text().trimmed(), ui->lineEdit_components->text().trimmed(),
					ui->checkBox_Enabled->isChecked() );

		accept();
}

void RepoEdit::on_btn_Delete_clicked()
{
	ConfirmDialog d(true, this);
	d.setText("Confirmation","Really delete this repository?");
	if( d.exec() ) {

		if( iRepo ) {
			delete iRepo;
			iAptInterface->repositories()->removeAt(iPos);
			iRepo = 0;
		}

		accept();
	}
}

void RepoEdit::on_lineEdit_name_textEdited(QString )
{
	QString n = ui->lineEdit_name->text();
	QString u = ui->lineEdit_url->text();

	if( n == "" || u == "" ) {
		ui->btn_OK->setEnabled(false);
		ui->checkBox_Enabled->setEnabled(false);
		ui->checkBox_Enabled->setChecked(false);
		return;
	}

	if( !u.contains("://") ) {
		ui->btn_OK->setEnabled(false);
		ui->checkBox_Enabled->setEnabled(false);
		ui->checkBox_Enabled->setChecked(false);
		return;
	}

	ui->btn_OK->setEnabled(true);
	ui->checkBox_Enabled->setEnabled(true);
	ui->checkBox_Enabled->setChecked(iRevertEnabledTo);
}

void RepoEdit::on_lineEdit_url_textEdited(QString )
{
	on_lineEdit_name_textEdited("");
}

void RepoEdit::on_checkBox_Enabled_clicked()
{
	iRevertEnabledTo = ui->checkBox_Enabled->isChecked();
}
