/*
	This file is part of Faster Application Manager.

	Faster Application Manager is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Faster Application Manager is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Faster Application Manager.  If not, see <http://www.gnu.org/licenses/>.

	(C) Heikki Holstila 2010
*/

#ifndef BLACKLISTSELECT_H
#define BLACKLISTSELECT_H

#include <QDialog>

class Package;

namespace Ui {
    class BlacklistSelect;
}

class BlacklistSelect : public QDialog
{
    Q_OBJECT

public:

	enum blackList { BlacklistNone, BlacklistThis, BlacklistAll };

	explicit BlacklistSelect(Package* pkg, QWidget *parent = 0);
	virtual ~BlacklistSelect();

protected:
    void changeEvent(QEvent *e);

private:
	BlacklistSelect(const BlacklistSelect& old);
	BlacklistSelect operator= (const BlacklistSelect& old);

    Ui::BlacklistSelect *ui;
	Package* iPkg;

private slots:
	void on_pushButton_Restore_clicked();
	void on_pushButton_This_clicked();
	void on_pushButton_Forever_clicked();
};

#endif // BLACKLISTSELECT_H
