/*
	This file is part of Faster Application Manager.

	Faster Application Manager is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Faster Application Manager is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Faster Application Manager.  If not, see <http://www.gnu.org/licenses/>.

	(C) Heikki Holstila 2010
*/

#include <QtGui>
#include "rotatingbackground.h"

RotatingBackground::RotatingBackground(QWidget *parent) :
    QWidget(parent)
{
	connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));
}

void RotatingBackground::loadWallpaper()
{
	QString loadfile = "/home/user/.backgrounds/background-1.png";
	QFileInfo custombg("/root/.fapman/wallpaper.png");
	bool custom = false;
	if( custombg.exists() ) {
		loadfile = "/root/.fapman/wallpaper.png";
		custom = true;
	}

	iWallpaperLandscape.load(loadfile);
	if( !iWallpaperLandscape.isNull() ) {
		QTransform t;
		t.rotate(90);
		iWallpaperPortrait = iWallpaperLandscape.transformed(t);
	}

	if( !custom && !iWallpaperLandscape.isNull() && !iWallpaperPortrait.isNull() )
	{
		QPainter l( &iWallpaperLandscape );
		QPainter p( &iWallpaperPortrait );

		QColor dim("black");
		dim.setAlpha(170);
		l.setBrush(dim);
		l.setPen(dim);
		p.setBrush(dim);
		p.setPen(dim);

		l.drawRect( 0, 0, iWallpaperLandscape.rect().width(), iWallpaperLandscape.rect().height() );
		p.drawRect( 0, 0, iWallpaperPortrait.rect().width(), iWallpaperPortrait.rect().height() );
	}
}

void RotatingBackground::paintEvent(QPaintEvent *)
{
	QPainter painter(this);

	painter.setPen( QApplication::palette().color(QPalette::Window) );
	painter.setBrush( QApplication::palette().color(QPalette::Window) );
	painter.drawRect(rect());

	if( rect().width() > rect().height() ) {
		if( !iWallpaperLandscape.isNull() )
			painter.drawPixmap(0,0,rect().width(), rect().height(),iWallpaperLandscape);
	} else {
		if( !iWallpaperPortrait.isNull() )
			painter.drawPixmap(0,0,rect().width(), rect().height(),iWallpaperPortrait);
	}
}

void RotatingBackground::resizeEvent(QResizeEvent *)
{
	this->resize( dynamic_cast<QWidget*>(parent())->size() );
}

void RotatingBackground::orientationChanged()
{
	resizeEvent(0);
}
