/*
Apt is copyright 1997, 1998, 1999 Jason Gunthorpe and others.
Apt is currently developed by APT Development Team <deity@lists.debian.org>.

License: GPLv2+

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

See /usr/share/common-licenses/GPL-2, or
<http://www.gnu.org/copyleft/gpl.txt> for the terms of the latest version
of the GNU General Public License.
*/

// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: debversion.h,v 1.3 2001/05/03 05:25:04 jgg Exp $
/* ######################################################################

   Debian Version - Versioning system for Debian

   This implements the standard Debian versioning system.
   
   ##################################################################### */
									/*}}}*/
#ifndef PKGLIB_DEBVERSION_H
#define PKGLIB_DEBVERSION_H



#include "version.h"
    
class debVersioningSystem : public pkgVersioningSystem
{     
   public:
   
   static int CmpFragment(const char *A, const char *AEnd, const char *B,
			  const char *BEnd);
   
   // Compare versions..
   virtual int DoCmpVersion(const char *A,const char *Aend,
			  const char *B,const char *Bend);
   virtual bool CheckDep(const char *PkgVer,int Op,const char *DepVer);
   virtual int DoCmpReleaseVer(const char *A,const char *Aend,
			     const char *B,const char *Bend)
   {
      return DoCmpVersion(A,Aend,B,Bend);
   }   
   virtual string UpstreamVersion(const char *A);

   debVersioningSystem();
};

extern debVersioningSystem debVS;

#ifdef APT_COMPATIBILITY
#if APT_COMPATIBILITY != 986
#warning "Using APT_COMPATIBILITY"
#endif

inline int pkgVersionCompare(const char *A, const char *B)
{
   return debVS.CmpVersion(A,B);
}
inline int pkgVersionCompare(const char *A, const char *AEnd, 
			     const char *B, const char *BEnd)
{
   return debVS.DoCmpVersion(A,AEnd,B,BEnd);
}
inline int pkgVersionCompare(string A,string B)
{
   return debVS.CmpVersion(A,B);
}
inline bool pkgCheckDep(const char *DepVer,const char *PkgVer,int Op)
{
   return debVS.CheckDep(PkgVer,Op,DepVer);
}
inline string pkgBaseVersion(const char *Ver)
{
   return debVS.UpstreamVersion(Ver);
}
#endif

#endif
