/*
	This file is part of Faster Application Manager.

	Faster Application Manager is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Faster Application Manager is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Faster Application Manager.  If not, see <http://www.gnu.org/licenses/>.

	(C) Heikki Holstila 2010
*/

#include "settings.h"
#include "ui_settings.h"
#include "mainwindow.h"

Settings::Settings(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Settings)
{
    ui->setupUi(this);

	iQSettings = new QSettings("/root/.fapman/settings.ini",QSettings::IniFormat);
}

Settings::~Settings()
{
	iQSettings->sync();
	delete iQSettings;
    delete ui;
}

void Settings::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void Settings::openWin()
{
	ui->checkBox_fetchdates->setChecked( iQSettings->value("fetch_dates", false).toBool() );
	ui->checkBox_autorotation->setChecked( iQSettings->value("disable_autorotation", false).toBool() );
	ui->checkBox_autoremove->setChecked( iQSettings->value("enable_autoremove", false).toBool() );
	ui->checkBox_autoclean->setChecked( iQSettings->value("enable_autoclean", false).toBool() );

	ui->checkBox_proxies->setChecked( iQSettings->value("use_proxies", false).toBool() );
	ui->lineEdit_http_proxy->setText(iQSettings->value("http_proxy","").toString() );
	ui->lineEdit_https_proxy->setText(iQSettings->value("https_proxy","").toString() );

	open();
}

void Settings::on_btn_OK_clicked()
{
	iQSettings->setValue("fetch_dates", ui->checkBox_fetchdates->isChecked() );
	iQSettings->setValue("disable_autorotation", ui->checkBox_autorotation->isChecked() );
	iQSettings->setValue("enable_autoremove", ui->checkBox_autoremove->isChecked() );
	iQSettings->setValue("enable_autoclean", ui->checkBox_autoclean->isChecked() );

	iQSettings->setValue("use_proxies", ui->checkBox_proxies->isChecked() );
	iQSettings->setValue("http_proxy", ui->lineEdit_http_proxy->text() );
	iQSettings->setValue("https_proxy", ui->lineEdit_https_proxy->text() );

#ifdef Q_WS_MAEMO_5
	if( !iQSettings->value("disable_autorotation",false).toBool() ) {
		dynamic_cast<MainWindow*>(this->parent())->setAttribute(Qt::WA_Maemo5AutoOrientation);
	} else {
		dynamic_cast<MainWindow*>(this->parent())->setAttribute(Qt::WA_Maemo5LandscapeOrientation);
	}
#endif

	accept();
}
