#ifndef REPOEDIT_H
#define REPOEDIT_H

#include <QDialog>

class Repository;
class AAptInterface;

namespace Ui {
    class RepoEdit;
}

class RepoEdit : public QDialog
{
    Q_OBJECT

public:
	explicit RepoEdit(AAptInterface* apt, Repository* repo, int pos, QWidget *parent = 0);
    ~RepoEdit();
#ifdef Q_WS_MAEMO_5		// workaround for buggy Qt autorotation
	int exec() {
		QRect r = dynamic_cast<QWidget*>(this->parent())->rect();
		if(r.width() < r.height())
			this->setAttribute(Qt::WA_Maemo5PortraitOrientation);
		int e = QDialog::exec();
		this->setAttribute(Qt::WA_Maemo5AutoOrientation);
		return e;
	}
#endif


protected:
    void changeEvent(QEvent *e);

private:
    Ui::RepoEdit *ui;
	Repository* iRepo;
	int iPos;
	AAptInterface* iAptInterface;


private slots:
	void on_lineEdit_url_textEdited(QString );
	void on_lineEdit_name_textEdited(QString );
	void on_btn_Delete_clicked();
	void on_btn_OK_clicked();
};

#endif // REPOEDIT_H
