#include "repoedit.h"
#include "ui_repoedit.h"
#include "repository.h"
#include "confirmdialog.h"
#include "aaptinterface.h"

RepoEdit::RepoEdit(AAptInterface* apt, Repository* repo, int pos, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::RepoEdit)
{
    ui->setupUi(this);
	iRepo = repo;
	iPos = pos;
	iAptInterface = apt;

	ui->lineEdit_name->setText( iRepo->name() );
	ui->lineEdit_url->setText( iRepo->url()+iRepo->dir() );
	ui->lineEdit_components->setText( iRepo->components() );
	ui->lineEdit_dist->setText( iRepo->dist() );
	ui->checkBox_Enabled->setChecked( iRepo->enabled() );

	on_lineEdit_name_textEdited("");
}

RepoEdit::~RepoEdit()
{
    delete ui;
}

void RepoEdit::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void RepoEdit::on_btn_OK_clicked()
{
		iRepo->set( ui->lineEdit_name->text(), ui->lineEdit_url->text(),
					ui->lineEdit_dist->text(), ui->lineEdit_components->text(),
					ui->checkBox_Enabled->isChecked() );

		accept();
}

void RepoEdit::on_btn_Delete_clicked()
{
	ConfirmDialog d(true, this);
	d.setText("Confirmation","Really delete this repository?");
	if( d.exec() ) {

		if( iRepo ) {
			delete iRepo;
			iAptInterface->repositories()->removeAt(iPos);
			iRepo = 0;
		}

		accept();
	}
}

void RepoEdit::on_lineEdit_name_textEdited(QString )
{
	QString n = ui->lineEdit_name->text();
	QString u = ui->lineEdit_url->text();

	if( n == "" || u == "" ) {
		ui->btn_OK->setEnabled(false);
		ui->checkBox_Enabled->setChecked(false);
		return;
	}

	if( !u.contains("://") ) {
		ui->btn_OK->setEnabled(false);
		ui->checkBox_Enabled->setChecked(false);
		return;
	}

	ui->btn_OK->setEnabled(true);
}

void RepoEdit::on_lineEdit_url_textEdited(QString )
{
	on_lineEdit_name_textEdited("");
}
