/*
	This file is part of Faster Application Manager.

	Faster Application Manager is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Faster Application Manager is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Faster Application Manager.  If not, see <http://www.gnu.org/licenses/>.

	(C) Heikki Holstila 2010
*/

#ifndef PACKAGE_H
#define PACKAGE_H

#include <QtCore>
class AAptInterface;
class Repository;

class Package
{
public:
	enum operation { PkgOpNone, PkgOpInstallUpgrade, PkgOpRemove };

	// the order must match status filter strings
	enum packageStatus { PkgStatUnknown, PkgStatNotInstalled, PkgStatUpgradeable, PkgStatInstalled };

	Package(QString name_, AAptInterface* apt_);
	~Package();
	void setName(QString n_) { iName=n_; }
	void setMaemoDisplayName(QString n_) { iMaemoDisplayName=n_; }
	void setInstalled(bool i_) { iIsInstalled=i_; }
	void setMarkedForOperation(operation op_);
	void setVersion(QString v_) { iVersion=v_; }
	void setDescShort(QString d_) { iDescriptionShort=d_; }
	void appendDescLong(QString d_) { iDescriptionLong.append(d_); }
	void setSection(QString s_) { iSection=s_; }
	void setSize(int i_) { iSize=i_; }
	void setInstalledSize(int i_) { iInstalledSize=i_; }
	void appendIconData(QByteArray d_) { iIconData.append(d_); }
	void setFileNameFull(QString f_) { iFileNameFull=f_; }
	void updateStatus();
	void addRepository(Repository* r_) { iRepositories.append(r_); }
	void setDate(QDateTime d_) { iDate=d_; }

	void convertIcon();

	QString name() { return iName; }
	QString maemoDisplayName() { return iMaemoDisplayName; }
	QString displayName();
	bool isInstalled() { return iIsInstalled; }
	bool isMarkedForOperation() { return iMarkedForOperation; }
	operation markedOperation() { return iMarkedOperation; }
	QString version() { return iVersion; }
	QString descShort() { return iDescriptionShort; }
	QString descLong() { return iDescriptionLong; }
	QString section() { return iSection; }
	int size() { return iSize; }
	int installedSize() { return iInstalledSize; }
	QPixmap* icon() { return iIcon; }
	bool hasIconData();
	bool isUpgradeable();
	QString upgradeableVersion();
	Package* availablePackage();
	packageStatus status();
	QString fileName() { return iFileNameFull.mid( iFileNameFull.lastIndexOf('/')+1 ); }
	QString fileNameFull() { return iFileNameFull; }
	QDateTime date() { return iDate; }
	QList<Repository*> repositories() { return iRepositories; }

	static bool versionCompare(QString isNewer, QString compare);

private:
	AAptInterface* iAptInterface;

	QString iName;
	QString iMaemoDisplayName;
	bool iIsInstalled;
	bool iMarkedForOperation;
	packageStatus iPkgStatus;
	QString iVersion;
	QString iDescriptionShort;
	QString iDescriptionLong;
	QString iSection;
	int iSize;
	int iInstalledSize;
	operation iMarkedOperation;
	QString iFileNameFull;
	QDateTime iDate;
	QList<Repository*> iRepositories;

	QByteArray iIconData;
	QPixmap* iIcon;

};

#endif // PACKAGE_H
