/*
	This file is part of Faster Application Manager.

	Faster Application Manager is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Faster Application Manager is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Faster Application Manager.  If not, see <http://www.gnu.org/licenses/>.

	(C) Heikki Holstila 2010
*/

#include <QtGui/QApplication>
#include "mainwindow.h"
#include "confirmdialog.h"

#ifdef Q_WS_MAEMO_5
#include <unistd.h>
#endif

int main(int argc, char *argv[])
{
    QApplication a(argc, argv);
    MainWindow w;
#if defined(Q_WS_S60)
    w.showMaximized();
#else
    w.show();
#endif

#ifdef Q_WS_MAEMO_5
	uid_t userUID = getuid();
	if( userUID != 0 ) {
		ConfirmDialog d(false, &w);
		d.setText("Warning", "You are not running the application as root. It won't' work as intended.");
		d.exec();
	}
#endif

    return a.exec();
}
