/*
	This file is part of Faster Application Manager.

	Faster Application Manager is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Faster Application Manager is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Faster Application Manager.  If not, see <http://www.gnu.org/licenses/>.

	(C) Heikki Holstila 2010
*/

#include <QtGui>
#include "repoview.h"
#include "ui_repoview.h"
#include "mainwindow.h"
#include "aptinterface.h"
#include "confirmdialog.h"

RepoView::RepoView(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::RepoView)
{
	iMainWindow = static_cast<MainWindow*>(parent);
	ui->setupUi(this);
#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5StackedWindow);
	this->setWindowFlags(Qt::Window);
	this->setAttribute(Qt::WA_Maemo5AutoOrientation);
#endif

	iModified = false;
}

RepoView::~RepoView()
{
    delete ui;
}

void RepoView::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void RepoView::openWin()
{
	iModified = false;
	QStringList repos = iAptInterface->getRepositories();

	ui->listWidget->clear();

	for( int i=0; i<repos.count(); i++ )
	{
		QString add = repos.at(i);
		if( add.startsWith("#") )
		{
			ui->listWidget->addItem( add.mid(1) );
		} else {
			ui->listWidget->addItem( add );
			ui->listWidget->item(i)->setSelected(true);
		}
		QSize s = ui->listWidget->item(i)->sizeHint();
		s.setHeight(60);
		s.setWidth(750);
		ui->listWidget->item(i)->setSizeHint( s );
		QFont f = ui->listWidget->item(i)->font();
		f.setPointSize( f.pointSize()-1 );
		ui->listWidget->item(i)->setFont(f);
	}

	show();
}

void RepoView::closeEvent(QCloseEvent *event)
{
	event->accept();

	if( iModified )
		iMainWindow->on_btnUpdate_clicked();
}

void RepoView::on_btnSave_clicked()
{
	QStringList repos;
	for( int i=0; i<ui->listWidget->count(); i++ )
	{
		if( ui->listWidget->item(i)->isSelected() )
			repos.append( ui->listWidget->item(i)->text() );
		else
			repos.append( "#" + ui->listWidget->item(i)->text() );
	}

	if( iAptInterface->writeRepositories( repos ) ) {
		iModified = true;
	} else {
		ConfirmDialog c(false, this);
		c.setText("Error","Unable to write repository list");
		c.exec();
	}
	this->close();
}
