/*
	This file is part of Faster Application Manager.

	Faster Application Manager is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Faster Application Manager is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Faster Application Manager.  If not, see <http://www.gnu.org/licenses/>.

	(C) Heikki Holstila 2010
*/

#include <QtGui>
#include <iostream>
#include "package.h"
#include "aptinterface.h"

Package::Package(QString name_, AptInterface *apt_)
{
	iAptInterface = apt_;
	iName = name_;
	iDescriptionShort = "";
	iDescriptionLong = "";
	iSection = "";
	iMaemoDisplayName = "";
	iVersionAvailable = "";
	iVersionInstalled = "";
	iIsInstalled = false;
	iIsLocal = false;
	iMarkedForOperation = false;
	iSize = 0;
	iInstalledSize = 0;
	iMarkedOperation = PkgOpNone;
	iPkgStatus = PkgStatUnknown;
	iIconData = "";
}

Package::~Package()
{
}

void Package::printDebugInfo()
{
	std::cout << iName.toStdString() << std::endl
			<< iMaemoDisplayName.toStdString() << std::endl
			<< "   " << iSection.toStdString() << std::endl
			<< "   " << iDescriptionShort.toStdString() << std::endl
			<< " i " << iVersionInstalled.toStdString() << std::endl
			<< " a " << iVersionAvailable.toStdString() << std::endl
			<< " s " << iSize << std::endl
			<< " i " << iInstalledSize << std::endl
			<< "installed:" << iIsInstalled << ", local:" << iIsLocal << ", marked:" << iMarkedForOperation << std::endl;

}

void Package::setMarkedForOperation(operation op_)
{
	if( iMarkedOperation != op_ ) {
		if( op_==PkgOpNone ) {
			iAptInterface->decreaseSelected();
		} else if( iMarkedOperation==PkgOpNone ) {
			iAptInterface->increaseSelected();
		}
	}

	iMarkedOperation = op_;

	if( op_ == PkgOpNone )
		iMarkedForOperation = false;
	else
		iMarkedForOperation = true;
}

void Package::convertIcon()
{
	if( iIconData.length() > 0 && iIcon.isNull() ) {
		iIconData = QByteArray::fromBase64( iIconData );
		iIcon.loadFromData( iIconData );
	}
}

bool Package::isUpgradeable()
{
	if( iIsInstalled && iVersionAvailable!=iVersionInstalled && iVersionAvailable!="" && !iIsLocal )
		return true;

	return false;
}

void Package::updateStatus()
{
	if( iIsInstalled ) {
		iPkgStatus = PkgStatInstalled;
		if( isUpgradeable() )
			iPkgStatus = PkgStatUpgradeable;
	} else {
		iPkgStatus = PkgStatNotInstalled;
	}
}

bool Package::hasIconData()
{
	if( iIconData.length()>0 )
		return true;
	else
		return false;
}
