#include <QtGui>
#include "repoview.h"
#include "ui_repoview.h"
#include "mainwindow.h"
#include "aptinterface.h"
#include "confirmdialog.h"

RepoView::RepoView(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::RepoView)
{
	iMainWindow = static_cast<MainWindow*>(parent);
	ui->setupUi(this);
#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5StackedWindow);
	this->setWindowFlags(Qt::Window);
	this->setAttribute(Qt::WA_Maemo5AutoOrientation);
#endif

	iModified = false;
}

RepoView::~RepoView()
{
    delete ui;
}

void RepoView::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void RepoView::openWin()
{
	iModified = false;
	QStringList repos = iAptInterface->getRepositories();

	ui->listWidget->clear();
	//ui->listWidget->addItems(repos);

	for( int i=0; i<repos.count(); i++ )
	{
		QString add = repos.at(i);
		if( add.startsWith("#") )
		{
			ui->listWidget->addItem( add.mid(1) );
		} else {
			ui->listWidget->addItem( add );
			ui->listWidget->item(i)->setSelected(true);
		}
	}

	show();
}

void RepoView::closeEvent(QCloseEvent *event)
{
	event->accept();

	if( iModified )
		iMainWindow->on_btnUpdate_clicked();
}

void RepoView::on_btnSave_clicked()
{
	QStringList repos;
	for( int i=0; i<ui->listWidget->count(); i++ )
	{
		if( ui->listWidget->item(i)->isSelected() )
			repos.append( ui->listWidget->item(i)->text() );
		else
			repos.append( "#" + ui->listWidget->item(i)->text() );
	}

	if( iAptInterface->writeRepositories( repos ) ) {
		iModified = true;
	} else {
		ConfirmDialog c(false, this);
		c.setText("Error","Unable to write repository list");
		c.exec();
	}
	this->close();
}
