/*
	This file is part of Faster Application Manager.

	Faster Application Manager is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Faster Application Manager is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Faster Application Manager.  If not, see <http://www.gnu.org/licenses/>.

	(C) Heikki Holstila 2010
*/

#ifndef PACKAGEVIEW_H
#define PACKAGEVIEW_H

#include <QtGui>
#include <QMainWindow>
#include "mainwindow.h"

namespace Ui {
    class PackageView;
}

class MainWindow;
class AptInterface;
class Package;
class dimmer;


enum UserRoles { UserRoleName=Qt::UserRole, UserRoleVerInst, UserRoleVerAvail, UserRoleDescShort, UserRoleOperation,
				 UserRoleMarked };


class PackageListWidgetItem : public QListWidgetItem
{
public:
	PackageListWidgetItem(Package* p_, QString name_);

	Package* package() { return iPackage; }

private:
	Package* iPackage;
};


class ListItemDelegate : public QStyledItemDelegate
{
public:
	ListItemDelegate(QObject *parent=0) : QStyledItemDelegate (parent) { }

	void paint (QPainter* painter, const QStyleOptionViewItem& option, const QModelIndex& index) const;
	QSize sizeHint(const QStyleOptionViewItem& option, const QModelIndex& index) const;
};


class PackageView : public QMainWindow
{
    Q_OBJECT

public:
    explicit PackageView(QWidget *parent = 0);
    ~PackageView();
	void openWin(MainWindow::operation op_);
	void setAptInterface(AptInterface* a_) { iAptInterface=a_; }	
	dimmer* dim() { return iDimmer; }
	void disableMenu();
	void enableMenu();
#ifdef Q_WS_MAEMO_5		// workaround for buggy Qt autorotation
	void show() {
		QRect r = static_cast<QMainWindow*>(this->parent())->rect();
		if(r.width() < r.height())
			this->setAttribute(Qt::WA_Maemo5PortraitOrientation);
		else
			this->setAttribute(Qt::WA_Maemo5AutoOrientation);
		QMainWindow::show();
	}
#endif

protected:
    void changeEvent(QEvent *e);
	AptInterface* iAptInterface;
	MainWindow::operation iOperation;
	void closeEvent(QCloseEvent *event);

private:
	void addListItem(Package* pkg_, QString listname_);
	void updateLabel(void);

    Ui::PackageView *ui;
	MainWindow* iMainWindow;
	QBoxLayout* iPkgLayout;
	QStringList iFilterLabels;
	QStringList iFilterStrings;
	int iSelectedFilter;
	int iDefaultFilter;
	bool iDontSelect;
	dimmer* iDimmer;

	static const int FilterAllMarked = 0;
	static const int FilterAllUser = 1;

private slots:
	void on_btn_Filter_clicked();
	void on_listWidget_itemClicked(QListWidgetItem* item);
	void on_actionSearch_triggered();
	void on_actionFilter_triggered();
	void on_actionRefresh_list_triggered();
	void on_actionClear_selections_triggered();
	void on_btn_Commit_clicked();
};

#endif // PACKAGEVIEW_H
