/*
	This file is part of Faster Application Manager.

	Faster Application Manager is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Faster Application Manager is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Faster Application Manager.  If not, see <http://www.gnu.org/licenses/>.

	(C) Heikki Holstila 2010
*/

#ifndef DIMMER_H
#define DIMMER_H

#include <QtGui>

class dimmer : public QWidget
{
    Q_OBJECT
public:
    explicit dimmer(QWidget *parent = 0);
	void paintEvent(QPaintEvent *);
	void resizeEvent(QResizeEvent *);

	void dim(QString title, QString message);
	void undim();
	bool busy() { return iBusy; }

private:
	int iAlpha;
	QWidget* iParent;
	QBoxLayout* iLayout;
	QLabel* iLabel;
	bool iBusy;

signals:

public slots:

};

#endif // DIMMER_H
