/*
	This file is part of Faster Application Manager.

	Faster Application Manager is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Faster Application Manager is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Faster Application Manager.  If not, see <http://www.gnu.org/licenses/>.

	(C) Heikki Holstila 2010
*/

#ifndef APTINTERFACE_H
#define APTINTERFACE_H

#include <QtCore>

class MainWindow;
class PackageView;
class Package;


const QString KlogFileDir = "/root/.fapman";
const QString KlogFileName = "/root/.fapman/lastlog.txt";


class AptInterface : public QObject
{
	Q_OBJECT

public:
	AptInterface(MainWindow* w_);
	~AptInterface();

	void setPackageView(PackageView* p_) { iWinPackageView = p_; }
	bool isInterfaceReady();
	void updateCatalogs();
	void updatePackageList();
	void installPackages(QStringList names_);
	void removePackages(QStringList names_);
	void simulateInstall(QStringList names_);
	void simulateRemove(QStringList names_);
	void aptGetClean();
	int selectedCount() { return iSelectedCount; }
	void increaseSelected() { iSelectedCount++; }
	void decreaseSelected() { iSelectedCount--; }
	void resetSelectedCount() { iSelectedCount=0; }
	QHash<QString, Package*>* packages() { return &iPackages; }
	void getSimulatedPackageLists(QStringList& inst_, QStringList& remv_) { inst_=toInstall; remv_=toRemove; }
	void getOriginalPackageList(QStringList& names_) { names_=pkgNamesList; }

	void logToFile( QByteArray data );

	enum aptMode { ModeNone, ModeReadInfo, ModeAptGetUpdate, ModeAptGetInstall, ModeAptGetRemove,
				   ModeAptGetSimulateInstall, ModeAptGetSimulateRemove, ModeAptGetClean };

private:
	bool parseAptCacheOutput();
	bool readDpkgDatabase();
	bool parseSimulated();

	QHash<QString, Package*> iPackages;

	MainWindow* iMainWindow;
	PackageView* iWinPackageView;
	QProcess* iRunProc;
	aptMode iMode;
	bool iReady;
	int iSelectedCount;
	QString iError;

	QStringList toInstall;
	QStringList toRemove;
	QStringList pkgNamesList;

private slots:
	void procError(QProcess::ProcessError error);
	void procFinished(int exitCode, QProcess::ExitStatus exitStatus);

};

#endif // APTINTERFACE_H
