/*
	This file is part of Faster Application Manager.

	Faster Application Manager is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Faster Application Manager is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Faster Application Manager.  If not, see <http://www.gnu.org/licenses/>.

	(C) Heikki Holstila 2010
*/

#include <QtGui>
#include "dimmer.h"

dimmer::dimmer(QWidget *parent) :
    QWidget(parent)
{
	iParent = parent;
	iAlpha = 215;
	iLayout = new QVBoxLayout(this);
	iLabel = new QLabel(this);
	iLabel->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);
	iLabel->setAlignment(Qt::AlignCenter);
	iLayout->addWidget(iLabel);
	QProgressBar* p = new QProgressBar(this);
	p->setMinimum(0);
	p->setMaximum(0);
	iLayout->addWidget(p);
	hide();
}

void dimmer::paintEvent(QPaintEvent *)
{
	QPainter painter(this);
	QColor dim("black");
	dim.setAlpha(iAlpha);
	painter.setPen(dim);
	painter.setBrush(dim);
	painter.drawRect(this->rect());
	show();
}

void dimmer::resizeEvent(QResizeEvent *)
{
	this->resize(iParent->size());
	iLayout->setGeometry(iParent->rect());
	iLayout->setSizeConstraint(QLayout::SetMaximumSize);
}

void dimmer::dim(QString title, QString message)
{
	iBusy = true;
	iLabel->setText("<font color=\"white\"><b><u>" + title + "</u></b><br><br>" + message + "</font>");
	show();
}

void dimmer::undim()
{
	iBusy = false;
	hide();
}
