/*
	This file is part of Faster Application Manager.

	Faster Application Manager is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Faster Application Manager is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Faster Application Manager.  If not, see <http://www.gnu.org/licenses/>.

	(C) Heikki Holstila 2010
*/

#ifndef PACKAGE_H
#define PACKAGE_H

#include <QtCore>

class Package
{
public:
	Package(QString name_);
	~Package();
	void setMaemoDisplayName(QString n_) { iMaemoDisplayName=n_; }
	void setInstalled(bool i_) { iIsInstalled=i_; }
	void setLocal(bool l_) { iIsLocal=l_; }
	void setMarkedForOperation(bool o_) { iMarkedForOperation=o_; }
	void setVersionInstalled(QString v_) { iVersionInstalled=v_; }
	void setVersionAvailable(QString v_) { iVersionAvailable=v_; }
	void setDescShort(QString d_) { iDescriptionShort=d_; }
	void setDescLong(QString d_) { iDescriptionLong=d_; }
	void setSection(QString s_) { iSection=s_; }
	QString name() { return iName; }
	QString maemoDisplayName() { return iMaemoDisplayName; }
	bool isInstalled() { return iIsInstalled; }
	bool isLocal() { return iIsLocal; }
	bool isMarkedForOperation() { return iMarkedForOperation; }
	QString versionInstalled() { return iVersionInstalled; }
	QString versionAvailable() { return iVersionAvailable; }
	QString descShort() { return iDescriptionShort; }
	QString descLong() { return iDescriptionLong; }
	QString section() { return iSection; }

private:
	QString iName;
	QString iMaemoDisplayName;
	bool iIsInstalled;
	bool iIsLocal;
	bool iMarkedForOperation;
	QString iVersionAvailable;
	QString iVersionInstalled;
	QString iDescriptionShort;
	QString iDescriptionLong;
	QString iSection;

};

#endif // PACKAGE_H
