/*******************************************************************************

 This file is a part of Fahrplan for maemo 2009-2010

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/*
 ============================================================================
 Name        : fahrplan_parser_mvvmuenchen.c
 Author      : smurfy
 Version     : 0.1
 Description : mvv-muenchen Backend
 ============================================================================
 */
#include "fahrplan_utils.h"
#include "fahrplan_parser_mvvmuenchen.h"

GArray * getStationsByName_mvvmuenchen(gchar *stationName) {

	gchar * postData =	g_strdup_printf("sessionID=0&requestID=0&language=en&command=&ptOptionsActive=0&place_origin=&placeState_origin=empty&type_origin=stop&name_origin=%s&nameState_origin=empty&place_destination=&placeState_destination=empty&type_destination=stop&name_destination=&nameState_destination=empty&place_via=&placeState_via=empty&type_via=stop&name_via=", stationName);
	gchar * url      = "http://efa.mvv-muenchen.de/bcl/XSLT_TRIP_REQUEST2";
	gchar * result   = performCurlRequest(url, postData);

	if (!result) {

		return NULL;
	}

	GArray *garray;

	garray = g_array_new (TRUE, TRUE, sizeof (gchar *));

	char *selectBoxFrom = strstr(result,
			"<select name=\"name_origin\" acceskey=\"s\">");

	/* more than one result found */
	if (selectBoxFrom) {

		char *selectBoxTo = strstr(selectBoxFrom, "</select>");
		int count = selectBoxTo - selectBoxFrom + 9;
		char options[count];
		strncpy(options, selectBoxFrom, count);

		options[count] = '\0';

		/* g_debug("RESULT: %s", options); */

		xmlDoc *doc = NULL;
		xmlNode *root_element = NULL;

		/*parse the file and get the DOM */
		doc = xmlReadDoc(options, NULL, "ISO-8859-1", 0);

		/*Get the root element node */
		root_element = xmlDocGetRootElement(doc);

		xmlNode *cur_node = NULL;
		xmlNode *sub_node = NULL;

		for (cur_node = root_element->children; cur_node; cur_node = cur_node->next) {

			if (cur_node->type == XML_ELEMENT_NODE && !strcmp(cur_node->name, "div")) {

				for (sub_node = cur_node->children; sub_node; sub_node = sub_node->next) {

					if (sub_node->type == XML_ELEMENT_NODE && !strcmp(sub_node->name, "option")) {

						gchar *stationEntry = g_strdup_printf(sub_node->children->content);

						g_array_append_val (garray, stationEntry);
					}
				}
			}
		}

		/*free the document */
		xmlFreeDoc(doc);

	} else {

		selectBoxFrom = strstr(result, "<input type=\"hidden\" name=\"nameState_origin\" value=\"identified\">");

		if (selectBoxFrom) {

			selectBoxFrom += 64;
			char *selectBoxTo = strstr(selectBoxFrom, "</div>");
			int count = selectBoxTo - selectBoxFrom;
			char options[count];
			strncpy(options, selectBoxFrom, count);

			options[count] = '\0';

			gchar *stationEntry = g_strdup_printf(options);

			g_array_append_val (garray, stationEntry);

		} else {

			return NULL;
		}
	}

	return garray;
}

GArray * getStationsByGPS_mvvmuenchen(gint longitude, gint latitude) {

	return NULL;
}

ResultInfo * getJourneyData_mvvmuenchen(gchar *fromStation, gchar *viaStation, gchar *toStation, gint day, gint month, gint year, gint hour, gint minutes, gint options) {

	gchar * optionStr = "dep";
	if (options == 0) {

		optionStr = "arr";
	}
	gchar * postData = g_strdup_printf("sessionID=0&requestID=&language=en&usage=xslt_trip&command=&ptOptionsActive=0&itdDateDay=%d&itdDateMonth=%d&itdDateYear=%d&place_origin=&placeState_origin=empty&type_origin=stop&name_origin=%s&nameState_origin=empty&place_destination=&placeState_destination=empty&type_destination=stop&name_destination=%s&nameState_destination=empty&place_via=&placeState_via=empty&type_via=stop&name_via=&nameState_via=empty&itdTripDateTimeDepArr=%s&itdTimeHour=%d&itdTimeMinute=%d", day, month, year, fromStation, toStation, optionStr, hour, minutes);
	gchar * url      = "http://efa.mvv-muenchen.de/mobile/XSLT_TRIP_REQUEST2";
	gchar * result   = performCurlRequest(url, postData);

	if (!result) {

		return NULL;
	}

	g_debug("res: %s", result);

	ResultInfo *resultInfo;

	resultInfo = g_new0 (ResultInfo, 1);

	/* Header */

	char *dataFrom = strstr(result, "<b>Date:");

	if (dataFrom) {

		char *dataTo = strstr(dataFrom, "</td>");
		int count = dataTo - dataFrom;
		char headData[count];
		strncpy(headData, dataFrom, count);

		headData[count] = '\0';

		gchar *reqData = g_strdup_printf("<div>%s</div>", headData);

		xmlDoc *doc = NULL;
		xmlNode *root_element = NULL;

		/*parse the file and get the DOM */
		doc = xmlReadDoc(reqData, NULL, "ISO-8859-1", 0);

		g_free(reqData);

		/*Get the root element node */
		root_element = xmlDocGetRootElement(doc);

		xmlNode *cur_node = NULL;

		for (cur_node = root_element->children; cur_node; cur_node = cur_node->next) {

			if (!strcmp(cur_node->name, "text")) {

				removeLineBreaks(cur_node->content);
				resultInfo->headerTimeInfo = g_strdup_printf(cur_node->content);
			}
		}

		g_free(doc);
	}

	dataFrom = strstr(result, "<b>From:");

	if (dataFrom) {

		char *dataTo = strstr(dataFrom, "<br />");
		int count = dataTo - dataFrom + 6;
		char headData[count];
		strncpy(headData, dataFrom, count);

		headData[count] = '\0';

		gchar *reqData = g_strdup_printf("<div>%s</div>", headData);

		xmlDoc *doc = NULL;
		xmlNode *root_element = NULL;

		/*parse the file and get the DOM */
		doc = xmlReadDoc(reqData, NULL, "ISO-8859-1", 0);

		g_free(reqData);

		/*Get the root element node */
		root_element = xmlDocGetRootElement(doc);

		xmlNode *cur_node = NULL;

		for (cur_node = root_element->children; cur_node; cur_node = cur_node->next) {

			if (!strcmp(cur_node->name, "text")) {

				removeLineBreaks(cur_node->content);
				resultInfo->headerFromStation = g_strdup_printf(cur_node->content);
			}
		}

		g_free(doc);
	}


	dataFrom = strstr(result, "<b>To:");

	if (dataFrom) {

		char *dataTo = strstr(dataFrom, "<br />");
		int count = dataTo - dataFrom + 6;
		char headData[count];
		strncpy(headData, dataFrom, count);

		headData[count] = '\0';

		gchar *reqData = g_strdup_printf("<div>%s</div>", headData);

		xmlDoc *doc = NULL;
		xmlNode *root_element = NULL;

		/*parse the file and get the DOM */
		doc = xmlReadDoc(reqData, NULL, "ISO-8859-1", 0);

		g_free(reqData);

		/*Get the root element node */
		root_element = xmlDocGetRootElement(doc);

		xmlNode *cur_node = NULL;

		for (cur_node = root_element->children; cur_node; cur_node = cur_node->next) {

			if (!strcmp(cur_node->name, "text")) {

				removeLineBreaks(cur_node->content);
				resultInfo->headerToStation = g_strdup_printf(cur_node->content);
			}
		}

		g_free(doc);
	}

	/* later button */
	dataFrom = strstr(result, "<input type=\"hidden\" name=\"sessionID\" value=\"");

	if (dataFrom) {

		dataFrom += 45;

		char *dataTo = strstr(dataFrom, "\" />");
		int count = dataTo - dataFrom;
		char headData[count];
		strncpy(headData, dataFrom, count);

		headData[count] = '\0';

		resultInfo->headerEarlierUrl = g_strdup_printf("http://efa.mvv-muenchen.de/mobile/XSLT_TRIP_REQUEST2?language=en&sessionID=%s&requestID=1&command=tripLast", headData);
		resultInfo->headerLaterUrl = g_strdup_printf("http://efa.mvv-muenchen.de/mobile/XSLT_TRIP_REQUEST2?language=en&sessionID=%s&requestID=1&command=tripNext", headData);
	}

	/* Results Itself */
	dataFrom = strstr(result, "<div style=\"background-color:");

	if (dataFrom) {

		GArray *garray;

		garray = g_array_new (TRUE, TRUE, sizeof (ResultItem *));

		char *dataTo = strstr(dataFrom, "</td>");
		int count = dataTo - dataFrom;
		char headData[count];
		strncpy(headData, dataFrom, count);

		headData[count] = '\0';

		gchar *reqData = g_strdup_printf("<div>%s</div>", headData);

		xmlDoc *doc = NULL;
		xmlNode *root_element = NULL;

		/*parse the file and get the DOM */
		doc = xmlReadDoc(reqData, NULL, "ISO-8859-1", 0);

		g_free(reqData);

		/*Get the root element node */
		root_element = xmlDocGetRootElement(doc);

		xmlNode *cur_node = NULL;
		xmlNode *sub_node = NULL;
		xmlAttr *cur_attribute = NULL;

		for (cur_node = root_element->children; cur_node; cur_node = cur_node->next) {

			if (!strcmp(cur_node->name, "div")) {

				g_debug("NODE: %s", cur_node->name);
				gint found = 0;
				ResultItem *resultItem;

				resultItem = g_new0 (ResultItem, 1);

				for (sub_node = cur_node->children; sub_node; sub_node = sub_node->next) {

					g_debug("SUBNODE: %s", sub_node->name);

					if (!strcmp(sub_node->name, "text")) {

						char *transfersFrom =
									strstr(sub_node->content, "Changes");

						if (transfersFrom) {

							transfersFrom += 8;
							resultItem->changeStr = transfersFrom;
						}
					}

					if (!strcmp(sub_node->name, "img")) {

						for (cur_attribute = sub_node->properties; cur_attribute; cur_attribute
															= cur_attribute->next) {

								if (!strcmp(cur_attribute->name, "alt")) {

									gchar *tmpStr = g_strdup_printf(cur_attribute->children->content);
									if (resultItem->trainTypeStr) {

										tmpStr = g_strdup_printf("%s, %s", resultItem->trainTypeStr , cur_attribute->children->content);
									}
									resultItem->trainTypeStr = tmpStr;
								}
							}
					}

					if (found == 0 && !strcmp(sub_node->name, "a")) {

						found = 1;
						for (cur_attribute = sub_node->properties; cur_attribute; cur_attribute
														= cur_attribute->next) {

							if (!strcmp(cur_attribute->name, "href")) {

								resultItem->trainTypeStr = g_strdup_printf(cur_attribute->children->content);
							}
						}

						char *timeFrom =
									strstr(sub_node->children->content, " - ");

						if (timeFrom) {

							char *timeTo = timeFrom;
							timeTo += strlen(timeTo) - 5;
							char cleanTimeFrom[5];
							strncpy(cleanTimeFrom, sub_node->children->content, 5);
							cleanTimeFrom[5] = '\0';

							resultItem->fromTimeStr = g_strdup_printf(cleanTimeFrom);
							resultItem->toTimeStr = g_strdup_printf(timeTo);
						}
					}
				}

				resultItem->warningStr = "";
				g_array_append_val (garray, resultItem);
			}
		}

		resultInfo->items = garray;
	}

	return resultInfo;
}

ResultInfo * getJourneyDataByUrl_mvvmuenchen(gchar *url) {

	g_debug("URL CALL: %s", url);
	return NULL;
}

DetailInfo * getJourneyDetailDataByUrl_mvvmuenchen(gchar *url) {

	return NULL;
}
