/*******************************************************************************

 This file is a part of Fahrplan for maemo 2009-2010

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/*
 ============================================================================
 Name        : fahrplan_parser_gisgraphy.c
 Author      : qbast, smurfy
 Version     : 0.1
 Description : Fallback backend for GPS Data based on gisgraphy
 ============================================================================
 */
#include "fahrplan_utils.h"
#include "fahrplan_parser_gisgraphy.h"

gchar * getCityNameByGPS(gfloat longitude, gfloat latitude)
{
	char* oldloc=setlocale(LC_NUMERIC,"C");
	gchar * url = g_strdup_printf("http://services.gisgraphy.com/geoloc/findnearbylocation?lng=%f&lat=%f&from=1&to=1&format=xml&placetype=city", longitude, latitude);
	setlocale(LC_NUMERIC,oldloc);
	gchar * result   = performCurlRequest(url, NULL);

	g_debug(result);

	if (!result) {

		return NULL;
	}

	/* there will be only one result, so don't bother parsing XML */
	gchar* start=strstr(result,"<name>");
	if (!start) {
		return NULL;
	}
	start+=6;
	gchar* end=strstr(start,"</name>");
	if (!end) {
		return NULL;
	}

	return strndup(start,(end-start));
}
