/*******************************************************************************

 This file is a part of Fahrplan for maemo 2009-2010

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/*
 ============================================================================
 Name        : fahrplan_parser.c
 Author      : smurfy
 Version     : 0.1
 Description : Loader for the backends, currently only mobile.bahn.de
 ============================================================================
 */
#include "fahrplan_utils.h"
#include "fahrplan_parser.h"
#include "fahrplan_parser_mobilebahnde.h"
#include "fahrplan_parser_mvvmuenchen.h"

/**
 * Wrapper function for the different backend functions
 * @todo: adding switch to call based on settings different backends
 */
GArray * getStationsByName(gchar * stationName, AppData * data) {

	/* return getStationsByName_mvvmuenchen(stationName); */
	return getStationsByName_mobilebahnde(stationName);
}

/**
 * Wrapper function for the different backend functions
 * @todo: adding switch to call based on settings different backends
 */
GArray * getStationsByGPS(gint longitude, gint latitude, AppData * data) {

	/* return getStationsByGPS_mvvmuenchen(longitude, latitude); */
	return getStationsByGPS_mobilebahnde(longitude, latitude);
}

/**
 * Wrapper function for the different backend functions
 * @todo: adding switch to call based on settings different backends
 */
ResultInfo * getJourneyData(gchar *fromStation, gchar *viaStation, gchar *toStation, gint day, gint month, gint year, gint hour, gint minutes, gint options, AppData * data) {

	/* return getJourneyData_mvvmuenchen(fromStation, NULL, toStation, day, month, year, hour, minutes, options); */
	return getJourneyData_mobilebahnde(fromStation, NULL, toStation, day, month, year, hour, minutes, options);
}

/**
 * Wrapper function for the different backend functions
 * @todo: adding switch to call based on settings different backends
 */
ResultInfo * getJourneyDataByUrl(gchar *url, AppData * data) {

	/* return getJourneyDataByUrl_mvvmuenchen(url); */
	return getJourneyDataByUrl_mobilebahnde(url);
}

/**
 * Wrapper function for the different backend functions
 * @todo: adding switch to call based on settings different backends
 */
DetailInfo * getJourneyDetailDataByUrl(gchar *url, AppData * data) {

	/* return getJourneyDetailDataByUrl_mvvmuenchen(url); */
	return getJourneyDetailDataByUrl_mobilebahnde(url);
}
