/*******************************************************************************

 This file is a part of Fahrplan for maemo 2009-2010

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 ============================================================================
 Name        : fahrplan_utils.h
 Author      : smurfy
 Version     : 0.1
 Description : utility function and basic declarations
 ============================================================================
 */

#ifndef _fahrplan_utils_h
#define _fahrplan_utils_h 1

#include <hildon/hildon.h>
#include <hildon/hildon-button.h>
#include <hildon/hildon-program.h>
#include <hildon/hildon-picker-button.h>
#include <location/location-gps-device.h>
#include <location/location-gpsd-control.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/socket.h>
#include <curl/curl.h>

#define APP_NAME "fahrplan"
#define APP_VER "0.0.6"
#define APP_SERVICE "com.nokia.fahrplan"
#define APP_METHOD "/com/nokia/fahrplan"

typedef struct _DetailItem DetailItem;
struct _DetailItem {

	gchar *fromStr;
	gchar *timeFromStr;
	gchar *toStr;
	gchar *timeToStr;
	gchar *trainStr;
	gchar *infoStr;
	gchar *alternateStr;
};

typedef struct _DetailInfo DetailInfo;
struct _DetailInfo {

	gchar *errorMsg;
	gchar *departureStr;
	gchar *arrivalStr;
	gchar *durationStr;
	gchar *infoStr;
	gchar *pricingStr;
	GArray *items;
};

typedef struct _ResultItem ResultItem;
struct _ResultItem {

	gchar *fromTimeStr;
	gchar *toTimeStr;
	gchar *trainTypeStr;
	gchar *changeStr;
	gchar *warningStr;
	gchar *detailsUrl;
};

typedef struct _ResultInfo ResultInfo;
struct _ResultInfo {

	gchar *errorMsg;
	gchar *headerFromStation;
	gchar *headerToStation;
	gchar *headerTimeInfo;
	gchar *headerEarlierUrl;
	gchar *headerLaterUrl;
	GArray *items;
};


/* Application UI data struct */
typedef struct _AppData AppData;
struct _AppData {
	HildonProgram *program;
	HildonWindow *departureWindow;
	HildonWindow *journeyWindow;
	HildonWindow *resultWindow;
	HildonWindow *detailsWindow;

	GtkWidget *verticalContainer;
	GtkWidget *fromContainer;
	GtkWidget *fromSelector;
	GtkWidget *fromButton;
	GtkWidget *fromLabel;
	GtkWidget *toContainer;
	GtkWidget *toSelector;
	GtkWidget *toButton;
	GtkWidget *toLabel;
	GtkWidget *timeContainer;
	GtkWidget *timeDateButton;
	GtkWidget *timeTimeButton;
	GtkWidget *optionsButton;
	GtkWidget *optionsSelector;
	GtkWidget *searchButton;

	GtkWidget *currentDialog;
	GtkWidget *currentSearchTextBox;
	GtkWidget *currentSelector;
	GtkWidget *currentTmpPicker;
	GtkWidget *currentSelectorFor;
	GtkWidget *currentResultPannableArea;
	GtkWidget *currentResultMainVbox;
	ResultInfo *currentResult;
	GtkWidget *currentDetailsPannableArea;
	GtkWidget *currentDetailsMainVbox;

	LocationGPSDControl *currentGPSControl;

	char currentResultBaseUrl[255];
};

/**
 * Structure for CURL Data used in combination of copyDataBuffer
 * to store the curl response.
 */
struct CURLData {
	char *buf;
	size_t pos;
	size_t size;
};

GArray * performRegex(gchar *regex, gchar *string);
char * stringReplace( const char *string, const char *substr, const char *replacement );
void removeLineBreaks(char *string);
size_t copyDataBuffer(void *ptr, size_t size, size_t nmemb, void *ctx);
gchar * performCurlRequest(gchar *targetUrl, gchar *postData);
int arrayAddItem(int *array, gpointer item);

#endif
