/*******************************************************************************

 This file is a part of Fahrplan for maemo 2009-2010

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 ============================================================================
 Name        : fahrplan_utils.c
 Author      : smurfy
 Version     : 0.1
 Description : utility function and basic declarations
 ============================================================================
 */

#include "fahrplan_utils.h"

/**
 * Simple String replace function
 */
char * stringReplace( const char *string, const char *substr, const char *replacement ) {

	char *tok = NULL;
	char *newstr = NULL;
	tok = strstr( string, substr );
	if( tok == NULL ) return strdup( string );
	newstr = malloc( strlen( string ) - strlen( substr ) + strlen( replacement ) + 1 );
	if( newstr == NULL ) return NULL;
	memcpy( newstr, string, tok - string );
	memcpy( newstr + (tok - string), replacement, strlen( replacement ) );
	memcpy( newstr + (tok - string) + strlen( replacement ), tok + strlen( substr ), strlen( string ) - strlen( substr ) - ( tok - string ) );
	memset( newstr + strlen( string ) - strlen( substr ) + strlen( replacement ), 0, 1 );
	return newstr;
}

/**
 * Simple function which removes line breaks from the given string.
 */
void removeLineBreaks(char *string) {

	unsigned int i = 0;
	for(i = 0; i < strlen(string); ++i){
		if (string[i] == '\n'){
			string[i] = ' ';
		}
	}
}

/**
 * Copys data from internal curl buffer to our own buffer.
 */
size_t copyDataBuffer(void *ptr, size_t size, size_t nmemb, void *ctx) {
	struct CURLData *bufData = ctx;

	if (bufData->pos + size * nmemb > bufData->size) {

		/* overflow */
		return 0;
	}

	memcpy(&bufData->buf[bufData->pos], ptr, size * nmemb);
	bufData->pos += size * nmemb;
	return size * nmemb;
}

/**
 * Performs a Curl Http request
 */
gchar * performCurlRequest(gchar *targetUrl, gchar *postData) {

	/* Start Curl search */
	CURL *curl;
	CURLcode res;
	char buf[50000];
	struct CURLData curldata;

	curldata.buf = buf;
	curldata.size = 50000;
	curldata.pos = 0;

	curl = curl_easy_init();
	if (curl) {

		curl_easy_setopt(curl, CURLOPT_URL, targetUrl);
		curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, &copyDataBuffer);
		curl_easy_setopt(curl, CURLOPT_WRITEDATA, &curldata);
		curl_easy_setopt(curl, CURLOPT_FAILONERROR, 1);
		curl_easy_setopt(curl, CURLOPT_TIMEOUT, 150L);
		curl_easy_setopt(curl, CURLOPT_CONNECTTIMEOUT, 15L);
		if (postData) {

			curl_easy_setopt(curl, CURLOPT_POSTFIELDS, postData);
		}

		res = curl_easy_perform(curl);

		if (res != CURLE_OK) {

			g_debug("CURL_ERROR: %d", res);

			return NULL;
		}

		return curldata.buf;
	}
}
