/*******************************************************************************

 This file is a part of Fahrplan for maemo 2009-2010

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/*
 ============================================================================
 Name        : fahrplan_parser_mobilebahnde.c
 Author      : smurfy
 Version     : 0.1
 Description : mobile.bahn.de Backend
 ============================================================================
 */

#include "fahrplan_utils.h"
#include "fahrplan_parser_mobilebahnde.h"


/**
 * getStationsByName implementation for mobile.bahn.de Backend
 */
GArray * getStationsByName_mobilebahnde(gchar * stationName) {

	gchar * postData =	g_strdup_printf("REQ0JourneyStopsS0A=1&REQ0JourneyStopsS0G=%s", stationName);
	gchar * url      = "http://mobile.bahn.de/bin/mobil/query.exe/dox?rt=1&use_realtime_filter=1&searchMode=NORMAL";
	gchar * result   = performCurlRequest(url, postData);

	if (!result) {

		return NULL;
	}

	/*
	g_debug("CURL: %s\n", result);
	*/

	GArray *garray;

	garray = g_array_new (TRUE, TRUE, sizeof (gchar *));

	char *selectBoxFrom = strstr(result,
			"<select class=\"tpLocList\" name=\"REQ0JourneyStopsS0K\">");

	/* more than one result found */
	if (selectBoxFrom) {

		char *selectBoxTo = strstr(selectBoxFrom, "</select>");
		int count = selectBoxTo - selectBoxFrom + 9;
		char options[count];
		strncpy(options, selectBoxFrom, count);

		options[count] = '\0';

		/* g_debug("RESULT: %s", options); */

		xmlDoc *doc = NULL;
		xmlNode *root_element = NULL;

		/*parse the file and get the DOM */
		doc = xmlReadDoc(options, NULL, NULL, 0);

		/*Get the root element node */
		root_element = xmlDocGetRootElement(doc);

		xmlNode *cur_node = NULL;

		for (cur_node = root_element->children; cur_node; cur_node = cur_node->next) {

			if (cur_node->type == XML_ELEMENT_NODE && !strcmp(cur_node->name, "option")) {

				gchar *stationEntry = g_strdup_printf(cur_node->children->content);

				g_array_append_val (garray, stationEntry);
			}
		}

		/*free the document */
		xmlFreeDoc(doc);

	} else {

		selectBoxFrom = strstr(result, "<span class=\"fixedLoc\">");

		if (selectBoxFrom) {

			char *selectBoxTo = strstr(selectBoxFrom, "</span>");
			int count = selectBoxTo - selectBoxFrom + 7;
			char options[count];
			strncpy(options, selectBoxFrom, count);

			options[count] = '\0';

			/* g_debug("RESULT: %s", options); */

			xmlDoc *doc = NULL;
			xmlNode *root_element = NULL;

			/*parse the file and get the DOM */
			doc = xmlReadDoc(options, NULL, NULL, 0);

			/*Get the root element node */
			root_element = xmlDocGetRootElement(doc);

			gchar *stationEntry = g_strdup_printf(root_element->children->content);

			g_array_append_val (garray, stationEntry);

			/*free the document */
			xmlFreeDoc(doc);

		} else {

			return NULL;
		}
	}

	return garray;
}

/**
 * getStationsByGPS implementation for mobile.bahn.de
 */
GArray * getStationsByGPS_mobilebahnde(gint longitude, gint latitude) {

	gchar * url      = g_strdup_printf("http://mobile.bahn.de/bin/mobil/query.exe/dox?rt=1&use_realtime_filter=1&stationNear=1&look_x=%d&look_y=%d&performLocating=2&tpl=stopsnear&look_maxdist=1000&look_stopclass=1023&n=1", longitude, latitude);
	gchar * result   = performCurlRequest(url, NULL);

	if (!result) {

		return NULL;
	}

	/*
	g_debug("CURL: %s\n", result);
	*/

	GArray *garray;

	garray = g_array_new (TRUE, TRUE, sizeof (gchar *));

	char *dataBoxFrom = strstr(result, "<div class=\"overview\">");

	if (dataBoxFrom) {

		char *dataBoxTo = strstr(dataBoxFrom, "<p class=\"prio2links\"");
		int count = dataBoxTo - dataBoxFrom;
		char dataBox[count + 6];
		strncpy(dataBox, dataBoxFrom, count);

		dataBox[count] = '\0';

		strcat(dataBox, "</div>");

		/*
		g_debug("DATA %s", dataBox);
		*/

		xmlDoc *doc = NULL;
		xmlNode *root_element = NULL;

		/*parse the file and get the DOM */
		doc = xmlReadDoc(dataBox, NULL, NULL, 0);

		/*Get the root element node */
		root_element = xmlDocGetRootElement(doc);
		xmlNode *cur_node = NULL;
		xmlNode *tmp_node = NULL;

		int num = 0;

		for (cur_node = root_element->children; cur_node; cur_node
				= cur_node->next) {

			if (!strcmp(cur_node->name, "div")) {

				for (tmp_node = cur_node->children; tmp_node; tmp_node
						= tmp_node->next) {

					if (!strcmp(tmp_node->name, "a")) {

						num++;
						/* g_debug("-- %s", tmp_node->children->content); */
						gchar *stationEntry = g_strdup_printf(tmp_node->children->content);

						g_array_append_val (garray, stationEntry);
					}
				}
			}
		}
	}

	return garray;
}

/**
 * getJourneyDetailDataByUrl implementation for mobile.bahn.de
 */
DetailInfo * getJourneyDetailDataByUrl_mobilebahnde(gchar *url) {

	gchar * result   = performCurlRequest(url, NULL);

	if (!result) {

		return NULL;
	}

	DetailInfo *detail = mobilebahnde_parseSearchDetails(result);

	return detail;
}

/**
 * getJourneyDataByUrl implementation for mobile.bahn.de
 */
ResultInfo * getJourneyDataByUrl_mobilebahnde(gchar *url) {

	gchar * result   = performCurlRequest(url, NULL);

	if (!result) {

		return NULL;
	}

	ResultInfo *resultInfo = mobilebahnde_parseSearchResult(result);

	return resultInfo;
}

/**
 * getJourneyData implementation for mobile.bahn.de
 */
ResultInfo * getJourneyData_mobilebahnde(gchar *fromStation, gchar *viaStation, gchar *toStation, gint day, gint month, gint year, gint hour, gint minutes, gint options) {

	gchar * postData = g_strdup_printf("REQ0JourneyStopsS0A=1&REQ0JourneyStopsS0G=%s&REQ0JourneyStopsS0ID=&REQ0JourneyStopsZ0A=1&REQ0JourneyStopsZ0G=%s&REQ0JourneyStopsZ0ID=&REQ0JourneyDate=%d.%d.%d&REQ0JourneyTime=%d:%d&REQ0HafasSearchForw=%d&existOptimizePrice=1&REQ0HafasOptimize1=0%3A1&existProductNahverkehr=yes&REQ0Tariff_TravellerAge.1=35&start=Suchen&REQ0Tariff_Class=2&REQ0Tariff_TravellerReductionClass.1=0", fromStation, toStation, day, month , year, hour, minutes, options);
	gchar * url      = g_strdup_printf("http://mobile.bahn.de/bin/mobil/query.exe/dox?rt=1&use_realtime_filter=1&searchMode=NORMAL");
	gchar * result   = performCurlRequest(url, postData);

	if (!result) {

		return NULL;
	}

	/* check if we get a stupid selectbox again so we must resend with ids */

	char *selectBoxFrom = strstr(result,
			"<select class=\"tpLocList\" name=\"REQ0JourneyStopsS0K\">");
	char *selectBoxTo = strstr(result,
			"<select class=\"tpLocList\" name=\"REQ0JourneyStopsZ0K\">");

	/* more than one result found */
	if (selectBoxFrom || selectBoxTo) {

		/*
		 * multible selects for from station?
		 */
		if (selectBoxFrom) {

			char *selectBoxFromTo = strstr(selectBoxFrom, "</select>");
			int count = selectBoxFromTo - selectBoxFrom + 9;
			char selectData[count];
			strncpy(selectData, selectBoxFrom, count);

			selectData[count] = '\0';

			char *newFrom = mobilebahnde_getIdForName(fromStation, selectData);

			if (newFrom) {

				fromStation = newFrom;
			}
		} else {

			selectBoxFrom = strstr(result,
					"<input type=\"hidden\" name=\"REQ0JourneyStopsS0K\" value=\"");
			char *selectBoxFromTo = strstr(selectBoxFrom, "\" />");
			int count = selectBoxFromTo - selectBoxFrom - 55;
			char selectData[count];
			strncpy(selectData, selectBoxFrom + 55, count);
			selectData[count] = '\0';

			strcpy(fromStation, selectData);
		}

		if (selectBoxTo) {

			char *selectBoxToTo = strstr(selectBoxTo, "</select>");
			int count = selectBoxToTo - selectBoxTo + 9;
			char selectData[count];
			strncpy(selectData, selectBoxTo, count);

			selectData[count] = '\0';

			char *newTo = mobilebahnde_getIdForName(toStation, selectData);

			if (newTo) {

				toStation = newTo;
			}
		} else {

			selectBoxTo	= strstr(result,
					"<input type=\"hidden\" name=\"REQ0JourneyStopsZ0K\" value=\"");
			char *selectBoxToTo = strstr(selectBoxTo, "\" />");
			int count = selectBoxToTo - selectBoxTo - 55;
			char selectData[count];
			strncpy(selectData, selectBoxTo + 55, count);
			selectData[count] = '\0';

			strcpy(toStation, selectData);
		}

		char *newUrl;

		char *urlFrom =	strstr(result,
				"<form action=\"http://mobile.bahn.de/bin/mobil/query.exe/dox?");

		if (urlFrom) {

			char *urlTo = strstr(urlFrom, " method");
			int count = urlTo - urlFrom;
			char theUrl[count];
			strncpy(theUrl, urlFrom, count);

			theUrl[count] = '\0';

			strcat(theUrl, "></form>");

			xmlDoc *doc = NULL;
			xmlNode *root_element = NULL;

			/*parse the file and get the DOM */
			doc = xmlReadDoc(theUrl, NULL, NULL, 0);

			/*Get the root element node */
			root_element = xmlDocGetRootElement(doc);

			if (root_element) {

				newUrl = root_element->properties->children->content;
			}
		}

		if (newUrl) {

			gchar * postData = g_strdup_printf("REQ0JourneyStopsS0A=1&REQ0JourneyStopsS0K=%s&REQ0JourneyStopsS0ID=&REQ0JourneyStopsZ0A=1&REQ0JourneyStopsZ0K=%s&REQ0JourneyStopsZ0ID=&REQ0JourneyDate=%d.%d.%d&REQ0JourneyTime=%d:%d&REQ0HafasSearchForw=%d&existOptimizePrice=1&REQ0HafasOptimize1=0%3A1&existProductNahverkehr=yes&REQ0Tariff_TravellerAge.1=35&start=Suchen&REQ0Tariff_Class=2&REQ0Tariff_TravellerReductionClass.1=0", fromStation, toStation, day, month , year, hour, minutes, options);
			gchar * url      = g_strdup_printf(newUrl);
			gchar * result   = performCurlRequest(url, postData);

			if (!result) {

				return NULL;
			}
		} else {

			return NULL;
		}
	}

	ResultInfo *resultInfo = mobilebahnde_parseSearchResult(result);

	return resultInfo;
}


/**
 * Internal Helper for only mobile.bahn.de
 * Parse the search details page
 */
DetailInfo * mobilebahnde_parseSearchDetails(gchar *returnData) {

	DetailInfo *detailInfo;

	detailInfo = g_new0 (DetailInfo, 1);

	GArray *garray;

	garray = g_array_new (TRUE, TRUE, sizeof (DetailItem *));

	char *detailsFrom =
				strstr(returnData, "<div id=\"content\">");

	if (detailsFrom) {

		char *detailsTo = strstr(detailsFrom, "</div>");
		int count = detailsTo - detailsFrom + 6;
		char detailsData[count];
		strncpy(detailsData, detailsFrom, count);

		detailsData[count] = '\0';

		char *nbspData[count + 51];

		strcpy(nbspData,
				"<!DOCTYPE doc [\n <!ENTITY nbsp \"&#160;\" > \n]>\n");

		strcat(nbspData, detailsData);

		xmlDoc *doc = NULL;
		xmlNode *root_element = NULL;

		/*parse the file and get the DOM */
		doc = xmlReadDoc(nbspData, NULL, NULL, 0);

		/*Get the root element node */
		root_element = xmlDocGetRootElement(doc);

		xmlNode *cur_node;
		xmlNode *sub_node;
		xmlNode *sub_node2;

		for (cur_node = root_element->children; cur_node; cur_node
				= cur_node->next) {
			if (!strcmp(cur_node->name, "p")) {

				if (!strcmp(cur_node->properties->children->content, "details")) {

					/*
					 * 1. span class="bold" (from)
					 * 2. a->span (train number)
					 * 3. text (time and stage)
					 * 4. span class="red" (error message optional)
					 * 5. span class="bold" (to)
					 * 6. text (time and stage)
					 */

					char *fromStr = "";
					char *trainStr = "";
					char *timeFromStr = "";
					char *infoStr = "";
					char *toStr = "";
					char *timeToStr = "";
					char *alternateStr = "";

					for (sub_node = cur_node->children; sub_node; sub_node
									= sub_node->next) {

						if (!strcmp(sub_node->name, "span")) {

							if (!strcmp(sub_node->properties->children->content, "red")) {

								infoStr = sub_node->children->content;
							} else if (!strcmp(sub_node->properties->name, "class")) {

								if (strcmp(fromStr, "") && !strcmp(toStr, "")) {

									toStr = sub_node->children->content;
								}
								if (!strcmp(fromStr, "") && !strcmp(toStr, "")) {

									fromStr = sub_node->children->content;
								}
							}
						}


						if (!strcmp(sub_node->name, "a") && !strcmp(trainStr, "")) {

							for (sub_node2 = sub_node->children; sub_node2; sub_node2
																	= sub_node2->next) {

								if (!strcmp(sub_node2->name, "span") && !strcmp(trainStr, "")) {

									trainStr = sub_node2->children->content;
									trainStr = stringReplace(trainStr, "     ", " ");
								}
							}
						}

						if (!strcmp(sub_node->name, "text")) {

							if (strcmp(sub_node->content, "") && strcmp(sub_node->content, "\n")) {

								int  found = 0;
								char *testFrom = strstr(sub_node->content, "ab ");

								if (testFrom) {

									timeFromStr = testFrom;
									timeFromStr += 3;
									found = 1;
									/* test if next element is a span */
									sub_node2 = sub_node->next;
									if (!strcmp(sub_node2->name, "span")) {

										strcat(timeFromStr, sub_node2->children->content);
										sub_node2 = sub_node2->next;
										if (!strcmp(sub_node2->name, "text")) {

											strcat(timeFromStr, sub_node2->content);
											sub_node = sub_node->next;
											sub_node = sub_node->next;
										}
									}
								}
								char *testTo = strstr(sub_node->content, "an ");

								if (testTo) {

									timeToStr = testTo;
									timeToStr += 3;
									found = 1;
									/* test if next element is a span */
									sub_node2 = sub_node->next;
									if (!strcmp(sub_node2->name, "span")) {

										strcat(timeToStr, sub_node2->children->content);
										sub_node2 = sub_node2->next;
										if (!strcmp(sub_node2->name, "text")) {

											strcat(timeToStr, sub_node2->content);
											sub_node = sub_node->next;
											sub_node = sub_node->next;
										}
									}
								}

								if (found == 0) {

									alternateStr = sub_node->content;
									alternateStr += 1;
								}

							}
						}
					}

					DetailItem *detailItem;

					detailItem = g_new0 (DetailItem, 1);

					removeLineBreaks(fromStr);
					removeLineBreaks(timeFromStr);
					removeLineBreaks(toStr);
					removeLineBreaks(timeToStr);
					removeLineBreaks(trainStr);
					removeLineBreaks(infoStr);
					removeLineBreaks(alternateStr);

					detailItem->fromStr = g_strdup_printf(fromStr);
					detailItem->timeFromStr = g_strdup_printf(timeFromStr);
					detailItem->toStr = g_strdup_printf(toStr);
					detailItem->timeToStr = g_strdup_printf(timeToStr);
					detailItem->trainStr = g_strdup_printf(trainStr);
					detailItem->infoStr = g_strdup_printf(infoStr);
					detailItem->infoStr = g_strdup_printf(alternateStr);

					g_array_append_val (garray, detailItem);
				}
				if (!strcmp(cur_node->properties->children->content, "connectiondetails")) {

					/*
					 * 1. text starts with "Abfahrt:" (departure)
					 * 2. text starts with "Ankunft:" (arrival)
					 * 3. text starts with "Dauer:" (duration)
					 * 4. text stats with "Hinweis:" (info optional)
					 * 5. span class="bold" (pricing infos)
					 */

					char *departureStr = "";
					char *arrivalStr = "";
					char *durationStr = "";
					char *infoStr = "";
					char *pricingStr = "";

					for (sub_node = cur_node->children; sub_node; sub_node
									= sub_node->next) {

						if (!strcmp(sub_node->name, "text")) {

							char *testFrom = strstr(sub_node->content, "Abfahrt:");
							if (testFrom) {

								testFrom += 9;
								departureStr = testFrom;
							}
							testFrom = strstr(sub_node->content, "Ankunft:");
							if (testFrom) {

								testFrom += 9;
								arrivalStr = testFrom;
							}
							testFrom = strstr(sub_node->content, "Dauer:");
							if (testFrom) {

								testFrom += 7;
								durationStr = testFrom;
							}
							testFrom = strstr(sub_node->content, "Hinweis:");
							if (testFrom) {

								testFrom += 9;
								infoStr = testFrom;
							}
						}

						if (!strcmp(sub_node->name, "span")) {

							pricingStr = sub_node->children->content;
							pricingStr += 1;
						}
					}

					removeLineBreaks(departureStr);
					removeLineBreaks(arrivalStr);
					removeLineBreaks(durationStr);
					removeLineBreaks(infoStr);
					removeLineBreaks(pricingStr);

					detailInfo->arrivalStr = g_strdup_printf(arrivalStr);
					detailInfo->departureStr = g_strdup_printf(departureStr);
					detailInfo->durationStr = g_strdup_printf(durationStr);
					detailInfo->infoStr = g_strdup_printf(infoStr);
					detailInfo->pricingStr = g_strdup_printf(pricingStr);
				}
			}
		}
	}

	detailInfo->items = garray;
	return detailInfo;
}

/**
 * Internal Helper for only mobile.bahn.de
 * Parse the search result itself
 */
ResultInfo * mobilebahnde_parseSearchResult(gchar *returnData) {

	ResultInfo *resultInfo;

	resultInfo = g_new0 (ResultInfo, 1);

	/* check errors */
	char *errorDataFrom = strstr(returnData, "<span class=\"error\">");

	if (errorDataFrom) {

		char *errorDataTo = strstr(errorDataFrom, "</span>");
		int count = errorDataTo - errorDataFrom + 7;
		char errorData[count];
		strncpy(errorData, errorDataFrom, count);

		errorData[count] = '\0';

		xmlDoc *doc = NULL;
		xmlNode *root_element = NULL;

		/*parse the file and get the DOM */
		doc = xmlReadDoc(errorData, NULL, NULL, 0);

		/*Get the root element node */
		root_element = xmlDocGetRootElement(doc);

		resultInfo->errorMsg = g_strdup_printf(root_element->children->content);

		return resultInfo;
	}

	/* GET HEADER */

	char *headerDataFrom = strstr(returnData, "<p class=\"qs\">");

	if (headerDataFrom) {

		char *headerDataTo = strstr(headerDataFrom, "</p>");
		int count = headerDataTo - headerDataFrom + 4;
		char headerData[count];
		strncpy(headerData, headerDataFrom, count);

		headerData[count] = '\0';

		/* g_debug("RESULT: %s", headerData); */

		xmlDoc *doc = NULL;
		xmlNode *root_element = NULL;

		/*parse the file and get the DOM */
		doc = xmlReadDoc(headerData, NULL, NULL, 0);

		/*Get the root element node */
		root_element = xmlDocGetRootElement(doc);

		xmlNode *cur_node = NULL;

		int num = 0;

		for (cur_node = root_element->children; cur_node; cur_node
				= cur_node->next) {

			if (!strcmp(cur_node->name, "span")) {

				num++;
				/* g_debug("X: %s", cur_node->children->content); */

				switch (num) {

				case 1:
					resultInfo->headerFromStation = g_strdup_printf(cur_node->children->content);
					break;
				case 2:
					resultInfo->headerToStation = g_strdup_printf(cur_node->children->content);
					break;
				case 3:
					resultInfo->headerTimeInfo = g_strdup_printf(cur_node->children->content);
					break;
				}
			}
		}

	} else {

		resultInfo->errorMsg = _("An unknown error occured.");
		return resultInfo;
	}

	/* later and earlier buttons */

	char *resultButtonsFrom =
				strstr(returnData, "<div id=\"content\">");

	if (resultButtonsFrom) {

		char *resultButtonsTo = strstr(resultButtonsFrom, "</div>");
		int count = resultButtonsTo - resultButtonsFrom + 6;
		char resultButtons[count];
		strncpy(resultButtons, resultButtonsFrom, count);

		resultButtons[count] = '\0';

		char *nbspData[count + 51];

		strcpy(nbspData, "<!DOCTYPE doc [\n <!ENTITY nbsp \"&#160;\" > \n]>\n");

		strcat(nbspData, resultButtons);

		xmlDoc *doc = NULL;
		xmlNode *root_element = NULL;

		/*parse the file and get the DOM */
		doc = xmlReadDoc(nbspData, NULL, NULL, 0);

		/*Get the root element node */
		root_element = xmlDocGetRootElement(doc);

		xmlNode *cur_node = NULL;
		xmlNode *sub_node = NULL;
		xmlAttr *cur_attribute = NULL;

		resultInfo->headerEarlierUrl = NULL;
		resultInfo->headerLaterUrl = NULL;

		for (cur_node = root_element->children; cur_node; cur_node
				= cur_node->next) {
			if (!strcmp(cur_node->name, "p")) {

				for (sub_node = cur_node->children; sub_node; sub_node
								= sub_node->next) {


					if (!strcmp(sub_node->name, "a")) {

						for (cur_attribute = sub_node->properties; cur_attribute; cur_attribute
														= cur_attribute->next) {

							if (!strcmp(cur_attribute->name, "href")) {

								char testStr[strlen(cur_attribute->children->content)];
								strcpy(testStr, cur_attribute->children->content);

								char *testStrLater = strstr(testStr, "e=1");
								if (testStrLater) {

									testStr[strlen(testStr) - strlen(testStrLater)] = '\0';

									resultInfo->headerEarlierUrl = g_strdup_printf("%se=2", testStr);
									resultInfo->headerLaterUrl = g_strdup_printf("%se=1", testStr);
								}
							}
						}

					}
				}
			}
		}
	}


	/* RESULTS ITSELF */

	char *resultDataFrom =
			strstr(returnData, "<table class=\"ovTable\">");

	if (resultDataFrom) {

		char *resultDataTo = strstr(resultDataFrom, "</table>");
		int count = resultDataTo - resultDataFrom + 8;
		char resultData[count];
		strncpy(resultData, resultDataFrom, count);

		resultData[count] = '\0';

		char *nbspData[count + 51];

		strcpy(nbspData,
				"<!DOCTYPE doc [\n <!ENTITY nbsp \"&#160;\" > \n]>\n");

		strcat(nbspData, resultData);

		/* g_debug("RESULT: %s", nbspData); */

		xmlDoc *doc = NULL;
		xmlNode *root_element = NULL;

		/*parse the file and get the DOM */
		doc = xmlReadDoc(nbspData, NULL, NULL, 0);

		/*Get the root element node */
		root_element = xmlDocGetRootElement(doc);

		resultInfo->items = mobilebahnde_getResultValues(root_element->children);
	}


	return resultInfo;
}


/**
 * Internal Helper for only mobile.bahn.de
 * Parse function for the search result. given as libxml node.
 */
GArray * mobilebahnde_getResultValues(xmlNode * a_node) {

	xmlNode *cur_node = NULL;
	xmlNode *tmp_node = NULL;
	xmlNode *sub_node = NULL;
	xmlAttr *cur_attribute = NULL;

	GArray *garray;

	garray = g_array_new (TRUE, TRUE, sizeof (ResultItem *));

	for (cur_node = a_node; cur_node; cur_node = cur_node->next) {

		if (cur_node->type == XML_ELEMENT_NODE && !strcmp(cur_node->name, "tr")) {

			int num = 0;
			int found = 0;

			ResultItem *resultItem;

			resultItem = g_new0 (ResultItem, 1);

			for (sub_node = cur_node->children; sub_node; sub_node = sub_node->next) {

				if (!strcmp(sub_node->name, "td")) {

					switch (num) {

					case 0:

						if (!strcmp(sub_node->children->name, "a")) {

							for (cur_attribute = sub_node->children->properties; cur_attribute; cur_attribute
															= cur_attribute->next) {

								if (!strcmp(cur_attribute->name, "href")) {

									resultItem->detailsUrl = g_strdup_printf(cur_attribute->children->content);
								}
							}


							found = 1;

							int addTo = 0;
							for (tmp_node = sub_node->children->children; tmp_node; tmp_node
									= tmp_node->next) {

								if (!strcmp(tmp_node->name, "text")) {

									if (addTo) {

										resultItem->toTimeStr = g_strdup_printf(tmp_node->content);
									} else {

										resultItem->fromTimeStr = g_strdup_printf(tmp_node->content);
									}
									addTo = 1;
								}
							}

						}
						break;
					case 1:

						if (!strcmp(sub_node->children->name, "img")) {

							if (!strcmp(sub_node->children->properties->children->content, "/v/660/img/achtung_rot_16x16.gif")) {

								resultItem->warningStr = _("<b>Warning, possible changes</b>");
							}
						}

						if (!strcmp(sub_node->children->name, "span")) {

							if (!strcmp(sub_node->children->children->content, "+0")) {

								resultItem->warningStr = _("On Time");
							} else {

								resultItem->warningStr = g_strdup_printf(sub_node->children->children->content);
							}
						}


						break;
					case 2:

						if (sub_node->children &&  !strcmp(sub_node->children->name, "text")) {

							resultItem->changeStr = g_strdup_printf(sub_node->children->content);
						}
						break;
					case 3:

						if (sub_node->children && !strcmp(sub_node->children->name, "text")) {

							resultItem->trainTypeStr = g_strdup_printf(sub_node->children->content);
						} else {

							resultItem->trainTypeStr = _("unk.");
						}
						break;
					}

					num++;
				}
			}

			if (found) {

				g_array_append_val (garray, resultItem);
			} else {

				g_free(resultItem);
			}
		}
	}

	return garray;
}

/**
 * Internal Helper for only mobile.bahn.de
 * Get throu a select box options values and retures the "value" field for the option
 * which corresponds with the name param
 */
char * mobilebahnde_getIdForName(char *name, char * dataText) {

	xmlDoc *doc = NULL;
	xmlNode *root_element = NULL;

	/*parse the file and get the DOM */
	doc = xmlReadDoc(dataText, NULL, NULL, 0);

	/*Get the root element node */
	root_element = xmlDocGetRootElement(doc);

	/*g_debug("searching '%s'\n", name); */
	xmlNode *cur_node = NULL;
	xmlNode *sub_node = NULL;
	xmlAttr *cur_attribute = NULL;

	for (cur_node = root_element->children; cur_node; cur_node = cur_node->next) {

		if (!strcmp(cur_node->name, "option")) {

			for (sub_node = cur_node->children; sub_node; sub_node
					= sub_node->next) {

				if (sub_node->type == XML_TEXT_NODE) {

					if (!strcmp(name, sub_node->content)) {

						for (cur_attribute = cur_node->properties; cur_attribute; cur_attribute
								= cur_attribute->next) {

							if (!strcmp(cur_attribute->name, "value")) {

								/* g_debug("attr: %s = %s",cur_attribute->name, cur_attribute->children->content); */

								return cur_attribute->children->content;
							}
						}
					}
				}
			}
		}
	}
}

