/*******************************************************************************

 This file is a part of Fahrplan for maemo 2009-2010

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 ============================================================================
 Name        : main.c
 Author      : smurfy
 Version     : 0.0.4
 Description : Fahrplan application for train lines in Europe
 ============================================================================
 */
/* Includes */
#include <hildon/hildon.h>
#include <hildon/hildon-button.h>
#include <hildon/hildon-program.h>
#include <hildon/hildon-picker-button.h>
#include <stdio.h>
#include <curl/curl.h>
#include <gtk/gtkmain.h>
#include <gtk/gtkbutton.h>
#include <libosso.h>
#include <string.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <libxml/parser.h>
#include <libxml/tree.h>
#include <libxml/globals.h>
#include <location/location-gps-device.h>
#include <location/location-gpsd-control.h>

#include "localisation.h"

#define APP_NAME "fahrplan"
#define APP_VER "0.0.4"
#define APP_SERVICE "com.nokia.fahrplan"
#define APP_METHOD "/com/nokia/fahrplan"
/* end defines */

/* Application UI data struct */
typedef struct _AppData AppData;
struct _AppData {
	HildonProgram *program;
	HildonWindow *window;
	HildonWindow *resultWindow;
	HildonWindow *detailsWindow;

	GtkWidget *verticalContainer;
	GtkWidget *fromContainer;
	GtkWidget *fromSelector;
	GtkWidget *fromButton;
	GtkWidget *fromLabel;
	GtkWidget *toContainer;
	GtkWidget *toSelector;
	GtkWidget *toButton;
	GtkWidget *toLabel;
	GtkWidget *timeContainer;
	GtkWidget *timeDateButton;
	GtkWidget *timeTimeButton;
	GtkWidget *optionsButton;
	GtkWidget *optionsSelector;
	GtkWidget *searchButton;

	GtkWidget *currentDialog;
	GtkWidget *currentSearchTextBox;
	GtkWidget *currentSelector;
	GtkWidget *currentTmpPicker;
	GtkWidget *currentSelectorFor;
	GtkWidget *currentResultPannableArea;
	GtkWidget *currentResultMainVbox;
	GtkWidget *currentDetailsPannableArea;
	GtkWidget *currentDetailsMainVbox;

	LocationGPSDControl *currentGPSControl;

	char currentResultBaseUrl[255];
};

/**
 * Structure for CURL Data used in combination of copyDataBuffer
 * to store the curl response.
 */
struct CURLData {
	char *buf;
	size_t pos;
	size_t size;
};

/**
 * Simple String replace function
 */

char * str_replace( const char *string, const char *substr, const char *replacement ){
	char *tok = NULL;
	char *newstr = NULL;
	tok = strstr( string, substr );
	if( tok == NULL ) return strdup( string );
	newstr = malloc( strlen( string ) - strlen( substr ) + strlen( replacement ) + 1 );
	if( newstr == NULL ) return NULL;
	memcpy( newstr, string, tok - string );
	memcpy( newstr + (tok - string), replacement, strlen( replacement ) );
	memcpy( newstr + (tok - string) + strlen( replacement ), tok + strlen( substr ), strlen( string ) - strlen( substr ) - ( tok - string ) );
	memset( newstr + strlen( string ) - strlen( substr ) + strlen( replacement ), 0, 1 );
	return newstr;
}

void removeLineBreaks(char *string) {

	unsigned int i = 0;
	for(i = 0; i < strlen(string); ++i){
		if (string[i] == '\n'){
			string[i] = ' ';
		}
	}
}

/**
 * Copys data from internal curl buffer to our own buffer.
 */
static size_t copyDataBuffer(void *ptr, size_t size, size_t nmemb, void *ctx) {
	struct CURLData *bufData = ctx;

	if (bufData->pos + size * nmemb > bufData->size) {

		/* overflow */
		return 0;
	}

	memcpy(&bufData->buf[bufData->pos], ptr, size * nmemb);
	bufData->pos += size * nmemb;
	return size * nmemb;
}

/**
 * Function to handle the selection of an entry of the results page
 */
void resultSelected(GtkButton * button, AppData *data) {

	gchar *current_selection;
	current_selection = g_object_get_data(G_OBJECT(button), "URL");
	loadDetails(current_selection, data);
}

/**
 * Parse function for the search result. given as libxml node.
 */
static void getResultValues(xmlNode * a_node, AppData *data) {
	xmlNode *cur_node = NULL;
	xmlNode *tmp_node = NULL;
	xmlAttr *cur_attribute = NULL;

	int num = 0;
	int found = 0;
	char fromTimeStr[100] = "";
	char toTimeStr[100] = "";
	char *otherStr = "";
	char *changeStr = "";
	char *warningStr = "";
	char *trainTypeStr = "";
	char trainUrlStr[255] = "";

	for (cur_node = a_node; cur_node; cur_node = cur_node->next) {

		if (cur_node->type == XML_ELEMENT_NODE && cur_node->parent->type
				== XML_ELEMENT_NODE && !strcmp(cur_node->parent->name, "tr")) {

			switch (num) {

			case 0:

				if (!strcmp(cur_node->children->name, "a")) {

					for (cur_attribute = cur_node->children->properties; cur_attribute; cur_attribute
													= cur_attribute->next) {

						if (!strcmp(cur_attribute->name, "href")) {

							strcat(trainUrlStr, cur_attribute->children->content);
						}
					}


					found = 1;

					int addTo = 0;
					for (tmp_node = cur_node->children->children; tmp_node; tmp_node
							= tmp_node->next) {

						if (!strcmp(tmp_node->name, "text")) {

							if (addTo) {

								strcat(toTimeStr, tmp_node->content);
							} else {

								strcat(fromTimeStr, tmp_node->content);
							}
							addTo = 1;
						}
					}

				}
				break;
			case 1:

				if (!strcmp(cur_node->children->name, "img")) {

					if (!strcmp(cur_node->children->properties->children->content, "/v/660/img/achtung_rot_16x16.gif")) {

						warningStr = _("<b>Warning, possible changes</b>");
					}
				}

				if (!strcmp(cur_node->children->name, "span")) {

					if (!strcmp(cur_node->children->children->content, "+0")) {

						warningStr = _("On Time");
					} else {

						warningStr = cur_node->children->children->content;
					}
				}


				break;
			case 2:

				if (!strcmp(cur_node->children->name, "text")) {

					changeStr = cur_node->children->content;
				}
				break;
			case 3:

				if (!strcmp(cur_node->children->name, "text")) {

					trainTypeStr = cur_node->children->content;
				}
				break;
			}

			num++;

		} else {

			getResultValues(cur_node->children, data);
		}
	}

	if (found) {

		if (trainUrlStr) {

			char infoLabel[100];
			char urlLabel[100];

			char *transfersStr= _("transfers");

			if (atoi(changeStr)==1) {

				transfersStr= _("transfer");
			}

			if (!strcmp(warningStr, "")) {

				sprintf(infoLabel, "<b>%s - %s</b> %s (%s %s)", fromTimeStr, toTimeStr, trainTypeStr, changeStr, transfersStr);
			} else {

				sprintf(infoLabel, "<b>%s - %s</b> %s (%s %s)\n%s", fromTimeStr, toTimeStr, trainTypeStr, changeStr, transfersStr ,warningStr);
			}

			gchar *trainUrlGChar;

			trainUrlGChar = g_strdup_printf("%s", trainUrlStr);

			GtkWidget *line;
			GtkWidget *lineHbox;
			GtkWidget *lineText;

			line = gtk_button_new();
			gtk_button_set_focus_on_click(GTK_BUTTON(line), FALSE);
			gtk_button_set_relief(GTK_BUTTON(line), GTK_RELIEF_NONE);

			gtk_widget_set_size_request  (line, -1, 70);

			lineHbox = gtk_hbox_new(FALSE, 0);
			gtk_container_add(GTK_CONTAINER(line), lineHbox);
			lineText = gtk_label_new(NULL);
			gtk_label_set_justify(GTK_LABEL(lineText), GTK_JUSTIFY_FILL);
			gtk_label_set_markup(GTK_LABEL(lineText), infoLabel);
			gtk_box_pack_start(GTK_BOX(lineHbox), lineText, FALSE, TRUE, 10);

			gtk_box_pack_start(GTK_BOX(data->currentResultMainVbox), line, FALSE, TRUE, 0);
			gtk_box_pack_start(GTK_BOX(data->currentResultMainVbox), gtk_hseparator_new(), FALSE, TRUE, 0);

			g_signal_connect (G_OBJECT(line), "clicked",  G_CALLBACK (resultSelected), data);

			g_object_set_data(G_OBJECT(line), "URL", trainUrlGChar);
		}
		/* g_debug("stuff: %s , %s , %s ", timeStr, changeStr, trainTypeStr); */
	}
}

/**
 * getting the id station by stationname for the search
 */
char* getIdForName(char *name, char * dataText, AppData *data) {

	xmlDoc *doc = NULL;
	xmlNode *root_element = NULL;

	/*parse the file and get the DOM */
	doc = xmlReadDoc(dataText, NULL, NULL, 0);

	/*Get the root element node */
	root_element = xmlDocGetRootElement(doc);

	/*g_debug("searching '%s'\n", name); */
	xmlNode *cur_node = NULL;
	xmlNode *sub_node = NULL;
	xmlAttr *cur_attribute = NULL;

	for (cur_node = root_element->children; cur_node; cur_node = cur_node->next) {

		if (!strcmp(cur_node->name, "option")) {

			for (sub_node = cur_node->children; sub_node; sub_node
					= sub_node->next) {

				if (sub_node->type == XML_TEXT_NODE) {

					if (!strcmp(name, sub_node->content)) {

						for (cur_attribute = cur_node->properties; cur_attribute; cur_attribute
								= cur_attribute->next) {

							if (!strcmp(cur_attribute->name, "value")) {

								/* g_debug("attr: %s = %s",cur_attribute->name, cur_attribute->children->content); */

								return cur_attribute->children->content;
							}
						}
					}
				}
			}
		}
	}
}

/**
 * Loader function for last and earlier result page call
 */
void loadResultPage(char* targetUrl, AppData *data) {

	/* Start Curl search */
	CURL *curl;
	CURLcode res;
	char buf[50000];
	struct CURLData curldata;

	curldata.buf = buf;
	curldata.size = 50000;
	curldata.pos = 0;

	curl = curl_easy_init();
	if (curl) {

		g_debug("query: %s", targetUrl);

		curl_easy_setopt(curl, CURLOPT_URL, targetUrl);
		curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, &copyDataBuffer);
		curl_easy_setopt(curl, CURLOPT_WRITEDATA, &curldata);
		curl_easy_setopt(curl, CURLOPT_FAILONERROR, 1);
		curl_easy_setopt(curl, CURLOPT_TIMEOUT, 150L);
		curl_easy_setopt(curl, CURLOPT_CONNECTTIMEOUT, 15L);

		res = curl_easy_perform(curl);

		if (res != CURLE_OK) {

			hildon_banner_show_information(
					GTK_WIDGET(data->window),
					NULL,
					_("An error occured while requesting data over the internet."));
			gtk_widget_hide(data->currentDialog);
			gtk_widget_destroy(data->currentDialog);
			data->currentDialog = NULL;

			g_debug("CURL_ERROR: %d", res);

			return;
		}

		parseSearchResult(curldata.buf, data);
	}
}

/**
 * Handles the later Button Click
 */
void laterClicked(HildonButton * button, AppData *data) {

	gtk_widget_destroy(GTK_WIDGET(data->resultWindow));

	char url[260] = "";
	strcat(url, data->currentResultBaseUrl);
	strcat(url, "e=1");
	loadResultPage(url, data);
}

/**
 * Handles the earlier Button Click
 */
void earlierClicked(HildonButton * button, AppData *data) {

	gtk_widget_destroy(GTK_WIDGET(data->resultWindow));

	char url[260] = "";
	strcat(url, data->currentResultBaseUrl);
	strcat(url, "e=2");
	loadResultPage(url, data);
}

/**
 * Loader function for the details page
 *
 * @todo: Finish Up for 0.0.4
 */
void loadDetails(char* targetUrl, AppData *data) {

	/* Start Curl search */
	CURL *curl;
	CURLcode res;
	char buf[50000];
	struct CURLData curldata;

	curldata.buf = buf;
	curldata.size = 50000;
	curldata.pos = 0;

	curl = curl_easy_init();
	if (curl) {

		g_debug("query: %s", targetUrl);

		curl_easy_setopt(curl, CURLOPT_URL, targetUrl);
		curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, &copyDataBuffer);
		curl_easy_setopt(curl, CURLOPT_WRITEDATA, &curldata);
		curl_easy_setopt(curl, CURLOPT_FAILONERROR, 1);
		curl_easy_setopt(curl, CURLOPT_TIMEOUT, 150L);
		curl_easy_setopt(curl, CURLOPT_CONNECTTIMEOUT, 15L);

		res = curl_easy_perform(curl);

		if (res != CURLE_OK) {

			hildon_banner_show_information(
					GTK_WIDGET(data->window),
					NULL,
					_("An error occured while requesting data over the internet."));
			gtk_widget_hide(data->currentDialog);
			gtk_widget_destroy(data->currentDialog);
			data->currentDialog = NULL;

			g_debug("CURL_ERROR: %d", res);

			return;
		}

		/* parseSearchResult(curldata.buf, data); */

		char *detailsFrom =
					strstr(curldata.buf, "<div id=\"content\">");

		if (detailsFrom) {

			char *detailsTo = strstr(detailsFrom, "</div>");
			int count = detailsTo - detailsFrom + 6;
			char detailsData[count];
			strncpy(detailsData, detailsFrom, count);

			detailsData[count] = '\0';

			char *nbspData[count + 51];

			strcpy(nbspData,
					"<!DOCTYPE doc [\n <!ENTITY nbsp \"&#160;\" > \n]>\n");

			strcat(nbspData, detailsData);

			xmlDoc *doc = NULL;
			xmlNode *root_element = NULL;

			/*parse the file and get the DOM */
			doc = xmlReadDoc(nbspData, NULL, NULL, 0);

			/*Get the root element node */
			root_element = xmlDocGetRootElement(doc);

			xmlNode *cur_node;
			xmlNode *sub_node;
			xmlNode *sub_node2;

			/* Create the Subview for details */
			data->detailsWindow = HILDON_WINDOW(hildon_stackable_window_new());
			gtk_window_set_title(GTK_WINDOW (data->detailsWindow),
					_("Details"));

			GtkWidget *line;
			GtkWidget *lineHbox;
			GtkWidget *lineText;

			data->currentDetailsMainVbox = gtk_vbox_new(FALSE, 5);

			data->currentDetailsPannableArea = hildon_pannable_area_new();

		    hildon_pannable_area_add_with_viewport(HILDON_PANNABLE_AREA (data->currentDetailsPannableArea), GTK_WIDGET (data->currentDetailsMainVbox));

			for (cur_node = root_element->children; cur_node; cur_node
					= cur_node->next) {
				if (!strcmp(cur_node->name, "p")) {

					g_debug("-------------------");
					if (!strcmp(cur_node->properties->children->content, "details")) {

						g_debug("----- Detail ----");


						/*
						 * 1. span class="bold" (from)
						 * 2. a->span (train number)
						 * 3. text (time and stage)
						 * 4. span class="red" (error message optional)
						 * 5. span class="bold" (to)
						 * 6. text (time and stage)
						 */

						char *fromStr = "";
						char *trainStr = "";
						char *timeFromStr = "";
						char *infoStr = "";
						char *toStr = "";
						char *timeToStr = "";
						char *alternateStr = "";

						for (sub_node = cur_node->children; sub_node; sub_node
										= sub_node->next) {

							if (!strcmp(sub_node->name, "span")) {

								if (!strcmp(sub_node->properties->children->content, "bold")) {

									if (strcmp(fromStr, "") && !strcmp(toStr, "")) {

										toStr = sub_node->children->content;
									}
									if (!strcmp(fromStr, "") && !strcmp(toStr, "")) {

										fromStr = sub_node->children->content;
									}
								}
								if (!strcmp(sub_node->properties->children->content, "red")) {

									infoStr = sub_node->children->content;
								}
							}


							if (!strcmp(sub_node->name, "a") && !strcmp(trainStr, "")) {

								for (sub_node2 = sub_node->children; sub_node2; sub_node2
																		= sub_node2->next) {

									if (!strcmp(sub_node2->name, "span") && !strcmp(trainStr, "")) {

										trainStr = sub_node2->children->content;
										trainStr = str_replace(trainStr, "     ", " ");
									}
								}
							}

							if (!strcmp(sub_node->name, "text")) {

								if (strcmp(sub_node->content, "") && strcmp(sub_node->content, "\n")) {

									char *testFrom = strstr(sub_node->content, "ab");
									int found = 0;

									if (testFrom) {

										timeFromStr = testFrom;
										timeFromStr += 3;
										found = 1;
									}
									testFrom = strstr(sub_node->content, "an");

									if (testFrom) {

										timeToStr = testFrom;
										timeToStr += 3;
										found = 1;
									}

									if (found == 0) {

										alternateStr = sub_node->content;
										alternateStr += 1;
									}
								}
							}
						}

						removeLineBreaks(fromStr);
						removeLineBreaks(timeFromStr);
						removeLineBreaks(toStr);
						removeLineBreaks(timeToStr);
						removeLineBreaks(trainStr);
						removeLineBreaks(infoStr);
						removeLineBreaks(alternateStr);

						g_debug("From: %s", fromStr);
						g_debug("FromTime: %s", timeFromStr);
						g_debug("To: %s", toStr);
						g_debug("ToTime: %s", timeToStr);
						g_debug("Train: %s", trainStr);
						g_debug("Info: %s", infoStr);
						g_debug("Alt: %s", alternateStr);

						GtkTreeIter    iter;
						char infoLabel[1000] = "";

						if (strcmp(trainStr,"")) {

							strcat(infoLabel, "<b>");
							strcat(infoLabel, trainStr);
							strcat(infoLabel, "</b>\n");
						}

						strcat(infoLabel, fromStr);
						if (strcmp(timeFromStr,"")) {

							strcat(infoLabel, " - ");
							strcat(infoLabel, timeFromStr);
						}
						strcat(infoLabel, "\n");

						strcat(infoLabel, toStr);
						if (strcmp(timeToStr,"")) {

							strcat(infoLabel, " - ");
							strcat(infoLabel, timeToStr);
						}
						strcat(infoLabel, "\n");

						if (strcmp(alternateStr,"")) {

							strcat(infoLabel, "<i>");
							strcat(infoLabel, alternateStr);
							strcat(infoLabel, "</i>\n");
						}

						if (strcmp(infoStr,"")) {

							strcat(infoLabel, "<b>");
							strcat(infoLabel, infoStr);
							strcat(infoLabel, "</b>\n");
						}

						infoLabel[strlen(infoLabel) -1] = '\0';

						line = gtk_button_new();
						gtk_button_set_focus_on_click(GTK_BUTTON(line), FALSE);
						gtk_button_set_relief(GTK_BUTTON(line), GTK_RELIEF_NONE);

						lineHbox = gtk_hbox_new(FALSE, 0);
						gtk_container_add(GTK_CONTAINER(line), lineHbox);
						lineText = gtk_label_new(NULL);
						gtk_label_set_justify(GTK_LABEL(lineText), GTK_JUSTIFY_FILL);
						gtk_label_set_markup(GTK_LABEL(lineText), infoLabel);
						gtk_box_pack_start(GTK_BOX(lineHbox), lineText, FALSE, TRUE, 10);

						gtk_box_pack_start(GTK_BOX(data->currentDetailsMainVbox), line, FALSE, TRUE, 0);
						gtk_box_pack_start(GTK_BOX(data->currentDetailsMainVbox), gtk_hseparator_new(), FALSE, TRUE, 0);

					}
					if (!strcmp(cur_node->properties->children->content, "connectiondetails")) {

						g_debug("----- ConnectionDetails ----");

						/*
						 * 1. text starts with "Abfahrt:" (departure)
						 * 2. text starts with "Ankunft:" (arrival)
						 * 3. text starts with "Dauer:" (duration)
						 * 4. text stats with "Hinweis:" (info optional)
						 * 5. span class="bold" (pricing infos)
						 */

						char *departureStr = "";
						char *arrivalStr = "";
						char *durationStr = "";
						char *infoStr = "";
						char *pricingStr = "";

						for (sub_node = cur_node->children; sub_node; sub_node
										= sub_node->next) {

							if (!strcmp(sub_node->name, "text")) {

								char *testFrom = strstr(sub_node->content, "Abfahrt:");
								if (testFrom) {

									testFrom += 9;
									departureStr = testFrom;
								}
								testFrom = strstr(sub_node->content, "Ankunft:");
								if (testFrom) {

									testFrom += 9;
									arrivalStr = testFrom;
								}
								testFrom = strstr(sub_node->content, "Dauer:");
								if (testFrom) {

									testFrom += 7;
									durationStr = testFrom;
								}
								testFrom = strstr(sub_node->content, "Hinweis:");
								if (testFrom) {

									testFrom += 9;
									infoStr = testFrom;
								}
							}

							if (!strcmp(sub_node->name, "span")) {

								pricingStr = sub_node->children->content;
								pricingStr += 1;
							}
						}

						removeLineBreaks(departureStr);
						removeLineBreaks(arrivalStr);
						removeLineBreaks(durationStr);
						removeLineBreaks(infoStr);
						removeLineBreaks(pricingStr);

						g_debug("From: %s", departureStr);
						g_debug("To: %s", arrivalStr);
						g_debug("Duration: %s", durationStr);
						g_debug("Info: %s", infoStr);
						g_debug("Price: %s", pricingStr);

						GtkTreeIter    iter;
						char infoLabel[1000] = "";

						strcat(infoLabel, "<b>");
						strcat(infoLabel, departureStr);
						strcat(infoLabel, "</b>");

						if (strcmp(departureStr, arrivalStr)) {

							strcat(infoLabel, _(" to "));
							strcat(infoLabel, "<b>");
							strcat(infoLabel, arrivalStr);
							strcat(infoLabel, "</b>");
						}
						strcat(infoLabel, "\n");

						strcat(infoLabel, "<b>");
						strcat(infoLabel, _("Duration: "));
						strcat(infoLabel, "</b>");
						strcat(infoLabel, durationStr);
						strcat(infoLabel, "\n");

						if (strcmp(infoStr,"")) {

							strcat(infoLabel, "<b>");
							strcat(infoLabel, infoStr);
							strcat(infoLabel, "</b>\n");
						}

						if (strcmp(pricingStr,"")) {

							strcat(infoLabel, "<i>");
							strcat(infoLabel, pricingStr);
							strcat(infoLabel, "</i>\n");
						}

						infoLabel[strlen(infoLabel) -1] = '\0';

						line = gtk_button_new();
						gtk_button_set_focus_on_click(GTK_BUTTON(line), FALSE);
						gtk_button_set_relief(GTK_BUTTON(line), GTK_RELIEF_NONE);

						lineHbox = gtk_hbox_new(FALSE, 0);
						gtk_container_add(GTK_CONTAINER(line), lineHbox);
						lineText = gtk_label_new(NULL);
						gtk_label_set_justify(GTK_LABEL(lineText), GTK_JUSTIFY_FILL);
						gtk_label_set_markup(GTK_LABEL(lineText), infoLabel);
						gtk_box_pack_start(GTK_BOX(lineHbox), lineText, FALSE, TRUE, 10);

						gtk_box_pack_start(GTK_BOX(data->currentDetailsMainVbox), line, FALSE, TRUE, 0);
						gtk_box_pack_start(GTK_BOX(data->currentDetailsMainVbox), gtk_hseparator_new(), FALSE, TRUE, 0);
					}
				}
			}

			gtk_container_add(GTK_CONTAINER (data->detailsWindow), data->currentDetailsPannableArea);

			gtk_widget_show_all(GTK_WIDGET(data->detailsWindow));
		}
	}
}

/**
 * Parse the search result itself
 */
void parseSearchResult(char *returnData, AppData * data) {

	/* check errors */
	char *errorDataFrom = strstr(returnData, "<span class=\"error\">");

	if (errorDataFrom) {

		char *errorDataTo = strstr(errorDataFrom, "</span>");
		int count = errorDataTo - errorDataFrom + 7;
		char errorData[count];
		strncpy(errorData, errorDataFrom, count);

		errorData[count] = '\0';

		xmlDoc *doc = NULL;
		xmlNode *root_element = NULL;

		/*parse the file and get the DOM */
		doc = xmlReadDoc(errorData, NULL, NULL, 0);

		/*Get the root element node */
		root_element = xmlDocGetRootElement(doc);

		hildon_banner_show_information(GTK_WIDGET(data->window), NULL,
				root_element->children->content);

		return;
	}

	/* Create the Subview for results */
	data->resultWindow = HILDON_WINDOW(hildon_stackable_window_new());
	gtk_window_set_title(GTK_WINDOW (data->resultWindow),
			_("Results"));

	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *infoLabel;
	GtkWidget *infoLabel2;

	vbox = gtk_vbox_new(FALSE, 0);
	hbox = gtk_hbox_new(FALSE, 0);

	/* GET HEADER */

	/* g_debug("RESULT: %s", curldata.buf); */

	char *headerDataFrom = strstr(returnData, "<p class=\"qs\">");

	if (headerDataFrom) {

		char *headerDataTo = strstr(headerDataFrom, "</p>");
		int count = headerDataTo - headerDataFrom + 4;
		char headerData[count];
		strncpy(headerData, headerDataFrom, count);

		headerData[count] = '\0';

		/* g_debug("RESULT: %s", headerData); */

		xmlDoc *doc = NULL;
		xmlNode *root_element = NULL;

		/*parse the file and get the DOM */
		doc = xmlReadDoc(headerData, NULL, NULL, 0);

		/*Get the root element node */
		root_element = xmlDocGetRootElement(doc);

		xmlNode *cur_node = NULL;

		int num = 0;
		char *fromHeaderText;
		char *toHeaderText;
		char *timeHeaderText;

		for (cur_node = root_element->children; cur_node; cur_node
				= cur_node->next) {

			if (!strcmp(cur_node->name, "span")) {

				num++;
				/* g_debug("X: %s", cur_node->children->content); */

				switch (num) {

				case 1:
					fromHeaderText = cur_node->children->content;
					break;
				case 2:
					toHeaderText = cur_node->children->content;
					break;
				case 3:
					timeHeaderText = cur_node->children->content;
					break;
				}
			}
		}

		char infoLabelText[100];

		sprintf(infoLabelText, "%s %s %s %s", _("From: "), fromHeaderText, _("To: "), toHeaderText);

		infoLabel = gtk_label_new(infoLabelText);

		gtk_box_pack_start(GTK_BOX (vbox), infoLabel, FALSE, TRUE, 5);

		infoLabel2 = gtk_label_new(timeHeaderText);

		gtk_box_pack_start(GTK_BOX (vbox), infoLabel2, FALSE, TRUE, 5);


	} else {

		hildon_banner_show_information(GTK_WIDGET(data->window), NULL,
				_("An unknown error occured."));
		return;
	}

	/* later and earlier buttons */

	char *resultButtonsFrom =
				strstr(returnData, "<div id=\"content\">");

	if (resultButtonsFrom) {

		char *resultButtonsTo = strstr(resultButtonsFrom, "</div>");
		int count = resultButtonsTo - resultButtonsFrom + 6;
		char resultButtons[count];
		strncpy(resultButtons, resultButtonsFrom, count);

		resultButtons[count] = '\0';

		char *nbspData[count + 51];

		strcpy(nbspData,
				"<!DOCTYPE doc [\n <!ENTITY nbsp \"&#160;\" > \n]>\n");

		strcat(nbspData, resultButtons);

		xmlDoc *doc = NULL;
		xmlNode *root_element = NULL;

		/*parse the file and get the DOM */
		doc = xmlReadDoc(nbspData, NULL, NULL, 0);

		/*Get the root element node */
		root_element = xmlDocGetRootElement(doc);

		xmlNode *cur_node = NULL;
		xmlNode *sub_node = NULL;
		xmlAttr *cur_attribute = NULL;

		data->currentResultBaseUrl[0] = '\0';

		for (cur_node = root_element->children; cur_node; cur_node
				= cur_node->next) {
			if (!strcmp(cur_node->name, "p")) {

				for (sub_node = cur_node->children; sub_node; sub_node
								= sub_node->next) {


					if (!strcmp(sub_node->name, "a")) {

						for (cur_attribute = sub_node->properties; cur_attribute; cur_attribute
														= cur_attribute->next) {

							if (!strcmp(cur_attribute->name, "href")) {

								char testStr[strlen(cur_attribute->children->content)];
								strcpy(testStr, cur_attribute->children->content);

								char *testStrLater = strstr(testStr, "e=1");
								if (testStrLater) {

									testStr[strlen(testStr) - strlen(testStrLater)] = '\0';
									strcpy(data->currentResultBaseUrl,testStr);
								}
							}
						}

					}
				}
			}
		}

		if (strlen(data->currentResultBaseUrl) > 0) {

			GtkWidget * button;
			HildonAppMenu *menu = HILDON_APP_MENU (hildon_app_menu_new ());

			/* earlier button */
			button = hildon_gtk_button_new(HILDON_SIZE_AUTO);
				gtk_button_set_label(GTK_BUTTON (button), _("Earlier"));

			/* Attach callback to clicked signal */
			g_signal_connect_after (button, "clicked", G_CALLBACK (earlierClicked), data);

			/* Add entry to the view menu */
			hildon_app_menu_append(menu, GTK_BUTTON (button));

			/* later button */

			button = hildon_gtk_button_new(HILDON_SIZE_AUTO);
			gtk_button_set_label(GTK_BUTTON (button), _("Later"));

			/* Attach callback to clicked signal */
			g_signal_connect_after (button, "clicked", G_CALLBACK (laterClicked), data);

			/* Add entry to the view menu */
			hildon_app_menu_append(menu, GTK_BUTTON (button));

			gtk_widget_show_all(GTK_WIDGET (menu));

			hildon_window_set_app_menu (HILDON_WINDOW (data->resultWindow), menu);
		}
	}


	/* RESULTS ITSELF */

	char *resultDataFrom =
			strstr(returnData, "<table class=\"ovTable\">");

	if (resultDataFrom) {

		char *resultDataTo = strstr(resultDataFrom, "</table>");
		int count = resultDataTo - resultDataFrom + 8;
		char resultData[count];
		strncpy(resultData, resultDataFrom, count);

		resultData[count] = '\0';

		char *nbspData[count + 51];

		strcpy(nbspData,
				"<!DOCTYPE doc [\n <!ENTITY nbsp \"&#160;\" > \n]>\n");

		strcat(nbspData, resultData);

		/* g_debug("RESULT: %s", nbspData); */

		xmlDoc *doc = NULL;
		xmlNode *root_element = NULL;

		/*parse the file and get the DOM */
		doc = xmlReadDoc(nbspData, NULL, NULL, 0);

		/*Get the root element node */
		root_element = xmlDocGetRootElement(doc);


		data->currentResultPannableArea = hildon_pannable_area_new();

		data->currentResultMainVbox = gtk_vbox_new(FALSE, 5);

	    hildon_pannable_area_add_with_viewport(HILDON_PANNABLE_AREA (data->currentResultPannableArea), GTK_WIDGET (data->currentResultMainVbox));

		getResultValues(root_element->children, data);

		gtk_box_pack_start(GTK_BOX (vbox), data->currentResultPannableArea, TRUE, TRUE, 0);


	}

	/* Show Results */
	gtk_container_add(GTK_CONTAINER (data->resultWindow), vbox);

	gtk_widget_show_all(GTK_WIDGET(data->resultWindow));
}

/**
 * preform the search itself
 */
static void performSearch(gchar *fromText, gchar *toText, AppData * data, gint byValue, gchar * targetUrl) {

	if (!targetUrl) {

		targetUrl
				= "http://mobile.bahn.de/bin/mobil/query.exe/dox?rt=1&use_realtime_filter=1&searchMode=NORMAL";
	}

	gint optionsSelected = hildon_touch_selector_get_active(
			HILDON_TOUCH_SELECTOR(data->optionsSelector), 0);
	gint year;
	gint month;
	gint day;
	gint hour;
	gint minutes;

	hildon_date_button_get_date(HILDON_DATE_BUTTON(data->timeDateButton),
			&year, &month, &day);

	hildon_time_button_get_time(HILDON_TIME_BUTTON(data->timeTimeButton),
			&hour, &minutes);

	g_debug("FROM: '%s'", fromText);
	g_debug("TO: '%s'", toText);
	g_debug("DATE: '%d.%d.%d'", day, month+1, year);
	g_debug("TIME: '%d:%d'", hour, minutes);
	g_debug("OPTIONS: '%d'", optionsSelected);
	g_debug("URL: '%s'", targetUrl);

	/* Start Curl search */
	CURL *curl;
	CURLcode res;
	char buf[10000];
	struct CURLData curldata;

	curldata.buf = buf;
	curldata.size = 10000;
	curldata.pos = 0;

	curl = curl_easy_init();
	if (curl) {

		char postdata[2000];

		if (byValue == 1) {

			int
					postdataCount =
							sprintf(
									postdata,
									"REQ0JourneyStopsS0A=1&REQ0JourneyStopsS0K=%s&REQ0JourneyStopsS0ID=&REQ0JourneyStopsZ0A=1&REQ0JourneyStopsZ0K=%s&REQ0JourneyStopsZ0ID=&REQ0JourneyDate=%d.%d.%d&REQ0JourneyTime=%d:%d&REQ0HafasSearchForw=%d&existOptimizePrice=1&REQ0HafasOptimize1=0%3A1&existProductNahverkehr=yes&REQ0Tariff_TravellerAge.1=35&start=Suchen&REQ0Tariff_Class=2&REQ0Tariff_TravellerReductionClass.1=0",
									fromText, toText, day, month + 1, year,
									hour, minutes, optionsSelected);

			postdata[postdataCount] = '\0';

		} else {

			int
					postdataCount =
							sprintf(
									postdata,
									"REQ0JourneyStopsS0A=1&REQ0JourneyStopsS0G=%s&REQ0JourneyStopsS0ID=&REQ0JourneyStopsZ0A=1&REQ0JourneyStopsZ0G=%s&REQ0JourneyStopsZ0ID=&REQ0JourneyDate=%d.%d.%d&REQ0JourneyTime=%d:%d&REQ0HafasSearchForw=%d&existOptimizePrice=1&REQ0HafasOptimize1=0%3A1&existProductNahverkehr=yes&REQ0Tariff_TravellerAge.1=35&start=Suchen&REQ0Tariff_Class=2&REQ0Tariff_TravellerReductionClass.1=0",
									fromText, toText, day, month + 1, year,
									hour, minutes, optionsSelected);

			postdata[postdataCount] = '\0';
		}

		/* request the base url to get a "sessionId" */
		curl_easy_setopt(curl, CURLOPT_URL, targetUrl);
		curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, &copyDataBuffer);
		curl_easy_setopt(curl, CURLOPT_WRITEDATA, &curldata);
		curl_easy_setopt(curl, CURLOPT_FAILONERROR, 1);
		curl_easy_setopt(curl, CURLOPT_TIMEOUT, 150L);
		curl_easy_setopt(curl, CURLOPT_CONNECTTIMEOUT, 15L);
		curl_easy_setopt(curl, CURLOPT_POSTFIELDS, postdata);

		g_debug("POST: %s", postdata);

		res = curl_easy_perform(curl);

		if (res != CURLE_OK) {

			hildon_banner_show_information(
					GTK_WIDGET(data->window),
					NULL,
					_("An error occured while requesting data over the internet."));
			g_debug("CURL_ERROR: %d", res);

			return;
		}

		char *selectBoxFrom = strstr(curldata.buf,
				"<select class=\"tpLocList\" name=\"REQ0JourneyStopsS0K\">");
		char *selectBoxTo = strstr(curldata.buf,
				"<select class=\"tpLocList\" name=\"REQ0JourneyStopsZ0K\">");

		/* more than one result found */
		if (selectBoxFrom || selectBoxTo) {

			if (byValue == 1) {

				hildon_banner_show_information(
						GTK_WIDGET(data->window),
						NULL,
						_("An error with the Station name selection occurred."));

				return;
			}

			/*
			 * multible selects for from station?
			 */
			if (selectBoxFrom) {

				char *selectBoxFromTo = strstr(selectBoxFrom, "</select>");
				int count = selectBoxFromTo - selectBoxFrom + 9;
				char selectData[count];
				strncpy(selectData, selectBoxFrom, count);

				selectData[count] = '\0';

				char *newFrom = getIdForName(fromText, selectData, data);

				if (newFrom) {

					fromText = newFrom;
				}
			} else {

				selectBoxFrom
						= strstr(curldata.buf,
								"<input type=\"hidden\" name=\"REQ0JourneyStopsS0K\" value=\"");
				char *selectBoxFromTo = strstr(selectBoxFrom, "\" />");
				int count = selectBoxFromTo - selectBoxFrom - 55;
				char selectData[count];
				strncpy(selectData, selectBoxFrom + 55, count);
				selectData[count] = '\0';

				strcpy(fromText, selectData);
			}

			if (selectBoxTo) {

				char *selectBoxToTo = strstr(selectBoxTo, "</select>");
				int count = selectBoxToTo - selectBoxTo + 9;
				char selectData[count];
				strncpy(selectData, selectBoxTo, count);

				selectData[count] = '\0';

				char *newTo = getIdForName(toText, selectData, data);

				if (newTo) {

					toText = newTo;
				}
			} else {

				selectBoxTo
						= strstr(curldata.buf,
								"<input type=\"hidden\" name=\"REQ0JourneyStopsZ0K\" value=\"");
				char *selectBoxToTo = strstr(selectBoxTo, "\" />");
				int count = selectBoxToTo - selectBoxTo - 55;
				char selectData[count];
				strncpy(selectData, selectBoxTo + 55, count);
				selectData[count] = '\0';

				strcpy(toText, selectData);
			}

			char *newUrl;

			char
					*urlFrom =
							strstr(curldata.buf,
									"<form action=\"http://mobile.bahn.de/bin/mobil/query.exe/dox?");

			if (urlFrom) {

				char *urlTo = strstr(urlFrom, " method");
				int count = urlTo - urlFrom;
				char theUrl[count];
				strncpy(theUrl, urlFrom, count);

				theUrl[count] = '\0';

				strcat(theUrl, "></form>");

				xmlDoc *doc = NULL;
				xmlNode *root_element = NULL;

				/*parse the file and get the DOM */
				doc = xmlReadDoc(theUrl, NULL, NULL, 0);

				/*Get the root element node */
				root_element = xmlDocGetRootElement(doc);

				if (root_element) {

					newUrl = root_element->properties->children->content;

				}
			}

			if (newUrl) {

				performSearch(fromText, toText, data, 1, newUrl);
			} else {

				hildon_banner_show_information(
						GTK_WIDGET(data->window),
						NULL,
						_("An error with the Station name selection occurred."));
			}

			return;
		}

		parseSearchResult(curldata.buf, data);

	}
}

/**
 *  Starts the search itself, also first checks if from and to station are selected.
 */
static void startSearch(GtkButton* button, AppData * data) {

	gchar *fromText = hildon_button_get_value(HILDON_BUTTON(data->fromButton));
	gchar *toText = hildon_button_get_value(HILDON_BUTTON(data->toButton));

	if (strcmp(fromText, "") && strcmp(fromText, _("please select")) && strcmp(
			toText, "") && strcmp(toText, _("please select"))) {

		performSearch(fromText, toText, data, 0, NULL);

	} else {

		hildon_banner_show_information(GTK_WIDGET(data->window), NULL,
				"Please select the from and the to station name.");
		return;
	}
}

/**
 * get values for the selector from a station seaarch (called by getStationsByName)
 */
static void getOptionValues(xmlNode * a_node, AppData *data) {
	xmlNode *cur_node = NULL;

	for (cur_node = a_node; cur_node; cur_node = cur_node->next) {
		if (cur_node->type == XML_TEXT_NODE && cur_node->parent->type
				== XML_ELEMENT_NODE
				&& !strcmp(cur_node->parent->name, "option")) {

			hildon_touch_selector_append_text(
					HILDON_TOUCH_SELECTOR (data->currentSelector),
					cur_node->content);
		}

		getOptionValues(cur_node->children, data);
	}
}

/**
 * Callback for the temporary pickerbutton used to display the station search results selector
 */
void selectionChanged(HildonPickerButton * button, AppData *data) {

	gchar *currentSelection = hildon_button_get_value(HILDON_BUTTON (button));

	/* g_debug ("Current selection : %s",currentSelection); */

	if (strcmp(currentSelection, "")) {

		hildon_button_set_value(HILDON_BUTTON(data->currentSelectorFor),
				currentSelection);
	}
}

/**
 * called from the select station dialog if "search" pressed.
 * searchs the given station name from the textbox and displays a selector on success.
 */
void getStationsByName(GtkWidget *w, AppData * data) {

	gchar *searchFor = hildon_entry_get_text(
			HILDON_ENTRY(data->currentSearchTextBox));

	if (strlen(searchFor) == 0) {

		hildon_banner_show_information(
				GTK_WIDGET(data->window),
				NULL,
				_("Please enter a Station name"));
		return;
	}


	/* Start Curl search */
	CURL *curl;
	CURLcode res;
	char buf[10000];
	struct CURLData curldata;

	curldata.buf = buf;
	curldata.size = 10000;
	curldata.pos = 0;

	curl = curl_easy_init();
	if (curl) {

		char postdata[2000];
		int postdataCount = sprintf(postdata,
				"REQ0JourneyStopsS0A=1&REQ0JourneyStopsS0G=%s", searchFor);
		postdata[postdataCount] = '\0';

		/* request the base url to get a "sessionId" */
		curl_easy_setopt(curl, CURLOPT_URL, "http://mobile.bahn.de/bin/mobil/query.exe/dox?rt=1&use_realtime_filter=1&searchMode=NORMAL");
		curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, &copyDataBuffer);
		curl_easy_setopt(curl, CURLOPT_WRITEDATA, &curldata);
		curl_easy_setopt(curl, CURLOPT_FAILONERROR, 1);
		curl_easy_setopt(curl, CURLOPT_TIMEOUT, 150L);
		curl_easy_setopt(curl, CURLOPT_CONNECTTIMEOUT, 15L);
		curl_easy_setopt(curl, CURLOPT_POSTFIELDS, postdata);

		/* g_debug("POST: %s", postdata); */

		res = curl_easy_perform(curl);

		if (res != CURLE_OK) {

			hildon_banner_show_information(
					GTK_WIDGET(data->window),
					NULL,
					_("An error occured while requesting data over the internet."));
			gtk_widget_hide(data->currentDialog);
			gtk_widget_destroy(data->currentDialog);
			data->currentDialog = NULL;

			g_debug("CURL_ERROR: %d", res);

			return;
		}

		char *selectBoxFrom = strstr(curldata.buf,
				"<select class=\"tpLocList\" name=\"REQ0JourneyStopsS0K\">");

		/* more than one result found */
		if (selectBoxFrom) {

			char *selectBoxTo = strstr(selectBoxFrom, "</select>");
			int count = selectBoxTo - selectBoxFrom + 9;
			char options[count];
			strncpy(options, selectBoxFrom, count);

			options[count] = '\0';

			/* g_debug("RESULT: %s", options); */

			xmlDoc *doc = NULL;
			xmlNode *root_element = NULL;

			/*parse the file and get the DOM */
			doc = xmlReadDoc(options, NULL, NULL, 0);

			/*Get the root element node */
			root_element = xmlDocGetRootElement(doc);

			if (data->currentSelector) {

				gtk_widget_destroy(data->currentSelector);
			}

			data->currentSelector = hildon_touch_selector_new_text();

			getOptionValues(root_element, data);

			/*free the document */
			xmlFreeDoc(doc);

			if (data->currentTmpPicker) {

				gtk_widget_destroy(data->currentTmpPicker);
			}

			data->currentTmpPicker = hildon_picker_button_new(HILDON_SIZE_AUTO,
					HILDON_BUTTON_ARRANGEMENT_VERTICAL);
			hildon_button_set_title(HILDON_BUTTON (data->currentTmpPicker),
					_("Stations found"));

			g_signal_connect (G_OBJECT (data->currentTmpPicker), "value-changed",
					G_CALLBACK (selectionChanged), data);

			hildon_picker_button_set_selector(
					HILDON_PICKER_BUTTON (data->currentTmpPicker),
					HILDON_TOUCH_SELECTOR (data->currentSelector));

			gtk_button_clicked(GTK_BUTTON (data->currentTmpPicker));
		} else {

			selectBoxFrom = strstr(curldata.buf, "<span class=\"fixedLoc\">");

			if (selectBoxFrom) {

				char *selectBoxTo = strstr(selectBoxFrom, "</span>");
				int count = selectBoxTo - selectBoxFrom + 7;
				char options[count];
				strncpy(options, selectBoxFrom, count);

				options[count] = '\0';

				/* g_debug("RESULT: %s", options); */

				xmlDoc *doc = NULL;
				xmlNode *root_element = NULL;

				/*parse the file and get the DOM */
				doc = xmlReadDoc(options, NULL, NULL, 0);

				/*Get the root element node */
				root_element = xmlDocGetRootElement(doc);

				hildon_button_set_value(
						HILDON_BUTTON(data->currentSelectorFor),
						root_element->children->content);
			} else {

				hildon_banner_show_information(GTK_WIDGET(data->window), NULL,
						_("Strange response received, try again"));
			}
		}

		gtk_widget_hide(data->currentDialog);
		gtk_widget_destroy(data->currentDialog);
		data->currentDialog = NULL;
	}
}

static void onGPSError(LocationGPSDControl *control,gint error, AppData *data)
{
	hildon_banner_show_information(GTK_WIDGET(data->window), NULL,
							_("Error with GPS"));

	hildon_gtk_window_set_progress_indicator(GTK_WINDOW(data->currentDialog), 0);
	location_gpsd_control_stop(data->currentGPSControl);
}

/**
 * Gets current latitude and longitude and sends a request.
 * after a response received parses it and displays a selector dialog.
 */
static void onGPSLocation(LocationGPSDevice *device, AppData * data)
{
	if (!device)
		return;

	if (device->fix) {
		if (device->fix->fields & LOCATION_GPS_DEVICE_LATLONG_SET) {

			hildon_gtk_window_set_progress_indicator(GTK_WINDOW(data->currentDialog), 0);
			location_gpsd_control_stop(data->currentGPSControl);

			g_object_unref(device);
			g_object_unref(data->currentGPSControl);

			int poslat = device->fix->latitude * 1000000;
			int poslong = device->fix->longitude * 1000000;

			/* Start Curl search */
			CURL *curl;
			CURLcode res;
			char buf[50000];
			struct CURLData curldata;

			curldata.buf = buf;
			curldata.size = 50000;
			curldata.pos = 0;

			curl = curl_easy_init();
			if (curl) {

				char url[1000];

				int	urlCount =
								sprintf(
										url,
										"http://mobile.bahn.de/bin/mobil/query.exe/dox?rt=1&use_realtime_filter=1&stationNear=1&look_x=%d&look_y=%d&performLocating=2&tpl=stopsnear&look_maxdist=1000&look_stopclass=1023&n=1",
										poslong, poslat);
				url[urlCount] = '\0';

				curl_easy_setopt(curl, CURLOPT_URL, url);
				curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, &copyDataBuffer);
				curl_easy_setopt(curl, CURLOPT_WRITEDATA, &curldata);
				curl_easy_setopt(curl, CURLOPT_FAILONERROR, 1);
				curl_easy_setopt(curl, CURLOPT_TIMEOUT, 150L);
				curl_easy_setopt(curl, CURLOPT_CONNECTTIMEOUT, 15L);

				res = curl_easy_perform(curl);

				if (res != CURLE_OK) {

					hildon_banner_show_information(
							GTK_WIDGET(data->window),
							NULL,
							_("An error occured while requesting data over the internet."));
					gtk_widget_hide(data->currentDialog);
					gtk_widget_destroy(data->currentDialog);
					data->currentDialog = NULL;

					g_debug("CURL_ERROR: %d", res);

					return;
				}

				char *dataBoxFrom = strstr(curldata.buf, "<div class=\"overview\">");

				if (dataBoxFrom) {

					char *dataBoxTo = strstr(dataBoxFrom, "<p class=\"prio2links\"");
					int count = dataBoxTo - dataBoxFrom;
					char dataBox[count + 6];
					strncpy(dataBox, dataBoxFrom, count);

					dataBox[count] = '\0';

					strcat(dataBox, "</div>");

					g_debug("DATA %s", dataBox);

					xmlDoc *doc = NULL;
					xmlNode *root_element = NULL;

					/*parse the file and get the DOM */
					doc = xmlReadDoc(dataBox, NULL, NULL, 0);

					/*Get the root element node */
					root_element = xmlDocGetRootElement(doc);
					xmlNode *cur_node = NULL;
					xmlNode *tmp_node = NULL;

					if (data->currentSelector) {

						gtk_widget_destroy(data->currentSelector);
					}

					data->currentSelector = hildon_touch_selector_new_text();

					int num = 0;

					for (cur_node = root_element->children; cur_node; cur_node
							= cur_node->next) {

						if (!strcmp(cur_node->name, "div")) {

							for (tmp_node = cur_node->children; tmp_node; tmp_node
									= tmp_node->next) {

								if (!strcmp(tmp_node->name, "a")) {

									num++;
									/* g_debug("-- %s", tmp_node->children->content); */
									hildon_touch_selector_append_text(
											HILDON_TOUCH_SELECTOR (data->currentSelector),
											tmp_node->children->content);
								}
							}
						}
					}

					if (num > 0) {

						if (data->currentTmpPicker) {

							gtk_widget_destroy(data->currentTmpPicker);
						}

						data->currentTmpPicker = hildon_picker_button_new(
								HILDON_SIZE_AUTO, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
						hildon_button_set_title(HILDON_BUTTON (data->currentTmpPicker),
								_("Stations found"));

						g_signal_connect (G_OBJECT (data->currentTmpPicker), "value-changed",
								G_CALLBACK (selectionChanged), data);

						hildon_picker_button_set_selector(
								HILDON_PICKER_BUTTON (data->currentTmpPicker),
								HILDON_TOUCH_SELECTOR (data->currentSelector));

						gtk_button_clicked(GTK_BUTTON (data->currentTmpPicker));

						gtk_widget_hide(data->currentDialog);
						gtk_widget_destroy(data->currentDialog);
						data->currentDialog = NULL;

					} else {

						hildon_banner_show_information(GTK_WIDGET(data->window), NULL,
								_("No Stations in reach found."));
					}
				}
			}

		}
	}
}

/**
 * Callback if the "GPS" button on the search for station dialog is pressed.
 * Starts the GPS Request and waits until a position is received.
 */
void getByGPS(GtkWidget *w, AppData * data) {

	data->currentGPSControl = location_gpsd_control_get_default();
	LocationGPSDevice *device = g_object_new(LOCATION_TYPE_GPS_DEVICE, NULL);

	g_object_set(G_OBJECT(data->currentGPSControl), "preferred-method",
			LOCATION_METHOD_USER_SELECTED, "preferred-interval",
			LOCATION_INTERVAL_DEFAULT, NULL);

	hildon_gtk_window_set_progress_indicator(GTK_WINDOW(data->currentDialog), 1);

	g_signal_connect(device, "changed", G_CALLBACK(onGPSLocation), data);
	g_signal_connect(data->currentGPSControl, "error-verbose", G_CALLBACK(onGPSError), data);

	location_gpsd_control_start(data->currentGPSControl);

	if ((device->fix->latitude > 0) || (device->fix->latitude < 0)) {

	} else {

		hildon_banner_show_information(GTK_WIDGET(data->window), NULL,
				_("Error with location service"));

		hildon_gtk_window_set_progress_indicator(GTK_WINDOW(data->currentDialog), 0);
		location_gpsd_control_stop(data->currentGPSControl);

		return;
	}
}

/**
 * Creates and shows the search station dialog.
 */
void showSearchTextBoxDialog(GtkWidget *w, AppData * data) {

	data->currentSelectorFor = w;

	GtkWidget *submitButton;
	GtkWidget *gpsButton;

	data->currentDialog = gtk_dialog_new();
	gtk_window_set_transient_for(GTK_WINDOW (data->currentDialog),
			GTK_WINDOW (data->window));
	gtk_window_set_title(GTK_WINDOW (data->currentDialog),
			_("City Stationname"));

	data->currentSearchTextBox = hildon_entry_new(HILDON_SIZE_AUTO);

	hildon_entry_set_text(HILDON_ENTRY(data->currentSearchTextBox), "");

	gtk_box_pack_start(GTK_BOX (GTK_DIALOG(data->currentDialog)->vbox),
			data->currentSearchTextBox, TRUE, TRUE, 0);

	submitButton = gtk_dialog_add_button(GTK_DIALOG(data->currentDialog),
			_("Search"), 0);

	gpsButton = gtk_dialog_add_button(GTK_DIALOG(data->currentDialog),
			_("GPS"), 0);

	g_signal_connect (G_OBJECT (submitButton), "clicked", G_CALLBACK (getStationsByName), data);

	g_signal_connect (G_OBJECT (gpsButton), "clicked", G_CALLBACK (getByGPS), data);

	g_signal_connect (G_OBJECT (data->currentSearchTextBox), "activate", G_CALLBACK (getStationsByName), data);

	gtk_box_pack_start(GTK_BOX (GTK_DIALOG(data->currentDialog)->vbox),
			submitButton, TRUE, TRUE, 0);

	gtk_widget_show_all(GTK_WIDGET (data->currentDialog));
	gtk_dialog_run(GTK_DIALOG (data->currentDialog));
}

/**
 * some stuff from the sample hello world example :)
 */
static gint dbus_callback(const gchar *interface, const gchar *method,
		GArray *arguments, gpointer data, osso_rpc_t *retval) {
	printf("dbus: %s, %s\n", interface, method);

	if (!strcmp(method, "top_application"))
		gtk_window_present(GTK_WINDOW (data));

	return DBUS_TYPE_INVALID;
}

/**
 * shows a simple about dialog.
 */
static void aboutClicked(HildonButton * button, AppData *data) {

	char infoLabel[1000] = "";

	strcat(infoLabel, "<b>About Fahrplan</b>\n");
	strcat(infoLabel, "by smurfy (maemo@smurfy.de)\n");
	strcat(infoLabel, "Version ");
	strcat(infoLabel, APP_VER);

	hildon_banner_show_information_with_markup(
			GTK_WIDGET(data->window),
			NULL,
			infoLabel);

}

/**
 * Creates the top menu
 */
static HildonAppMenu *initMenu(AppData *data) {

	GtkWidget * button;
	HildonAppMenu *menu = HILDON_APP_MENU (hildon_app_menu_new ());

	button = hildon_gtk_button_new(HILDON_SIZE_AUTO);
	gtk_button_set_label(GTK_BUTTON (button), _("About"));

	/* Attach callback to clicked signal */
	g_signal_connect_after (button, "clicked", G_CALLBACK (aboutClicked), data);

	/* Add entry to the view menu */
	hildon_app_menu_append(menu, GTK_BUTTON (button));

	/* Create filters */
	/*
	button = hildon_gtk_radio_button_new(HILDON_SIZE_AUTO, NULL);
	gtk_button_set_label(GTK_BUTTON (button), _("Journey Planner"));
	hildon_app_menu_add_filter(menu, GTK_BUTTON (button));
	gtk_toggle_button_set_mode(GTK_TOGGLE_BUTTON (button), FALSE);

	button = hildon_gtk_radio_button_new_from_widget(HILDON_SIZE_AUTO, GTK_RADIO_BUTTON(button));
	gtk_button_set_label(GTK_BUTTON (button), _("Departures"));
	hildon_app_menu_add_filter(menu, GTK_BUTTON (button));
	gtk_toggle_button_set_mode(GTK_TOGGLE_BUTTON (button), FALSE);
	*/

	gtk_widget_show_all(GTK_WIDGET (menu));

	return menu;
}

/**
 * Creates the main ui with all its buttons and stuff.
 */
void initGui(AppData *data) {

	/* Create the hildon program and setup the title */
	data->program = HILDON_PROGRAM(hildon_program_get_instance());
	g_set_application_name(_("Fahrplan"));

	/* Create HildonWindow and set it to HildonProgram */
	data->window = HILDON_WINDOW(hildon_stackable_window_new());
	hildon_program_add_window(data->program, data->window);

	/* Quit program when window is closed. */
	g_signal_connect (G_OBJECT (data->window), "delete_event",
			G_CALLBACK (gtk_main_quit), NULL);

	/* Quit program when window is otherwise destroyed. */
	g_signal_connect (G_OBJECT (data->window), "destroy",
			G_CALLBACK (gtk_main_quit), NULL);

	/* create vertical container to stack the other containers vertically and add to main view */
	data->verticalContainer = gtk_vbox_new(FALSE, 4);
	gtk_container_add(GTK_CONTAINER(data->window), data->verticalContainer);

	/* create "from" elements */
	data->fromContainer = gtk_hbox_new(FALSE, 4);

	data->fromLabel = gtk_label_new(_("From:"));
	gtk_box_pack_start(GTK_BOX (data->fromContainer), data->fromLabel, FALSE,
			TRUE, 0);
	gtk_widget_set_usize(data->fromLabel, 100, 10);

	data->fromButton = hildon_button_new_with_text(HILDON_SIZE_AUTO,
			HILDON_BUTTON_ARRANGEMENT_HORIZONTAL, _("Station"),
			_("please select"));

	hildon_button_set_style(HILDON_BUTTON(data->fromButton),
			HILDON_BUTTON_STYLE_PICKER);

	g_signal_connect (G_OBJECT (data->fromButton), "clicked", G_CALLBACK (showSearchTextBoxDialog), data);

	gtk_box_pack_start(GTK_BOX (data->fromContainer), data->fromButton, TRUE,
			TRUE, 0);

	gtk_box_pack_start(GTK_BOX (data->verticalContainer), data->fromContainer,
			TRUE, TRUE, 0);

	/* create "to" elements */
	data->toContainer = gtk_hbox_new(FALSE, 4);

	data->toLabel = gtk_label_new(_("To:"));
	gtk_box_pack_start(GTK_BOX (data->toContainer), data->toLabel, FALSE, TRUE,
			0);
	gtk_widget_set_usize(data->toLabel, 100, 10);

	data->toButton = hildon_button_new_with_text(HILDON_SIZE_AUTO,
			HILDON_BUTTON_ARRANGEMENT_HORIZONTAL, _("Station"),
			_("please select"));

	hildon_button_set_style(HILDON_BUTTON(data->toButton),
			HILDON_BUTTON_STYLE_PICKER);

	g_signal_connect (G_OBJECT (data->toButton), "clicked", G_CALLBACK (showSearchTextBoxDialog), data);

	gtk_box_pack_start(GTK_BOX (data->toContainer), data->toButton, TRUE, TRUE,
			0);

	gtk_box_pack_start(GTK_BOX (data->verticalContainer), data->toContainer,
			TRUE, TRUE, 0);

	/* create "time" elements */
	data->timeContainer = gtk_hbox_new(FALSE, 4);

	data->timeDateButton = hildon_date_button_new(HILDON_SIZE_AUTO,
			HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);

	hildon_button_set_title(HILDON_BUTTON (data->timeDateButton), _("Date"));
	gtk_box_pack_start(GTK_BOX (data->timeContainer), data->timeDateButton,
			TRUE, TRUE, 0);

	data->timeTimeButton = hildon_time_button_new(HILDON_SIZE_AUTO,
			HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);
	hildon_button_set_title(HILDON_BUTTON (data->timeTimeButton), _("Time"));

	gtk_box_pack_start(GTK_BOX (data->timeContainer), data->timeTimeButton,
			TRUE, TRUE, 0);

	gtk_box_pack_start(GTK_BOX (data->verticalContainer), data->timeContainer,
			TRUE, TRUE, 0);

	/* options button (for the time */
	data->optionsButton = hildon_picker_button_new(HILDON_SIZE_AUTO,
			HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);
	hildon_button_set_title(HILDON_BUTTON (data->optionsButton),
			_("Use selected date/time as"));

	data->optionsSelector = hildon_touch_selector_new_text();

	hildon_touch_selector_append_text(
			HILDON_TOUCH_SELECTOR (data->optionsSelector), _("Arrival time"));
	hildon_touch_selector_append_text(
			HILDON_TOUCH_SELECTOR (data->optionsSelector), _("Departure time"));

	hildon_touch_selector_set_active(
			HILDON_TOUCH_SELECTOR (data->optionsSelector), 0, 1);

	hildon_picker_button_set_selector(
			HILDON_PICKER_BUTTON (data->optionsButton),
			HILDON_TOUCH_SELECTOR (data->optionsSelector));

	gtk_box_pack_start(GTK_BOX (data->verticalContainer), data->optionsButton,
			TRUE, TRUE, 0);

	/* search button */
	data->searchButton = gtk_button_new_with_label(_("Search"));

	g_signal_connect(G_OBJECT(data->searchButton), "clicked",
			G_CALLBACK(startSearch), data);

	gtk_box_pack_start(GTK_BOX (data->verticalContainer), data->searchButton,
			TRUE, TRUE, 0);

	/* Create menu */
	HildonAppMenu *menu = initMenu (data);

	/* Attach menu to the window */
	hildon_window_set_app_menu (HILDON_WINDOW (data->window), menu);

	gtk_widget_show_all(GTK_WIDGET ( data->window ));

/*
	hildon_button_set_value(HILDON_BUTTON(data->fromButton),
					"Berlin-Tempelhof");

	hildon_button_set_value(HILDON_BUTTON(data->toButton),
						"Feldkirchen Blindenschuhle, Neuwied");
*/
}

/**
 * main entry point. mainly init the basics and then calls the initGui function.
 */
int main(int argc, char* argv[]) {

	AppData *data;

	data = g_new0 (AppData, 1);

	osso_context_t *osso_cont;
	osso_return_t ret;

	locale_init();

	osso_cont = osso_initialize(APP_NAME, APP_VER, TRUE, NULL);
	if (osso_cont == NULL) {
		fprintf(stderr, "osso_initialize failed.\n");
		exit(1);
	}

	/* Initialize the GTK. */
	gtk_init(&argc, &argv);

	initGui(data);

	ret = osso_rpc_set_cb_f(osso_cont, APP_SERVICE, APP_METHOD, APP_SERVICE,
			dbus_callback, GTK_WIDGET( data->window ));
	if (ret != OSSO_OK) {
		fprintf(stderr, "osso_rpc_set_cb_f failed: %d.\n", ret);
		exit(1);
	}

	/* Begin the main application */
	gtk_main();

	g_free(data);

	/* Exit */
	return 0;
}
