/*******************************************************************************

    This file is a part of Fahrplan for maemo 2009-2010

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

*/

#include "parser_mobilebahnde.h"

parserMobileBahnDe::parserMobileBahnDe(QObject *parent)
{
     Q_UNUSED(parent);
     http = new QHttp(this);

     connect(http, SIGNAL(requestFinished(int,bool)),
             this, SLOT(httpRequestFinished(int,bool)));
}

bool parserMobileBahnDe::supportsGps()
{
    return true;
}

ResultInfo parserMobileBahnDe::parseJourneyData(QByteArray data)
{
    QBuffer readBuffer;
    readBuffer.setData(data);
    readBuffer.open(QIODevice::ReadOnly);

    QXmlQuery query;
    query.bindVariable("path", &readBuffer);
    //Query for Header infos
    query.setQuery("declare default element namespace \"http://www.w3.org/1999/xhtml\"; declare variable $path external; doc($path)/html/body/div/div/div[@class='haupt']/span[@class='bold']/string()");

    QStringList headerResults;
    if (!query.evaluateTo(&headerResults))
    {
        qDebug() << "parserMobileBahnDe::parseJourneyData - Query 1 Failed";
    }

    //Query for Time infos
    query.setQuery("declare default element namespace \"http://www.w3.org/1999/xhtml\"; declare variable $path external; doc($path)/html/body/div/div/table/tr/td[@class='overview timelink']/descendant::text()/string()");

    QStringList timelinkResults;
    if (!query.evaluateTo(&timelinkResults))
    {
        qDebug() << "parserMobileBahnDe::parseJourneyData - Query 2 Failed";
    }

    //Query for state infos
    query.setQuery("declare default element namespace \"http://www.w3.org/1999/xhtml\"; declare variable $path external; doc($path)/html/body/div/div/table/tr/td[@class='overview tprt']/string()");

    QStringList stateResults;
    if (!query.evaluateTo(&stateResults))
    {
        qDebug() << "parserMobileBahnDe::parseJourneyData - Query 3 Failed";
    }

    //Query for chanes infos
    query.setQuery("declare default element namespace \"http://www.w3.org/1999/xhtml\"; declare variable $path external; doc($path)/html/body/div/div/table/tr/td[@class='overview']/descendant::text()/string()");

    QStringList changesResults;
    if (!query.evaluateTo(&changesResults))
    {
        qDebug() << "parserMobileBahnDe::parseJourneyData - Query 4 Failed";
    }

    //Query for train infos
    query.setQuery("declare default element namespace \"http://www.w3.org/1999/xhtml\"; declare variable $path external; doc($path)/html/body/div/div/table/tr/td[@class='overview iphonepfeil']/descendant::text()[1]/string()");

    QStringList trainResults;
    if (!query.evaluateTo(&trainResults))
    {
        qDebug() << "parserMobileBahnDe::parseJourneyData - Query 5 Failed";
    }

    //Query for error infos
    query.setQuery("declare default element namespace \"http://www.w3.org/1999/xhtml\"; declare variable $path external; doc($path)/html/body/div/div/div/form/div[@class='fline errormsg']/string()");

    QStringList errorsResults;
    if (!query.evaluateTo(&errorsResults))
    {
        qDebug() << "parserMobileBahnDe::parseJourneyData - Query 6 Failed";
    }

    //Query for later url
    query.setQuery("declare default element namespace \"http://www.w3.org/1999/xhtml\"; declare variable $path external; doc($path)/html/body/div/div/ul[@class='neben']/li/a[@class='noBG']/@href/string()");

    QStringList laterUrl;
    if (!query.evaluateTo(&laterUrl))
    {
        qDebug() << "parserMobileBahnDe::parseJourneyData - Query 7 Failed";
    }

    //Query for Details Link infos
    query.setQuery("declare default element namespace \"http://www.w3.org/1999/xhtml\"; declare variable $path external; doc($path)/html/body/div/div/table/tr/td[@class='overview timelink']/a/@href/string()");

    QStringList detailslinkResults;
    if (!query.evaluateTo(&detailslinkResults))
    {
        qDebug() << "parserMobileBahnDe::parseJourneyData - Query 8 Failed";
    }

    ResultInfo result;

    if (errorsResults.count() > 0)
    {
        result.errorMsg = errorsResults[0];
        return result;
    }

    if (headerResults.count() < 3)
    {
        return result;
    }

    if (laterUrl.count() == 1)
    {
        result.laterUrl   = laterUrl[0];
        result.earlierUrl = laterUrl[0];
        result.earlierUrl.replace("e=1", "e=2");
    }

    result.fromStation = headerResults[0];
    result.toStation   = headerResults[1];
    result.timeInfo    = headerResults[2];

    int i;
    for(i=0; i < stateResults.count(); i++)
    {
        ResultItem item;
        item.changes    = changesResults[i * 2];
        item.duration   = changesResults[(i * 2) + 1];
        item.state      = stateResults[i];
        item.trainType  = trainResults[i];
        item.fromTime   = timelinkResults[i * 2];
        item.toTime     = timelinkResults[(i * 2) + 1];
        item.detailsUrl = detailslinkResults[i];
        result.items.append(item);
    }

    delete filebuffer;

    return result;
}

QStringList parserMobileBahnDe::getTrainRestrictions()
{
    QStringList result;
    result.append(tr("All"));
    result.append(tr("All without ICE"));
    result.append(tr("Only local transport"));
    return result;
}

DetailResultInfo parserMobileBahnDe::getJourneyDetailsData(QString queryUrl)
{
    QUrl url(queryUrl);

    DetailResultInfo result;

    http->setHost(url.host(), QHttp::ConnectionModeHttp, url.port() == -1 ? 0 : url.port());

    filebuffer = new QBuffer();

    if (!filebuffer->open(QIODevice::WriteOnly))
    {
        qDebug() << "Can't open Buffer";
    }

    currentRequestId = http->get(url.path() + "?" + url.encodedQuery(), filebuffer);

    loop.exec();

    filebuffer->close();

    //qDebug() <<filebuffer->buffer();

    QString xhtml = filebuffer->buffer();

    //We use Regex to get each element details page
    QRegExp regexp = QRegExp("<div class=\"haupt rline\">(.*)</div>");
    regexp.setMinimal(true);

    int idx = 0;
    int num = 0;
    while (idx >= 0)
    {
        idx = regexp.indexIn(xhtml, idx);
        if (idx >= 0)
        {
            num++;
            QBuffer readBuffer;
            QString element = "<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<body>\n" + regexp.cap(0) + "\n</body>\n</html>\n";

            readBuffer.setData(element.toAscii());
            readBuffer.open(QIODevice::ReadOnly);

            QXmlQuery query;
            query.bindVariable("path", &readBuffer);
            query.setQuery("declare default element namespace \"http://www.w3.org/1999/xhtml\"; declare variable $path external; doc($path)/html/body/div/span[@class='bold']/string()");

            QStringList stationResults;
            if (!query.evaluateTo(&stationResults))
            {
                qDebug() << "parserMobileBahnDe::getJourneyDetailsData - Query 1 Failed";
            }

            query.setQuery("declare default element namespace \"http://www.w3.org/1999/xhtml\"; declare variable $path external; doc($path)/html/body/div/a/span/string()");

            QStringList trainnrResults;
            if (!query.evaluateTo(&trainnrResults))
            {
                qDebug() << "parserMobileBahnDe::getJourneyDetailsData - Query 2 Failed";
            }

            query.setQuery("declare default element namespace \"http://www.w3.org/1999/xhtml\"; declare variable $path external; doc($path)/html/body/div/child::text()/string()");

            QStringList txtResults;
            if (!query.evaluateTo(&txtResults))
            {
                qDebug() << "parserMobileBahnDe::getJourneyDetailsData - Query 3 Failed";
            }

            /*
            qDebug() <<num;
            qDebug() <<element;
            qDebug() <<stationResults;
            qDebug() <<trainnrResults;
            qDebug() <<txtResults;
            */

            if (stationResults.count() == 2)
            {
                DetailResultItem item;
                item.fromStation = stationResults[0].trimmed();
                item.toStation   = stationResults[1].trimmed();
                if (trainnrResults.count() > 0)
                {
                    item.train = trainnrResults[0].trimmed();
                }

                QString tmp = txtResults.join(" ");
                tmp.replace("  ", " ");
                tmp.replace("\n", " ");

                //Check and Parse departure and arrival Times
                QRegExp tmpRegexp = QRegExp("(dep) (.+) on (.*) (arr) (.+) on (.*) ");
                tmpRegexp.setMinimal(true);
                tmpRegexp.indexIn(tmp);

                if (tmpRegexp.cap(0) != "")
                {
                    if (tmpRegexp.cap(1) == "dep")
                    {
                        item.fromInfo = tmpRegexp.cap(2).trimmed() + " on " + tmpRegexp.cap(3).trimmed();

                        QRegExp tmpRegexp2 = QRegExp("(\\d\\d:\\d\\d)");
                        tmpRegexp2.setMinimal(true);
                        tmpRegexp2.indexIn(tmpRegexp.cap(2).trimmed());

                        QDate fromDate = QDate::fromString(tmpRegexp.cap(3).trimmed(), "dd.MM.yy");
                        QTime fromTime = QTime::fromString(tmpRegexp2.cap(1).trimmed(), "hh:mm");

                        fromDate = fromDate.addYears(100); //default is 1900 so we add 100years
                        item.fromTime.setDate(fromDate);
                        item.fromTime.setTime(fromTime);
                    }
                    if (tmpRegexp.cap(4) == "arr")
                    {
                        item.toInfo = tmpRegexp.cap(5).trimmed() + " on " + tmpRegexp.cap(6).trimmed();

                        QRegExp tmpRegexp2 = QRegExp("(\\d\\d:\\d\\d)");
                        tmpRegexp2.setMinimal(true);
                        tmpRegexp2.indexIn(tmpRegexp.cap(5).trimmed());

                        QDate toDate = QDate::fromString(tmpRegexp.cap(6).trimmed(), "dd.MM.yy");
                        QTime toTime = QTime::fromString(tmpRegexp2.cap(1).trimmed(), "hh:mm");

                        toDate = toDate.addYears(100); //default is 1900 so we add 100years
                        item.toTime.setDate(toDate);
                        item.toTime.setTime(toTime);
                    }
                } else
                {
                    tmp = tmp.trimmed();
                    item.info.append(tmp);
                }

                result.items.append(item);
            } else
            {
                for (int i = 0; i < txtResults.count(); i++)
                {
                    QString tmp = txtResults[i];
                    tmp.replace("  ", " ");
                    tmp.replace("\n", " ");

                    //Check and Parse departure and arrival Times
                    QRegExp tmpRegexp = QRegExp("(Duration|Hint)(.*)$");
                    tmpRegexp.setMinimal(true);
                    tmpRegexp.indexIn(tmp);
                    if (tmpRegexp.cap(0) != "")
                    {
                        if (tmpRegexp.cap(1) == "Duration")
                        {
                            result.duration = tmpRegexp.cap(2).trimmed();
                        }
                        if (tmpRegexp.cap(1) == "Hint")
                        {
                            result.info = tmpRegexp.cap(2).trimmed();
                        }
                    }
                }
            }
            ++idx;
        }
    }

    return result;
}

ResultInfo parserMobileBahnDe::getJourneyData(QString queryUrl)
{
    QUrl url(queryUrl);

    http->setHost(url.host(), QHttp::ConnectionModeHttp, url.port() == -1 ? 0 : url.port());

    filebuffer = new QBuffer();

    if (!filebuffer->open(QIODevice::WriteOnly))
    {
        qDebug() << "Can't open Buffer";
    }

    currentRequestId = http->get(url.path() + "?" + url.encodedQuery(), filebuffer);

    loop.exec();

    filebuffer->close();

    //qDebug() <<filebuffer->buffer();

    return parseJourneyData(filebuffer->buffer());
}

ResultInfo parserMobileBahnDe::getJourneyData(QString destinationStation, QString arrivalStation, QString viaStation, QDate date, QTime time, int mode, int trainrestrictions)
{
    Q_UNUSED(viaStation);

    QString trainrestr = "1:1111111111000000";
    if (trainrestrictions == 0) {
        trainrestr = "1:1111111111000000"; //ALL
    } else if (trainrestrictions == 1) {
        trainrestr = "2:0111111111000000"; //All without ICE
    } else if (trainrestrictions == 2) {
        trainrestr = "4:00011111110000000"; //Only local transport
    }

    QUrl url("http://mobile.bahn.de/bin/mobil/query.exe/eox?rt=1&use_realtime_filter=1&searchMode=NORMAL");

    //Postdata for normal Search
    QString postData = "REQ0JourneyStopsS0A=1&REQ0JourneyStopsS0G=" +
                          destinationStation +
                          "&REQ0JourneyStopsS0ID=&REQ0JourneyStopsZ0A=1&REQ0JourneyStopsZ0G=" +
                          arrivalStation +
                          "&REQ0JourneyStopsZ0ID=&REQ0JourneyDate=" +
                          date.toString("dd.MM.yyyy") +
                          "&REQ0JourneyTime=" +
                          time.toString("hh:mm") +
                          "&REQ0HafasSearchForw=" +
                          QString::number(mode) +
                          "&REQ0JourneyProduct_prod_list=" +
                          trainrestr +
                          "&existOptimizePrice=1&REQ0HafasOptimize1=0%3A1&existProductNahverkehr=yes&REQ0Tariff_TravellerAge.1=35&start=Suchen&REQ0Tariff_Class=2&REQ0Tariff_TravellerReductionClass.1=0";

    http->setHost(url.host(), QHttp::ConnectionModeHttp, url.port() == -1 ? 0 : url.port());

    filebuffer = new QBuffer();

    if (!filebuffer->open(QIODevice::WriteOnly))
    {
        qDebug() << "Can't open Buffer";
    }

    QHttpRequestHeader header;
    header.setRequest("POST", url.path() + "?" + url.encodedQuery());
    header.setValue("Host", url.host());

    currentRequestId = http->request(header, postData.toAscii(), filebuffer);

    loop.exec();

    filebuffer->close();

    //qDebug() <<filebuffer->buffer();

    //Check if we need do a search by id, sometimes the search for the exact name
    //returns a selectbox again, so we check for it and if there are selectboxes
    //we search by the ids we get as response

    QBuffer readBuffer;
    readBuffer.setData(filebuffer->buffer());
    readBuffer.open(QIODevice::ReadOnly);

    QXmlQuery query;
    query.bindVariable("path", &readBuffer);
    //Query for more than one result
    query.setQuery("declare default element namespace \"http://www.w3.org/1999/xhtml\"; declare variable $path external; doc($path)/html/body/div/div/div/form/div/select[@name='REQ0JourneyStopsS0K']/option/string()");

    QStringList departureResult;
    if (!query.evaluateTo(&departureResult))
    {
        qDebug() << "parserMobileBahnDe::getJourneyData - Query 1 Failed";
    }

    query.setQuery("declare default element namespace \"http://www.w3.org/1999/xhtml\"; declare variable $path external; doc($path)/html/body/div/div/div/form/div/select[@name='REQ0JourneyStopsZ0K']/option/string()");

    QStringList arrivalResult;
    if (!query.evaluateTo(&arrivalResult))
    {
        qDebug() << "parserMobileBahnDe::getJourneyData - Query 2 Failed";
    }

    query.setQuery("declare default element namespace \"http://www.w3.org/1999/xhtml\"; declare variable $path external; doc($path)/html/body/div/div/div/form/div/select[@name='REQ0JourneyStopsS0K']/option/@value/string()");

    QStringList departureResultIds;
    if (!query.evaluateTo(&departureResultIds))
    {
        qDebug() << "parserMobileBahnDe::getJourneyData - Query 3 Failed";
    }

    query.setQuery("declare default element namespace \"http://www.w3.org/1999/xhtml\"; declare variable $path external; doc($path)/html/body/div/div/div/form/div/select[@name='REQ0JourneyStopsZ0K']/option/@value/string()");

    QStringList arrivalResultIds;
    if (!query.evaluateTo(&arrivalResultIds))
    {
        qDebug() << "parserMobileBahnDe::getJourneyData - Query 4 Failed";
    }

    query.setQuery("declare default element namespace \"http://www.w3.org/1999/xhtml\"; declare variable $path external; doc($path)/html/body/div/div/div/form/@action/string()");

    QStringList formUrl;
    if (!query.evaluateTo(&formUrl))
    {
        qDebug() << "parserMobileBahnDe::getJourneyData - Query 5 Failed";
    }

    query.setQuery("declare default element namespace \"http://www.w3.org/1999/xhtml\"; declare variable $path external; doc($path)/html/body/div/div/div/form/div/input[@name='REQ0JourneyStopsS0K']/@value/string()");

    QStringList destinationStationIds;
    if (!query.evaluateTo(&destinationStationIds))
    {
        qDebug() << "parserMobileBahnDe::getJourneyData - Query 6 Failed";
    }

    query.setQuery("declare default element namespace \"http://www.w3.org/1999/xhtml\"; declare variable $path external; doc($path)/html/body/div/div/div/form/div/input[@name='REQ0JourneyStopsZ0K']/@value/string()");

    QStringList arrivalStationIds;
    if (!query.evaluateTo(&arrivalStationIds))
    {
        qDebug() << "parserMobileBahnDe::getJourneyData - Query 7 Failed";
    }

    if (departureResult.count() > 0 || arrivalResult.count() > 0)
    {
        QString destinationStationId = "";
        QString arrivalStationId = "";

        if (departureResult.count() > 0)
        {
            for (int i = 0; i < departureResult.count(); i++)
            {
                if ((QString)departureResult[i] == destinationStation)
                {
                    destinationStationId = departureResultIds[i];
                }
            }
        } else
        {
            destinationStationId = destinationStationIds[0];
        }

        if (arrivalResult.count() > 0)
        {
            for (int i = 0; i < arrivalResult.count(); i++)
            {
                if ((QString)arrivalResult[i] == arrivalStation)
                {
                    arrivalStationId = arrivalResultIds[i];
                }
            }
        } else
        {
            arrivalStationId = arrivalStationIds[0];
        }

        QUrl newUrl(formUrl[0]);

        postData = "REQ0JourneyStopsS0A=1&REQ0JourneyStopsS0K=" +
                                  destinationStationId +
                                  "&REQ0JourneyStopsS0ID=&REQ0JourneyStopsZ0A=1&REQ0JourneyStopsZ0K=" +
                                  arrivalStationId +
                                  "&REQ0JourneyStopsZ0ID=&REQ0JourneyDate=" +
                                  date.toString("dd.MM.yyyy") +
                                  "&REQ0JourneyTime=" +
                                  time.toString("hh:mm") +
                                  "&REQ0HafasSearchForw=" +
                                  QString::number(mode) +
                                  "&existOptimizePrice=1&REQ0HafasOptimize1=0%3A1&existProductNahverkehr=yes&REQ0Tariff_TravellerAge.1=35&start=Suchen&REQ0Tariff_Class=2&REQ0Tariff_TravellerReductionClass.1=0";
        filebuffer = new QBuffer();

        if (!filebuffer->open(QIODevice::WriteOnly))
        {
            qDebug() << "Can't open Buffer";
        }

        header.setRequest("POST", newUrl.path() + "?" + newUrl.encodedQuery());
        header.setValue("Host", newUrl.host());

        currentRequestId = http->request(header, postData.toAscii(), filebuffer);

        loop.exec();

        filebuffer->close();
    }

    return parseJourneyData(filebuffer->buffer());
}

QStringList parserMobileBahnDe::getStationsByGPS(qreal latitude, qreal longitude)
{
    //We must format the lat and longitude to have the ??.?????? format.
    QString zeros      = "0";
    QString sLongitude = QString::number(longitude).append(zeros.repeated(6));
    QString sLatitude  = QString::number(latitude).append(zeros.repeated(6));

    QRegExp regexp = QRegExp("(\\d*)\\.(\\d\\d\\d\\d\\d\\d)(\\d*)");
    regexp.setMinimal(true);

    regexp.indexIn(sLongitude);
    sLongitude = regexp.cap(1) + regexp.cap(2);

    regexp.indexIn(sLatitude);
    sLatitude = regexp.cap(1) + regexp.cap(2);

    QString fullUrl = "http://mobile.bahn.de/bin/mobil/query.exe/eox?rt=1&use_realtime_filter=1&stationNear=1&look_x=" +
                      sLongitude +
                      "&look_y=" +
                      sLatitude +
                      "&performLocating=2&tpl=stopsnear&look_maxdist=1000&look_stopclass=1023&n=1";

    qDebug()<<"GPS REQUEST URL:"<<fullUrl;

    qDebug()<<"GPS RAW VALUES: LAT"<<latitude<<" LONG:"<<longitude;

    QUrl url(fullUrl);

    http->setHost(url.host(), QHttp::ConnectionModeHttp, url.port() == -1 ? 0 : url.port());

    filebuffer = new QBuffer();

    if (!filebuffer->open(QIODevice::WriteOnly))
    {
        qDebug() << "Can't open Buffer";
    }

    currentRequestId = http->get(url.path() + "?" + url.encodedQuery(), filebuffer);

    loop.exec();

    filebuffer->close();

    QBuffer readBuffer;
    readBuffer.setData(filebuffer->buffer());
    readBuffer.open(QIODevice::ReadOnly);

    QXmlQuery query;
    query.bindVariable("path", &readBuffer);
    //Query for Gps infos
    query.setQuery("declare default element namespace \"http://www.w3.org/1999/xhtml\"; declare variable $path external; doc($path)/html/body/div/div/div/div/a[@class='uLine']/string()");

    QStringList result;
    if (!query.evaluateTo(&result))
    {
        qDebug() << "parserMobileBahnDe::getStationsByGPS - Query Failed";
    }

    delete filebuffer;

    result.removeDuplicates();

    return result;
}


QStringList parserMobileBahnDe::getStationsByName(QString stationName)
{
    QByteArray postData = "REQ0JourneyStopsS0A=1&REQ0JourneyStopsS0G=";
    postData.append(stationName);

    QUrl url("http://mobile.bahn.de/bin/mobil/query.exe/eox?rt=1&use_realtime_filter=1&searchMode=NORMAL");

    http->setHost(url.host(), QHttp::ConnectionModeHttp, url.port() == -1 ? 0 : url.port());

    filebuffer = new QBuffer();

    if (!filebuffer->open(QIODevice::WriteOnly))
    {
        qDebug() << "Can't open Buffer";
    }

    QHttpRequestHeader header;
    header.setRequest("POST", url.path() + "?" + url.encodedQuery());
    header.setValue("Host", url.host());

    currentRequestId = http->request(header, postData, filebuffer);

    loop.exec();

    filebuffer->close();

    QBuffer readBuffer;
    readBuffer.setData(filebuffer->buffer());
    readBuffer.open(QIODevice::ReadOnly);

    QXmlQuery query;
    query.bindVariable("path", &readBuffer);
    //Query for more than one result
    query.setQuery("declare default element namespace \"http://www.w3.org/1999/xhtml\"; declare variable $path external; doc($path)/html/body/div/div/div/form/div/select[@name='REQ0JourneyStopsS0K']/option/string()");

    QStringList result;
    if (!query.evaluateTo(&result))
    {
        qDebug() << "parserMobileBahnDe::getStationsByName - Query 1 Failed";
    }

    if (result.count() == 0)
    {
        //Query for only one result
        query.setQuery("declare default element namespace \"http://www.w3.org/1999/xhtml\"; declare variable $path external; doc($path)/html/body/div/div/div/form/div/span[@class='fixedLoc']/string()");
        if (!query.evaluateTo(&result))
        {
            qDebug() << "parserMobileBahnDe::getStationsByName - Query 2 Failed";
        }
    }

    delete filebuffer;

    return result;
}
