/*******************************************************************************

    This file is a part of Fahrplan for maemo 2009-2010

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

*/

#include "selectstationdialog.h"

selectStationDialog::selectStationDialog(QMaemo5ValueButton *sender, QGeoPositionInfo *position, parserAbstract *mainBackendParser, QSettings *mainSettings)
{
    setWindowTitle(tr("City Stationname"));

    mainSender     = sender;
    myPositionInfo = position;
    backendParser  = mainBackendParser;
    settings       = mainSettings;

    QGtkStyle *gtkStyle = new QGtkStyle();

    searchboxCombo  = new QComboBox();
    searchboxText   = new QLineEdit();
    searchboxCombo->setEditable(true);
    //We using GTK style instead of the maemo one, because
    //i get design errors if i use maemo :D
    searchboxCombo->setStyle(gtkStyle);

    QStringList oldList;
    oldList = settings->value("lastsearch/stations", oldList).toStringList();

    //we reverse the list to get the latest stations on the top
    oldList = fahrplanUtils::reverseQStringList(oldList);

    searchboxCombo->addItems(oldList);
    searchboxCombo->setEditText("");

    gpsButton    = new QPushButton(tr("GPS"));
    searchButton = new QPushButton(tr("Search"));
    connect(searchButton, SIGNAL(clicked(bool)), this, SLOT(searchButtonClicked(bool)));
    connect(gpsButton, SIGNAL(clicked(bool)), this, SLOT(gpsButtonClicked(bool)));

    if (myPositionInfo->isValid())
    {
        gpsButton->setEnabled(backendParser->supportsGps());

        if (settings->value("openstreetmapfallback", true).toBool() == true)
        {
            gpsButton->setEnabled(true);
        }
    } else
    {
        gpsButton->setEnabled(false);
    }

    QHBoxLayout *hLayout = new QHBoxLayout;
    QVBoxLayout *vLayout = new QVBoxLayout;

    QWidget *vContainer  = new QWidget;

    searchboxCombo->setFixedWidth(520);
    searchboxCombo->setFixedHeight(72);
    searchboxText->setFixedWidth(520);
    searchboxText->setFixedHeight(72);
    gpsButton->setFixedWidth(210);
    searchButton->setFixedWidth(210);

    vLayout->setMargin(0);
    vLayout->setStretch(0,0);
    vLayout->setSpacing(0);
    vLayout->addWidget(gpsButton);
    vLayout->addWidget(searchButton);
    vContainer->setLayout(vLayout);

    if (settings->value("storelastsearch", true).toBool() ==  true)
    {
        hLayout->addWidget(searchboxCombo);
    } else
    {
        hLayout->addWidget(searchboxText);
    }
    hLayout->addWidget(vContainer);

    setLayout(hLayout);
}


void selectStationDialog::showSelector(QStringList items)
{
    //If only one entry found we directly use it.
    if (items.count() == 1)
    {
        mainSender->setValueText(items[0]);
        this->hide();
        return;
    }

    QStandardItemModel * stationsModel = new QStandardItemModel(0, 1);

    QString string;
    foreach(string, items)
    {
        //qDebug() << "- " << string;
        QStandardItem *item = new QStandardItem(string);
        item->setTextAlignment(Qt::AlignCenter);
        item->setEditable(false);
        stationsModel->appendRow(item);
    }

    QMaemo5ValueButton *tmpButton = new QMaemo5ValueButton(tr("Select a station"));
    tmpButton->setValueLayout(QMaemo5ValueButton::ValueBesideText);
    QMaemo5ListPickSelector *tmpSelector = new QMaemo5ListPickSelector;
    connect(tmpSelector, SIGNAL(selected(QString)), this, SLOT(stationSelected(QString)));
    tmpSelector->setModel(stationsModel);
    tmpButton->setPickSelector(tmpSelector);
    tmpButton->click();
}

void selectStationDialog::stationSelected(QString value)
{
    if (value != "")
    {
        mainSender->setValueText(value);
        this->hide();
    }
}

void selectStationDialog::searchButtonClicked(bool checked)
{
    Q_UNUSED(checked);

    searchButton->setEnabled(false);

    QStringList result;

    QString str = searchboxText->text();
    if (settings->value("storelastsearch", true).toBool() ==  true)
    {
        str = searchboxCombo->currentText();
    }

    result = backendParser->getStationsByName(str);

    searchButton->setEnabled(true);

    if (result.count() > 0)
    {
        showSelector(result);
    } else
    {
        QMaemo5InformationBox::information(this, "<br>Station not found.<br>", QMaemo5InformationBox::DefaultTimeout);
    }
}

void selectStationDialog::gpsButtonClicked(bool checked)
{
    Q_UNUSED(checked);

    if (myPositionInfo->isValid())
    {
        gpsButton->setEnabled(false);

        // Get the current location as latitude and longitude
        QGeoCoordinate geoCoordinate = myPositionInfo->coordinate();
        qreal latitude = geoCoordinate.latitude();
        qreal longitude = geoCoordinate.longitude();

        QStringList result;

        result = backendParser->getStationsByGPS(latitude, longitude);

        gpsButton->setEnabled(true);

        if (result.count() > 0)
        {
            showSelector(result);
        } else
        {
            if (settings->value("openstreetmapfallback", true).toBool() == true)
            {
                backupGpsOpenstreetmap *fallbackGPS = new backupGpsOpenstreetmap();

                QString streetName = fallbackGPS->getNearestStreet(latitude, longitude);

                if (streetName != "")
                {
                    result = backendParser->getStationsByName(streetName);
                }

                QString cityName = "";

                if (result.count()== 0)
                {
                    cityName = fallbackGPS->getNearestCity(latitude, longitude);
                }

                if (cityName != "")
                {
                    result = backendParser->getStationsByName(cityName);
                }

                if (result.count() > 0)
                {
                    showSelector(result);
                } else
                {
                    QMaemo5InformationBox::information(this, "<br>No station found on GPS position.<br>", QMaemo5InformationBox::DefaultTimeout);
                }
            } else
            {
                QMaemo5InformationBox::information(this, "<br>No station found on GPS position.<br>", QMaemo5InformationBox::DefaultTimeout);
            }
        }
    }
}
