/*******************************************************************************

 This file is a part of Fahrplan for maemo 2009-2010

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/*
 ============================================================================
 Name        : fahrplan_parser_openstreetmap.c
 Author      : qbast, smurfy
 Version     : 0.1
 Description : Fallback backend for GPS Data based on openstreetmap
 ============================================================================
 */
#include "fahrplan_utils.h"
#include "fahrplan_parser_openstreetmap.h"

gchar * getByTag(gchar * xml, gchar * open, gchar * close) 
{
	gchar * start=strstr(xml,open);
	if (!start) { 
		return NULL;
	}
	start+=strlen(open);
	gchar* end=strstr(start,close);
	if (!end) {
		return NULL;
	}
	return strndup(start, (end-start));
}

gchar * getCityNameByGPS(gfloat longitude, gfloat latitude)
{
	char * oldloc=setlocale(LC_NUMERIC,"C");
	gchar * url = g_strdup_printf("http://nominatim.openstreetmap.org/reverse?lon=%f&lat=%f&format=xml", longitude, latitude);
	setlocale(LC_NUMERIC,oldloc);
	gchar * result   = performCurlRequest(url, NULL);

	if (!result) {

		return NULL;
	}
	
	gchar* name = getByTag(result,"<city>","</city>");
	if (name != NULL) return name;
	name = getByTag(result,"<town>","</town>");
	if (name != NULL) return name;
	name = getByTag(result,"<village>","</village>");
	return name;	
}
