/*******************************************************************************

 This file is a part of Fahrplan for maemo 2009-2010

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/*
 ============================================================================
 Name        : fahrplan_parser_mobilebahnde.h
 Author      : smurfy
 Version     : 0.1
 Description : mobile.bahn.de Backend
 ============================================================================
 */

#ifndef _fahrplan_parser_mobilebahnde_h
#define _fahrplan_parser_mobilebahnde_h 1

#include "fahrplan_utils.h"
#include "localisation.h"
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <libxml/parser.h>
#include <libxml/tree.h>
#include <libxml/globals.h>

GArray * getStationsByName_mobilebahnde(gchar *stationName);
GArray * getStationsByGPS_mobilebahnde(gint longitude, gint latitude);
ResultInfo * getJourneyData_mobilebahnde(gchar *fromStation, gchar *viaStation, gchar *toStation, gint day, gint month, gint year, gint hour, gint minutes, gint options);
ResultInfo * getJourneyDataByUrl_mobilebahnde(gchar *url);
DetailInfo * getJourneyDetailDataByUrl_mobilebahnde(gchar *url);

DetailInfo * mobilebahnde_parseSearchDetails(gchar *returnData);
ResultInfo * mobilebahnde_parseSearchResult(gchar *returnData);
GArray * mobilebahnde_getResultValues(xmlNode * a_node);
char * mobilebahnde_getIdForName(char *name, char * dataText);
mobilebahnde_applyMissingHttp(gchar * url);

#endif
