/*******************************************************************************

/*
    This file is a part of Fahrplan for maemo 2009-2010

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
 ============================================================================
 Name        : main.c
 Author      : smurfy
 Version     : 0.0.1
 Description : Fahrplan application for german trains
 ============================================================================
 */
/* Includes */
#include <hildon/hildon.h>
#include <hildon/hildon-button.h>
#include <hildon/hildon-program.h>
#include <hildon/hildon-picker-button.h>
#include <stdio.h>
#include <curl/curl.h>
#include <gtk/gtkmain.h>
#include <gtk/gtkbutton.h>
#include <libosso.h>
#include <string.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <libxml/parser.h>
#include <libxml/tree.h>
#include <libxml/globals.h>
#include <location/location-gps-device.h>
#include <location/location-gpsd-control.h>


#include "localisation.h"

#define APP_NAME "fahrplan"
#define APP_VER "0.0.1"
#define APP_SERVICE "com.nokia.fahrplan"
#define APP_METHOD "/com/nokia/fahrplan"
/* end defines */


/* Application UI data struct */
typedef struct _AppData AppData;
struct _AppData {
    HildonProgram *program;
    HildonWindow *window;
    HildonWindow *resultWindow;

	GtkWidget *verticalContainer;
	GtkWidget *fromContainer;
	GtkWidget *fromSelector;
	GtkWidget *fromButton;
	GtkWidget *fromLabel;
	GtkWidget *toContainer;
	GtkWidget *toSelector;
	GtkWidget *toButton;
	GtkWidget *toLabel;
	GtkWidget *timeContainer;
	GtkWidget *timeDateButton;
	GtkWidget *timeTimeButton;
	GtkWidget *optionsButton;
	GtkWidget *optionsSelector;
	GtkWidget *searchButton;

	GtkWidget *currentDialog;
	GtkWidget *currentSearchTextBox;
	GtkWidget *currentSelector;
	GtkWidget *currentTmpPicker;
	GtkWidget *currentSelectorFor;
	GtkWidget *currentPannableArea;
	GtkWidget *currentPannableAreaVbox;
};

/**
 * Structure for CURL Data used in combination of copyDataBuffer
 * to store the curl response.
 */
struct CURLData {
  char *buf;
  size_t pos;
  size_t size;
};

/**
 * Copys data from internal curl buffer to our own buffer.
 */
static size_t copyDataBuffer (void *ptr, size_t size, size_t nmemb, void *ctx)
{
	struct CURLData *bufData = ctx;

	if (bufData->pos + size * nmemb > bufData->size)
		return 0;                   /* overflow */

	memcpy (&bufData->buf[bufData->pos], ptr, size * nmemb);
	bufData->pos += size * nmemb;
	return size * nmemb;
}

/**
 * Parse function for the search result. given as libxml node.
 */
static void getResultValues(xmlNode * a_node, AppData *data)
{
    xmlNode *cur_node = NULL;
    xmlNode *tmp_node = NULL;

    int num = 0;
    int found = 0;
    char timeStr[100] = "";
    char *otherStr = "";
    char *changeStr = "";
    char *trainTypeStr = "";

    for (cur_node = a_node; cur_node; cur_node = cur_node->next) {

        if (cur_node->type == XML_ELEMENT_NODE && cur_node->parent->type == XML_ELEMENT_NODE && !strcmp(cur_node->parent->name, "tr")) {

        	switch(num) {

				case 0:

					if (!strcmp(cur_node->children->name, "a")) {

						found = 1;

					    int addTo = 0;
						for (tmp_node = cur_node->children->children; tmp_node; tmp_node = tmp_node->next) {

							if (!strcmp(tmp_node->name, "text")) {

								strcat(timeStr, tmp_node->content);
								if (!addTo) {
									strcat(timeStr, _(" to "));
								}
								addTo = 1;
							}
						}

					}
					break;
				case 2:

					if (!strcmp(cur_node->children->name, "text")) {

						changeStr = cur_node->children->content;
					}
					break;
				case 3:

					if (!strcmp(cur_node->children->name, "text")) {

						trainTypeStr = cur_node->children->content;
					}
					break;
        	}

        	num++;

        } else {

			getResultValues(cur_node->children, data);
        }
    }

    if (found) {

    	char infoLabel[100];

    	sprintf(infoLabel, "%s %s %s (%s %s)", timeStr, _(" with "), trainTypeStr, changeStr, _("transfers"));
    	GtkWidget *infoButton;
    	infoButton = gtk_button_new_with_label (infoLabel);

    	gtk_box_pack_start(GTK_BOX (data->currentPannableAreaVbox), infoButton, TRUE, TRUE, 0);

    	/* g_debug("stuff: %s , %s , %s ", timeStr, changeStr, trainTypeStr); */
    }
}

/**
 *  Starts the search itself, also first checks if from and to station are selected.
 */
static void startSearch(GtkButton* button, AppData * data) {

	gchar *fromText = hildon_button_get_value(HILDON_BUTTON(data->fromButton));
	gchar *toText = hildon_button_get_value(HILDON_BUTTON(data->toButton));

	if (strcmp(fromText, "") && strcmp(fromText, _("please select")) &&
			strcmp(toText, "") && strcmp(toText, _("please select"))) {

		/* Set process indicator */
		hildon_gtk_window_set_progress_indicator(GTK_WINDOW(data->window), 1);

		gint optionsSelected = hildon_touch_selector_get_active(HILDON_TOUCH_SELECTOR(data->optionsSelector), 0);
		gint year;
		gint month;
		gint day;
		gint hour;
		gint minutes;

		hildon_date_button_get_date(HILDON_DATE_BUTTON(data->timeDateButton), &year, &month, &day);

		hildon_time_button_get_time(HILDON_TIME_BUTTON(data->timeTimeButton), &hour, &minutes);

		g_debug("FROM: %s", fromText);
		g_debug("TO: %s", toText);
		g_debug("DATE: %d.%d.%d", day, month, year);
		g_debug("TIME: %d:%d", hour, minutes);
		g_debug("OPTIONS: %d", optionsSelected);

		/* Start Curl search */
		CURL *curl;
		CURLcode res;
		char buf[10000];
		struct CURLData curldata;

		curldata.buf = buf;
		curldata.size = 10000;
		curldata.pos = 0;

		curl = curl_easy_init();
		if (curl) {

			char postdata[2000];
			int postdataCount = sprintf(postdata, "REQ0JourneyStopsS0A=1&REQ0JourneyStopsS0G=%s&REQ0JourneyStopsS0ID=&REQ0JourneyStopsZ0A=1&REQ0JourneyStopsZ0G=%s&REQ0JourneyStopsZ0ID=&REQ0JourneyDate=%d.%d.%d&REQ0JourneyTime=%d:%d&REQ0HafasSearchForw=%d&existOptimizePrice=1&REQ0HafasOptimize1=0%3A1&existProductNahverkehr=yes&REQ0Tariff_TravellerAge.1=35&start=Suchen&REQ0Tariff_Class=2&REQ0Tariff_TravellerReductionClass.1=0",
					fromText, toText, day, month + 1, year, hour, minutes, optionsSelected);

			postdata[postdataCount] = '\0';

			/* request the base url to get a "sessionId" */
			curl_easy_setopt(curl, CURLOPT_URL, "http://mobile.bahn.de/bin/mobil/query.exe/dox?rt=1&use_realtime_filter=1&searchMode=NORMAL");
	        curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, &copyDataBuffer);
			curl_easy_setopt(curl, CURLOPT_WRITEDATA, &curldata);
	        curl_easy_setopt(curl, CURLOPT_FAILONERROR, 1);
			curl_easy_setopt(curl, CURLOPT_TIMEOUT, 150L);
			curl_easy_setopt(curl, CURLOPT_CONNECTTIMEOUT, 15L);
			curl_easy_setopt(curl, CURLOPT_POSTFIELDS, postdata);

			g_debug("POST: %s", postdata);

			res = curl_easy_perform(curl);

			if (res != CURLE_OK) {

				hildon_banner_show_information(GTK_WIDGET(data->window), NULL, _("An error occured while requesting data over the internet."));
				g_debug("CURL_ERROR: %d", res);

				return;
			}

			/* Hide process indicator */
			hildon_gtk_window_set_progress_indicator(GTK_WINDOW(data->window), 0);


			/* check errors */
			char *errorDataFrom = strstr(curldata.buf, "<span class=\"error\">");

			if (errorDataFrom) {

				char *errorDataTo = strstr(errorDataFrom, "</span>");
				int count = errorDataTo - errorDataFrom + 7;
				char errorData[count];
				strncpy (errorData, errorDataFrom, count);

				errorData[count] = '\0';

				xmlDoc *doc = NULL;
				xmlNode *root_element = NULL;

				/*parse the file and get the DOM */
				doc = xmlReadDoc(errorData, NULL, NULL, 0);

				/*Get the root element node */
				root_element = xmlDocGetRootElement(doc);

				hildon_banner_show_information(GTK_WIDGET(data->window), NULL, root_element->children->content);

				return;
			}


			/* Create the Subview for results */
			data->resultWindow = HILDON_WINDOW(hildon_stackable_window_new());
			gtk_window_set_title(GTK_WINDOW (data->resultWindow), _("Fahrplan for maemo / Results"));

			GtkWidget *vbox;
			GtkWidget *fromLabel;
			GtkWidget *toLabel;
			GtkWidget *dateLabel;

			vbox = gtk_vbox_new(FALSE, 0);

			/* GET HEADER */

		   /* g_debug("RESULT: %s", curldata.buf); */

			char *headerDataFrom = strstr(curldata.buf, "<p class=\"qs\">");

			if (headerDataFrom) {

				char *headerDataTo = strstr(headerDataFrom, "</p>");
				int count = headerDataTo - headerDataFrom + 4;
				char headerData[count];
				strncpy (headerData, headerDataFrom, count);

				headerData[count] = '\0';

				/* g_debug("RESULT: %s", headerData); */

				xmlDoc *doc = NULL;
				xmlNode *root_element = NULL;

				/*parse the file and get the DOM */
				doc = xmlReadDoc(headerData, NULL, NULL, 0);

				/*Get the root element node */
				root_element = xmlDocGetRootElement(doc);

			    xmlNode *cur_node = NULL;

			    int num = 0;

			    for (cur_node = root_element->children; cur_node; cur_node = cur_node->next) {

			    	if (!strcmp(cur_node->name, "span")) {

			    		num++;
			    		g_debug("X: %s", cur_node->children->content);

			    		switch(num) {

							case 1:
								fromLabel = gtk_label_new(cur_node->children->content);
								break;
							case 2:
								toLabel = gtk_label_new(cur_node->children->content);
								break;
							case 3:
								dateLabel = gtk_label_new(cur_node->children->content);
								break;
			    		}
			    	}
			    }

				gtk_box_pack_start(GTK_BOX (vbox), fromLabel, FALSE, TRUE, 0);
				gtk_box_pack_start(GTK_BOX (vbox), toLabel, FALSE, TRUE, 0);
				gtk_box_pack_start(GTK_BOX (vbox), dateLabel, FALSE, TRUE, 0);
			} else {

				hildon_banner_show_information(GTK_WIDGET(data->window), NULL, _("An unknown error occured."));
				return;
			}

			/* RESULTS ITSELF */

			char *resultDataFrom = strstr(curldata.buf, "<table class=\"ovTable\">");

			if (resultDataFrom) {

				char *resultDataTo = strstr(resultDataFrom, "</table>");
				int count = resultDataTo - resultDataFrom + 8;
				char resultData[count];
				strncpy (resultData, resultDataFrom, count);

				resultData[count] = '\0';

				char *nbspData[count + 51];

				strcpy(nbspData, "<!DOCTYPE doc [\n <!ENTITY nbsp \"&#160;\" > \n]>\n");

				strcat(nbspData, resultData);

				/* g_debug("RESULT: %s", nbspData); */

				xmlDoc *doc = NULL;
				xmlNode *root_element = NULL;

				/*parse the file and get the DOM */
				doc = xmlReadDoc(nbspData, NULL, NULL, 0);

				/*Get the root element node */
				root_element = xmlDocGetRootElement(doc);

				/* Create a new pannable area. */
				data->currentPannableArea = hildon_pannable_area_new ();
				data->currentPannableAreaVbox = gtk_vbox_new(FALSE, 2);

				getResultValues( root_element->children, data);

				hildon_pannable_area_add_with_viewport ( HILDON_PANNABLE_AREA (data->currentPannableArea), data->currentPannableAreaVbox);

				gtk_box_pack_start (GTK_BOX (vbox),
						 data->currentPannableArea,
				                         TRUE,
				                         TRUE,
				                         0);
			}

			/* Show Results */
			gtk_container_add(GTK_CONTAINER (data->resultWindow), vbox);

			gtk_widget_show_all(GTK_WIDGET(data->resultWindow));
		}
	} else {

		hildon_banner_show_information(GTK_WIDGET(data->window), NULL,
					"Please select the from and the to station name.");
		return;
	}

	/*
	 * hildon_gtk_window_set_progress_indicator(GTK_WINDOW(window), 1);
	 * Do the search stuff here
	 *hildon_gtk_window_set_progress_indicator(GTK_WINDOW(window), 0);
	 */
}

/**
 * get values for the selector from a station seaarch (called by getStationsByName)
 */
static void getOptionValues(xmlNode * a_node, AppData *data)
{
    xmlNode *cur_node = NULL;

    for (cur_node = a_node; cur_node; cur_node = cur_node->next) {
        if (cur_node->type == XML_TEXT_NODE && cur_node->parent->type == XML_ELEMENT_NODE && !strcmp(cur_node->parent->name, "option")) {

        	/* g_debug("node type: TEXT, name: %s and content: %s\n", cur_node->name, cur_node->content); */
        	hildon_touch_selector_append_text(HILDON_TOUCH_SELECTOR (data->currentSelector), cur_node->content);
        }

        getOptionValues(cur_node->children, data);
    }
}

/**
 * Callback for the temporary pickerbutton used to display the station search results selector
 */
void selectionChanged(HildonPickerButton * button, AppData *data) {

	gchar *currentSelection = hildon_button_get_value (HILDON_BUTTON (button));

	/* g_debug ("Current selection : %s",currentSelection); */

	if (strcmp(currentSelection, "")) {

		hildon_button_set_value(HILDON_BUTTON(data->currentSelectorFor), currentSelection);
	}
}

/**
 * called from the select station dialog if "search" pressed.
 * searchs the given station name from the textbox and displays a selector on success.
 */
void getStationsByName(GtkWidget *w, AppData * data) {

	gchar *searchFor = hildon_entry_get_text(HILDON_ENTRY(data->currentSearchTextBox));

	/* Set process indicator */
	hildon_gtk_window_set_progress_indicator(GTK_WINDOW(data->currentDialog), 1);

	/* Hide elements */
	gtk_widget_hide ( GTK_WIDGET (GTK_DIALOG(data->currentDialog)->vbox) );
	gtk_widget_hide ( w );

	/* Start Curl search */
	CURL *curl;
	CURLcode res;
	char buf[10000];
	struct CURLData curldata;

	curldata.buf = buf;
	curldata.size = 10000;
	curldata.pos = 0;

	curl = curl_easy_init();
	if (curl) {

		char postdata[2000];
		int postdataCount = sprintf(postdata, "REQ0JourneyStopsS0A=1&REQ0JourneyStopsS0G=%s", searchFor);
		postdata[postdataCount] = '\0';

		/* request the base url to get a "sessionId" */
		curl_easy_setopt(curl, CURLOPT_URL, "http://mobile.bahn.de/bin/mobil/query.exe/dox?rt=1&use_realtime_filter=1&searchMode=NORMAL");
        curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, &copyDataBuffer);
		curl_easy_setopt(curl, CURLOPT_WRITEDATA, &curldata);
        curl_easy_setopt(curl, CURLOPT_FAILONERROR, 1);
		curl_easy_setopt(curl, CURLOPT_TIMEOUT, 150L);
		curl_easy_setopt(curl, CURLOPT_CONNECTTIMEOUT, 15L);
		curl_easy_setopt(curl, CURLOPT_POSTFIELDS, postdata);

		/* g_debug("POST: %s", postdata); */

		res = curl_easy_perform(curl);

		if (res != CURLE_OK) {

			hildon_banner_show_information(GTK_WIDGET(data->window), NULL, _("An error occured while requesting data over the internet."));
			gtk_widget_hide  ( data->currentDialog );
			gtk_widget_destroy  ( data->currentDialog );
			data->currentDialog = NULL;

			g_debug("CURL_ERROR: %d", res);

			return;
		}

		char *selectBoxFrom = strstr(curldata.buf, "<select class=\"tpLocList\" name=\"REQ0JourneyStopsS0K\">");

		/* more than one result found */
		if (selectBoxFrom) {

			char *selectBoxTo = strstr(selectBoxFrom, "</select>");
			int count = selectBoxTo - selectBoxFrom + 9;
			char options[count];
			strncpy (options, selectBoxFrom, count);

			options[count] = '\0';

			/* g_debug("RESULT: %s", options); */

			xmlDoc *doc = NULL;
			xmlNode *root_element = NULL;

			/*parse the file and get the DOM */
			doc = xmlReadDoc(options, NULL, NULL, 0);

			/*Get the root element node */
			root_element = xmlDocGetRootElement(doc);

			if (data->currentSelector) {

				gtk_widget_destroy(data->currentSelector);
			}

			data->currentSelector = hildon_touch_selector_new_text();

			getOptionValues(root_element, data);

			/*free the document */
			xmlFreeDoc(doc);

			if (data->currentTmpPicker) {

				gtk_widget_destroy(data->currentTmpPicker);
			}

			data->currentTmpPicker = hildon_picker_button_new(HILDON_SIZE_AUTO, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
			hildon_button_set_title(HILDON_BUTTON (data->currentTmpPicker), _("Stations found"));

			g_signal_connect (G_OBJECT (data->currentTmpPicker), "value-changed",
							  G_CALLBACK (selectionChanged), data);

			hildon_picker_button_set_selector(HILDON_PICKER_BUTTON (data->currentTmpPicker),
						HILDON_TOUCH_SELECTOR (data->currentSelector));

			gtk_button_clicked(GTK_BUTTON (data->currentTmpPicker));
		} else {

			selectBoxFrom = strstr(curldata.buf, "<span class=\"fixedLoc\">");

			if (selectBoxFrom) {

				char *selectBoxTo = strstr(selectBoxFrom, "</span>");
				int count = selectBoxTo - selectBoxFrom + 7;
				char options[count];
				strncpy (options, selectBoxFrom, count);

				options[count] = '\0';

				/* g_debug("RESULT: %s", options); */

				xmlDoc *doc = NULL;
				xmlNode *root_element = NULL;

				/*parse the file and get the DOM */
				doc = xmlReadDoc(options, NULL, NULL, 0);

				/*Get the root element node */
				root_element = xmlDocGetRootElement(doc);

				hildon_button_set_value(HILDON_BUTTON(data->currentSelectorFor), root_element->children->content);
			} else {

				hildon_banner_show_information(GTK_WIDGET(data->window), NULL, _("Strange response received, try again"));
			}
		}

		gtk_widget_hide  ( data->currentDialog );
		gtk_widget_destroy  ( data->currentDialog );
		data->currentDialog = NULL;
    }

}

/**
 * Callback if the "GPS" button on the search for station dialog is pressed.
 * Gets current latitude and longitude and sends a request.
 * after a response received parses it and displays a selector dialog.
 */
void getByGPS( GtkWidget *w, AppData * data) {

	LocationGPSDControl *control = location_gpsd_control_get_default();
	LocationGPSDevice *device = g_object_new(LOCATION_TYPE_GPS_DEVICE, NULL);

	g_object_set(G_OBJECT(control),
			"preferred-method", LOCATION_METHOD_USER_SELECTED,
			"preferred-interval", LOCATION_INTERVAL_DEFAULT,
			NULL);

	location_gpsd_control_start(control);

	int poslat = device->fix->latitude * 1000000;
	int poslong = device->fix->longitude * 1000000;

	location_gpsd_control_stop(control);

	if ((device->fix->latitude > 0) || (device->fix->latitude < 0)) {


	} else {

		hildon_banner_show_information(GTK_WIDGET(data->window), NULL, _("Error with location service"));
		return;
	}

	/* Start Curl search */
	CURL *curl;
	CURLcode res;
	char buf[50000];
	struct CURLData curldata;

	curldata.buf = buf;
	curldata.size = 50000;
	curldata.pos = 0;

	curl = curl_easy_init();
	if (curl) {

		char url[1000];

		int urlCount = sprintf(url, "http://mobile.bahn.de/bin/mobil/query.exe/dox?rt=1&use_realtime_filter=1&stationNear=1&look_x=%d&look_y=%d&performLocating=2&tpl=stopsnear&look_maxdist=1000&look_stopclass=1023&n=1", poslong, poslat);
		url[urlCount] = '\0';

		curl_easy_setopt(curl, CURLOPT_URL, url);
        curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, &copyDataBuffer);
		curl_easy_setopt(curl, CURLOPT_WRITEDATA, &curldata);
        curl_easy_setopt(curl, CURLOPT_FAILONERROR, 1);
		curl_easy_setopt(curl, CURLOPT_TIMEOUT, 150L);
		curl_easy_setopt(curl, CURLOPT_CONNECTTIMEOUT, 15L);

		res = curl_easy_perform(curl);

		if (res != CURLE_OK) {

			hildon_banner_show_information(GTK_WIDGET(data->window), NULL, _("An error occured while requesting data over the internet."));
			gtk_widget_hide  ( data->currentDialog );
			gtk_widget_destroy  ( data->currentDialog );
			data->currentDialog = NULL;

			g_debug("CURL_ERROR: %d", res);

			return;
		}

		char *dataBoxFrom = strstr(curldata.buf, "<div class=\"overview\">");

		if (dataBoxFrom) {

			char *dataBoxTo = strstr(dataBoxFrom, "<p class=\"prio2links\"");
			int count = dataBoxTo - dataBoxFrom;
			char dataBox[count + 6];
			strncpy (dataBox, dataBoxFrom, count);

			dataBox[count] = '\0';

			strcat(dataBox, "</div>");

			g_debug("DATA %s", dataBox);

			xmlDoc *doc = NULL;
			xmlNode *root_element = NULL;

			/*parse the file and get the DOM */
			doc = xmlReadDoc(dataBox, NULL, NULL, 0);

			/*Get the root element node */
			root_element = xmlDocGetRootElement(doc);
			xmlNode *cur_node = NULL;
			xmlNode *tmp_node = NULL;

			if (data->currentSelector) {

				gtk_widget_destroy(data->currentSelector);
			}

			data->currentSelector = hildon_touch_selector_new_text();

			int num = 0;

			for (cur_node = root_element->children; cur_node; cur_node = cur_node->next) {

				if (!strcmp(cur_node->name,"div")) {

					for (tmp_node = cur_node->children; tmp_node; tmp_node = tmp_node->next) {

						if (!strcmp(tmp_node->name, "a")) {

							num++;
							/* g_debug("-- %s", tmp_node->children->content); */
							hildon_touch_selector_append_text(HILDON_TOUCH_SELECTOR (data->currentSelector), tmp_node->children->content);
						}
					}
				}
			}

			if (num > 0) {

				if (data->currentTmpPicker) {

					gtk_widget_destroy(data->currentTmpPicker);
				}

				data->currentTmpPicker = hildon_picker_button_new(HILDON_SIZE_AUTO, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
				hildon_button_set_title(HILDON_BUTTON (data->currentTmpPicker), _("Stations found"));

				g_signal_connect (G_OBJECT (data->currentTmpPicker), "value-changed",
								  G_CALLBACK (selectionChanged), data);

				hildon_picker_button_set_selector(HILDON_PICKER_BUTTON (data->currentTmpPicker),
							HILDON_TOUCH_SELECTOR (data->currentSelector));

				gtk_button_clicked(GTK_BUTTON (data->currentTmpPicker));

				gtk_widget_hide  ( data->currentDialog );
				gtk_widget_destroy  ( data->currentDialog );
				data->currentDialog = NULL;

				/*

				char *label[200];

				sprintf(label, "Found %d Stations in reach", num);

				hildon_banner_show_information(GTK_WIDGET(data->window), NULL, label);

				*/


			} else {

				/*
				char *label[200];

				sprintf(label, "lat = %d, long = %d", poslat, poslong);

				hildon_banner_show_information(GTK_WIDGET(data->window), NULL, label);
				*/

				hildon_banner_show_information(GTK_WIDGET(data->window), NULL, _("No Stations in reach found."));
			}
		}
	}
}

/**
 * Creates and shows the search station dialog.
 */
void showSearchTextBoxDialog( GtkWidget *w, AppData * data) {

	data->currentSelectorFor = w;

	GtkWidget *submitButton;
	GtkWidget *gpsButton;

	data->currentDialog = gtk_dialog_new ();
	gtk_window_set_transient_for (GTK_WINDOW (data->currentDialog), GTK_WINDOW (data->window));
	gtk_window_set_title (GTK_WINDOW (data->currentDialog), _("City Stationname"));

	data->currentSearchTextBox = hildon_entry_new (HILDON_SIZE_AUTO);

	hildon_entry_set_text(HILDON_ENTRY(data->currentSearchTextBox) , "");

	gtk_box_pack_start (GTK_BOX (GTK_DIALOG(data->currentDialog)->vbox), data->currentSearchTextBox,
	                        TRUE, TRUE, 0);

	submitButton = gtk_dialog_add_button(GTK_DIALOG(data->currentDialog), _("Search"), 0);

	gpsButton = gtk_dialog_add_button(GTK_DIALOG(data->currentDialog), _("GPS"), 0);

	g_signal_connect (G_OBJECT (submitButton), "clicked", G_CALLBACK (getStationsByName), data);

	g_signal_connect (G_OBJECT (gpsButton), "clicked", G_CALLBACK (getByGPS), data);

	gtk_box_pack_start (GTK_BOX (GTK_DIALOG(data->currentDialog)->vbox), submitButton,
	                        TRUE, TRUE, 0);

	gtk_widget_show_all (GTK_WIDGET (data->currentDialog));
	gtk_dialog_run (GTK_DIALOG (data->currentDialog));
}

/**
 * some stuff from the sample hello world example :)
 */
static gint dbus_callback(const gchar *interface, const gchar *method,
		GArray *arguments, gpointer data, osso_rpc_t *retval) {
	printf("dbus: %s, %s\n", interface, method);

	if (!strcmp(method, "top_application"))
		gtk_window_present(GTK_WINDOW (data));

	return DBUS_TYPE_INVALID;
}

/**
 * Creates the main ui with all its buttons and stuff.
 */
void initGui (AppData *data) {

	/* Create the hildon program and setup the title */
	data->program = HILDON_PROGRAM(hildon_program_get_instance());
	g_set_application_name(_("Fahrplan for maemo"));

	/* Create HildonWindow and set it to HildonProgram */
	data->window = HILDON_WINDOW(hildon_stackable_window_new());
	hildon_program_add_window(data->program, data->window);

	/* Quit program when window is closed. */
	g_signal_connect (G_OBJECT (data->window), "delete_event",
			G_CALLBACK (gtk_main_quit), NULL);

	/* Quit program when window is otherwise destroyed. */
	g_signal_connect (G_OBJECT (data->window), "destroy",
			G_CALLBACK (gtk_main_quit), NULL);


	/* create vertical container to stack the other containers vertically and add to main view */
	data->verticalContainer = gtk_vbox_new(FALSE, 4);
	gtk_container_add(GTK_CONTAINER(data->window), data->verticalContainer);

	/* create "from" elements */
	data->fromContainer = gtk_hbox_new(FALSE, 4);

	data->fromLabel = gtk_label_new(_("From:"));
	gtk_box_pack_start(GTK_BOX (data->fromContainer), data->fromLabel, FALSE, TRUE, 0);
	gtk_widget_set_usize(data->fromLabel, 100, 10);

	data->fromButton = hildon_button_new_with_text(HILDON_SIZE_AUTO,
			HILDON_BUTTON_ARRANGEMENT_HORIZONTAL, _("Station"), _("please select"));

	hildon_button_set_style(HILDON_BUTTON(data->fromButton), HILDON_BUTTON_STYLE_PICKER);

	g_signal_connect (G_OBJECT (data->fromButton), "clicked", G_CALLBACK (showSearchTextBoxDialog), data);


	gtk_box_pack_start(GTK_BOX (data->fromContainer), data->fromButton, TRUE, TRUE, 0);

	gtk_box_pack_start(GTK_BOX (data->verticalContainer), data->fromContainer, TRUE, TRUE,
			0);

	/* create "to" elements */
	data->toContainer = gtk_hbox_new(FALSE, 4);

	data->toLabel = gtk_label_new(_("To:"));
	gtk_box_pack_start(GTK_BOX (data->toContainer), data->toLabel, FALSE, TRUE, 0);
	gtk_widget_set_usize(data->toLabel, 100, 10);

	data->toButton = hildon_button_new_with_text(HILDON_SIZE_AUTO,
			HILDON_BUTTON_ARRANGEMENT_HORIZONTAL, _("Station"), _("please select"));

	hildon_button_set_style(HILDON_BUTTON(data->toButton), HILDON_BUTTON_STYLE_PICKER);

	g_signal_connect (G_OBJECT (data->toButton), "clicked", G_CALLBACK (showSearchTextBoxDialog), data);

	gtk_box_pack_start(GTK_BOX (data->toContainer), data->toButton, TRUE, TRUE, 0);

	gtk_box_pack_start(GTK_BOX (data->verticalContainer), data->toContainer, TRUE, TRUE, 0);

	/* create "time" elements */
	data->timeContainer = gtk_hbox_new(FALSE, 4);

	data->timeDateButton = hildon_date_button_new(HILDON_SIZE_AUTO,
			HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);

	hildon_button_set_title(HILDON_BUTTON (data->timeDateButton), _("Date"));
	gtk_box_pack_start(GTK_BOX (data->timeContainer), data->timeDateButton, TRUE, TRUE, 0);

	data->timeTimeButton = hildon_time_button_new(HILDON_SIZE_AUTO,
			HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);
	hildon_button_set_title(HILDON_BUTTON (data->timeTimeButton), _("Time"));


	gtk_box_pack_start(GTK_BOX (data->timeContainer), data->timeTimeButton, TRUE, TRUE, 0);

	gtk_box_pack_start(GTK_BOX (data->verticalContainer), data->timeContainer, TRUE, TRUE,
			0);

	/* options button (for the time */
	data->optionsButton = hildon_picker_button_new(HILDON_SIZE_AUTO,
			HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);
	hildon_button_set_title(HILDON_BUTTON (data->optionsButton),
			_("Use selected date/time as"));

	data->optionsSelector = hildon_touch_selector_new_text();

	hildon_touch_selector_append_text(HILDON_TOUCH_SELECTOR (data->optionsSelector),
			_("Arrival time"));
	hildon_touch_selector_append_text(HILDON_TOUCH_SELECTOR (data->optionsSelector),
			_("Departure time"));

	hildon_touch_selector_set_active(HILDON_TOUCH_SELECTOR (data->optionsSelector),
			0, 1);

	hildon_picker_button_set_selector(HILDON_PICKER_BUTTON (data->optionsButton),
			HILDON_TOUCH_SELECTOR (data->optionsSelector));

	gtk_box_pack_start(GTK_BOX (data->verticalContainer), data->optionsButton, TRUE, TRUE,
			0);

	/* search button */
	data->searchButton = gtk_button_new_with_label(_("Search"));

	g_signal_connect(G_OBJECT(data->searchButton), "clicked",
			G_CALLBACK(startSearch), data);

	gtk_box_pack_start(GTK_BOX (data->verticalContainer), data->searchButton, TRUE, TRUE, 0);

	gtk_widget_show_all(GTK_WIDGET ( data->window ));
}

/**
 * main entry point. mainly init the basics and then calls the initGui function.
 */
int main(int argc, char* argv[]) {

	AppData *data;

	data = g_new0 (AppData, 1);

	osso_context_t *osso_cont;
	osso_return_t ret;

	locale_init();

	osso_cont = osso_initialize(APP_NAME, APP_VER, TRUE, NULL);
	if (osso_cont == NULL) {
		fprintf(stderr, "osso_initialize failed.\n");
		exit(1);
	}

	/* Initialize the GTK. */
	gtk_init(&argc, &argv);

	initGui(data);

	ret = osso_rpc_set_cb_f(osso_cont, APP_SERVICE, APP_METHOD, APP_SERVICE,
			dbus_callback, GTK_WIDGET( data->window ));
	if (ret != OSSO_OK) {
		fprintf(stderr, "osso_rpc_set_cb_f failed: %d.\n", ret);
		exit(1);
	}

	/* Begin the main application */
	gtk_main();

	g_free (data);

	/* Exit */
	return 0;
}
