/**************************************************************************
** Copyright (C) 2004-2008 Trolltech ASA. All rights reserved.
**
** This file is part of the example classes of the Qt Toolkit.
**
** This file may be used under the terms of the GNU General Public
** License versions 2.0 or 3.0 as published by the Free Software
** Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file.  Alternatively you may (at
** your option) use any later version of the GNU General Public
** License if such license has been publicly approved by Trolltech ASA
** (or its successors, if any) and the KDE Free Qt Foundation. In
** addition, as a special exception, Trolltech gives you certain
** additional rights. These rights are described in the Trolltech GPL
** Exception version 1.2, which can be found at
** http://www.trolltech.com/products/qt/gplexception/ and in the file
** GPL_EXCEPTION.txt in this package.
**
** Please review the following information to ensure GNU General
** Public Licensing requirements will be met:
** http://trolltech.com/products/qt/licenses/licensing/opensource/. If
** you are unsure which license is appropriate for your use, please
** review the following information:
** http://trolltech.com/products/qt/licenses/licensing/licensingoverview
** or contact the sales department at sales@trolltech.com.
**
** In addition, as a special exception, Trolltech, as the sole
** copyright holder for Qt Designer, grants users of the Qt/Eclipse
** Integration plug-in the right for the Qt/Eclipse Integration to
** link to functionality provided by Qt Designer and its related
** libraries.
**
** This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
** INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE. Trolltech reserves all rights not expressly
** granted herein.
**************************************************************************/

#include <QtGui/QtGui>
#include <QtCore/QtGlobal>
#include <QtCore/qstring.h>
#include <QtGui/QFont>
#include <QtCore/QCoreApplication>
#include <QtGui/QKeyEvent>
#include "mainwindow.h"
//#include <QFile> // including file read/write interface to write the results to a log

MainWindow::MainWindow()
{
      textEdit = new TextEdit;
      setCentralWidget(textEdit);
      QFont font;
      font.setFamily("DejaVu Sans");
      font.setPointSize(111);
      textEdit->setFont(font);
      textEdit->setFrameStyle(QFrame::NoFrame);
      textEdit->setTextInteractionFlags(Qt::LinksAccessibleByKeyboard);
      QPalette p = palette();
      p.setColor(QPalette::Base, Qt::black);
      p.setColor(QPalette::Text, Qt::white);
      textEdit->setPalette(p);
      set(111);
      introduction = new QLabel;
      introduction->setAlignment(Qt::AlignRight);
      font.setPointSize(12);
      introduction->setFont(font);
      introduction->setFrameStyle(QFrame::NoFrame);
      introduction->setPalette(p);
      introduction->setText(QString(QChar(8745)) + QString(QChar(8595)) + " " + QString(QChar(8835)) + QString(QChar(8592)) + " " + QString(QChar(8834)) + QString(QChar(8594)) + " " + QString(QChar(8746)) + QString(QChar(8593)));
      statusBar()->addPermanentWidget(introduction);
    introduction->show();
}

TextEdit::~TextEdit()
 {
 }

TextEdit::TextEdit(QWidget *parent)
 : QLabel(parent)
 {
 }
/*The numbers used are inspired by numeric keypad, though I don't use it at all and wish my keyboard wouldn't include this useless supplement, which makes it too bulky to fit into the bag.*/
void TextEdit::keyPressEvent(QKeyEvent *e)
 {
QKeyEvent event = QKeyEvent(QEvent::KeyPress, Qt::Key_Backspace, Qt::ControlModifier, "backspace", false, 2);
switch (e->key()) {
        case Qt::Key_Left:
((MainWindow*)parent())->check(4);
            break;
        case Qt::Key_Up:
((MainWindow*)parent())->check(8);
            break;
        case Qt::Key_Right:
((MainWindow*)parent())->check(6);
            break;
        case Qt::Key_Down:
((MainWindow*)parent())->check(2);
            break;
        case Qt::Key_C:
((MainWindow*)parent())->close();
            break;
        case Qt::Key_E:
((MainWindow*)parent())->close();
            break;
        case Qt::Key_Q:
((MainWindow*)parent())->close();
            break;
        case Qt::Key_H:
((MainWindow*)parent())->introduction->hide();
            break;
        case Qt::Key_S:
((MainWindow*)parent())->introduction->show();
            break;
/*failed attempts to find a way to minimise the window case Qt::Key_Backspace:
QApplication::sendEvent(window(), &event);
            break;
        case Qt::Key_H:
keyPressEvent(&event);
            break;
        case Qt::Key_M:
((MainWindow*)parent())->showMinimized();
            break;*/
        default:
            break;
        }
}

void MainWindow::check(int i)
{
   if(i == c){
      if((textEdit->font()).pointSize() > 1){
         set((textEdit->font()).pointSize() - 1);
      }else{
         set(111);
      }
   }else{
      lr = (textEdit->font()).pointSize();//last result
      QDir dir("/home/user/.eye4/");
      if (!dir.exists()){//make the directory ~/.eye4 if it does not exist
        dir.mkpath("/home/user/.eye4/");
       }
      QFile file("/home/user/.eye4/results.log"); //declare a file

      if (!file.open(QIODevice::Append)) //file issues
		{
		 statusBar()->showMessage("/home/user/.eye4/results.log -- write to file failed");
		}
      else//no issues
      	{
	      	QTextStream out(&file);
	     	out << (QDate::currentDate()).toString(Qt::DefaultLocaleLongDate) << " ";
	     	out << (QTime::currentTime()).toString(Qt::DefaultLocaleLongDate) << ": " << lr << "\n";
     	}
      file.close();  
         
      set(111);//reset
      
      //**old attempt to log the eyesight check results at settings**
      //QSettings settings("gryllida", "eye4");
      //QStringList log=settings.value("log").toStringList();
      //log.append((QTime::currentTime()).toString(Qt::DefaultLocaleLongDate)+": "+QString::number(lr));
      //settings.setValue("log", log);
   }
}

void MainWindow::set(int fps)
{
QTime time = QTime::currentTime();
qsrand((uint)time.msec()+time.minute()+time.hour());
c = 2*(qrand() % 4 + 1);
if(c == 2){textEdit->setText(QChar(8745));}
if(c == 4){textEdit->setText(QChar(8835));}
if(c == 6){textEdit->setText(QChar(8834));}
if(c == 8){textEdit->setText(QChar(8746));}
      QFont font;
      font.setFamily("DejaVu Sans");
      font.setPointSize(fps);
      textEdit->setFont(font);
      textEdit->setAlignment(Qt::AlignVCenter | Qt::AlignHCenter);
    textEdit->show();
    statusBar()->showMessage(QString::number(fps)+"; "+QString::number(lr));
}
