#include <QFileDialog>
#include <QSettings>
#include <QDebug>
#include <QDesktopServices>
#include <QListWidgetItem>

#include "optionsdialog.h"
#include "ui_optionsdialog.h"
#include "appselector.h"

OptionsDialog::OptionsDialog(const QUuid &uuid, QWidget *parent) :
    QDialog(parent),
    _uuid(uuid),
    ui(new Ui::OptionsDialog)
{
    ui->setupUi(this);
    loadSettings();
}

OptionsDialog::~OptionsDialog()
{
    delete ui;
}

void OptionsDialog::loadSettings()
{
    QSettings settings;
    settings.beginGroup(_uuid.toString());
    ui->pbBrowseImage->setText(settings.value("image_file","Select image").toString());
    ui->edCommand->setText(settings.value("command","").toString());
    ui->cbCommandType->setCurrentIndex(settings.value("commandType",0).toInt());
}

void OptionsDialog::on_pbBrowseImage_clicked()
{
    _image_file = QFileDialog::getOpenFileName(this, tr("Select image"), QString(), tr("Images (*.png *.xpm *.jpg)"));
    if (!_image_file.isEmpty())
        ui->pbBrowseImage->setText(_image_file);
}

void OptionsDialog::on_buttonBox_accepted()
{
    QSettings settings;
    settings.beginGroup(_uuid.toString());
    settings.setValue("image_file", _image_file);
    settings.setValue("command", ui->edCommand->text());
    settings.setValue("commandType", ui->cbCommandType->currentIndex());
    QDialog::accept();
}

void OptionsDialog::on_pbBrowse_clicked()
{
    AppSelector appSelector;
    if (appSelector.exec() == QDialog::Accepted)
    {
        QListWidgetItem *it = appSelector.currentItem();
        if (it)
        {
            ui->edCommand->setText(it->text());
        }
    }
}
