// checksum 0xa193 version 0x30001
/*
  This file was generated by the Mobile Qt Application wizard of Qt Creator.
  MainWindow is a convenience class containing mobile device specific code
  such as screen orientation handling.
  It is recommended not to modify this file, since newer versions of Qt Creator
  may offer an updated version of it.
*/

#include <QtCore/QCoreApplication>
#include <QtGui/QVBoxLayout>
#include <QtGui/QLabel>
#include <QtGui/QPixmap>
#include <QPushButton>
#include <QPainter>
#include <QSettings>
#include <QDebug>
#include <QDesktopServices>
#include <QUrl>
#include <QThread>
#include <QtDBus/QtDBus>
#include <QMoveEvent>
#include <QPoint>

#include "images/noimages.xpm"
#include "mainwindow.h"
#include "optionsdialog.h"
#include "utils.h"

//#include "QsLog.h"
//#include "QsLogDest.h"

MainWindow::MainWindow(QWidget *parent)
    : QWidget(parent)
{

    QCoreApplication::setOrganizationName("XBASoft");
    QCoreApplication::setApplicationName("ExtShortcut");

    setAttribute(Qt::WA_TranslucentBackground);

    QVBoxLayout *topLayout = new QVBoxLayout(this);

    _lbCmd = new QLabel(this);
    _lbCmd->setPixmap(QPixmap(noimages_xpm));
    _lbCmd->setAttribute(Qt::WA_TranslucentBackground);
    topLayout->addWidget(_lbCmd);

    _uuid = findUuid();
    if (_uuid.isNull())
        close();

    loadSettings();
#if !defined(Q_WS_MAEMO_5) && !defined(Q_WS_MAEMO_6)
    QPushButton *pb = new QPushButton("Options", this);
    topLayout->addWidget(pb);
    connect(pb, SIGNAL(clicked()), SLOT(showSettingsDialog()));

    //const QString sLogPath("/home/vadim/extshortcutlog.txt");
#else
    //const QString sLogPath("/home/user/extshortcutlog.txt");
#endif

    //QsLogging::Logger& logger = QsLogging::Logger::instance();
    //logger.setLoggingLevel(QsLogging::InfoLevel);
    //QsLogging::DestinationPtr fileDestination(QsLogging::DestinationFactory::MakeFileDestination(sLogPath) );
    //logger.addDestination(fileDestination.get());

}

QSize MainWindow::sizeHint() const
{
    return _lbCmd->sizeHint();
}

MainWindow::~MainWindow()
{
    QSettings settings;
    settings.beginGroup(_uuid.toString());
    settings.setValue("is_running", false);
}

void MainWindow::mousePressEvent(QMouseEvent *event)
{
    if (_commandType == 0)
        launchApplication();
    else
        QDesktopServices::openUrl(QUrl(_command));
}

void MainWindow::moveEvent(QMoveEvent *event)
{
    if (!_uuid.isNull())
    {
        QSettings settings;
        settings.beginGroup(_uuid.toString());
        settings.setValue("pos", event->pos());
    }
}

void MainWindow::launchApplication() const
{
    QDBusConnection bus = QDBusConnection::sessionBus();
    // here we create the D-Bus interface for starting application
    QDBusInterface dbus_iface("com.nokia.HildonDesktop.AppMgr", "/com/nokia/HildonDesktop/AppMgr",
                              "com.nokia.HildonDesktop.AppMgr", bus);
    // here we send command 'LaunchApplication' with param _command
    dbus_iface.call("LaunchApplication",_command);
}

void MainWindow::showSettingsDialog()
{
    OptionsDialog dlg(_uuid);
    dlg.exec();
    loadSettings();
}

void MainWindow::loadSettings()
{
    QSettings settings;
    settings.beginGroup(_uuid.toString());
    QString image_file = settings.value("image_file","").toString();
    if (!image_file.isEmpty())
    {
        QPixmap img(image_file);
        _lbCmd->setPixmap(img);
#if defined(Q_WS_MAEMO_5) || defined(Q_WS_MAEMO_6)
        resize(img.size());
#endif
    }
    _command = settings.value("command","").toString().trimmed();
    _commandType = settings.value("commandType",0).toInt();
    QPoint pos = settings.value("pos", QPoint()).toPoint();
    if (!pos.isNull())
        move(pos);
    settings.setValue("is_running", true);
}

void MainWindow::paintEvent(QPaintEvent *event)
{
    QWidget::paintEvent(event);

    QPainter p(this);
    p.setBrush(QColor(0, 0, 0, 128));
    p.setPen(Qt::NoPen);
    p.drawRoundedRect(rect(), 10, 10);
    p.end();
}

struct MyThread : public QThread { using QThread::msleep;};

QUuid MainWindow::findUuid()
{
    // wait until other extshortcut are reading settings
    int count = 0;
    while (!createLock() && count < 100)
        MyThread::msleep(100);
    if (count >= 100)
        return QUuid();

    QSettings settings;
    QStringList groups = settings.childGroups();
    QStringList::const_iterator constIterator;
    for (constIterator = groups.constBegin(); constIterator != groups.constEnd(); ++constIterator)
    {
        settings.beginGroup(*constIterator);
        bool is_running = settings.value("is_running", false).toBool();
        if (!is_running)
        {
            settings.setValue("is_running", true);
            settings.endGroup();
            unLock();
            return QUuid(*constIterator);
        }
        settings.endGroup();
    }
    unLock();
    return QUuid::createUuid();
}


