/*
 * Copyright (C) 2010 Collabora Ltd.
 *   @author Xavier Claessens <xavier.claessens@collabora.co.uk>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef __ECS_WINDOW_H__
#define __ECS_WINDOW_H__

#include <hildon/hildon.h>

G_BEGIN_DECLS

#define ECS_TYPE_WINDOW (ecs_window_get_type ())
#define ECS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ECS_TYPE_WINDOW, \
    EcsWindow))
#define ECS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), \
    ECS_TYPE_WINDOW, EcsWindowClass))
#define ECS_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ECS_TYPE_WINDOW))
#define ECS_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), \
    ECS_TYPE_WINDOW))
#define ECS_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), \
    ECS_TYPE_WINDOW, EcsWindowClass))

typedef struct _EcsWindow EcsWindow;
typedef struct _EcsWindowClass EcsWindowClass;

struct _EcsWindow
{
  /*< private >*/
  HildonStackableWindow parent;
};

struct _EcsWindowClass
{
  HildonStackableWindowClass parent_class;
};

GType ecs_window_get_type (void) G_GNUC_CONST;

GtkWidget *ecs_window_new (void);

G_END_DECLS

#endif /* __ECS_WINDOW_H__ */
