#ifndef screen_edit_h
#define screen_edit_h

/*
 * edicao do item
 *
 * funciona com incializacao lazy
 */

#include <string>
using namespace std;

#include "txt.h"
#include "file_expenses.h"
#include "popup.h"
#include "NoCopyConstructor.h"
#include "string_conversion.h"

/*
 * a tela
 */
class screen_edit
{
	singleton(screen_edit)
	void _constructor()
	{
		__tela_window = NULL;
	}

	void _destructor()
	{
		if(__tela_window != NULL)
			if(GTK_IS_WINDOW(__tela_window))
			{
				gtk_widget_destroy(__tela_window);
			}
	}

public:
	//indice dentro dos dados do file_expenses, ou -1 se é item novo
	int __indice_sendo_editado;
public:
	//pediram para editar ou adicionar
	void acao_editar(HildonWindow *window_pai, int selectedindex)
	{
		construir_tela(window_pai);

		__indice_sendo_editado = selectedindex;

		//transferimos os dados
		file_expenses::dado_item &item = file_expenses::get_instance().dados()[__indice_sendo_editado];

		//valor
		hildon_entry_set_text ( (HildonEntry*)__tela_valor, item.valor_tela().c_str() );
		//categoria
		GtkTextBuffer *buffer = gtk_text_view_get_buffer( GTK_TEXT_VIEW(__tela_categoria) );
		gtk_text_buffer_set_text (buffer, item.descricao_get(), -1);
		//data
		struct tm *datatm = item.data_estrutura();
	    hildon_date_button_set_date ((HildonDateButton*)__tela_data,
	    		datatm->tm_year + 1900, datatm->tm_mon, datatm->tm_mday);

		gtk_widget_show_all (__tela_window);
	}

	void acao_adicionar(HildonWindow *window_pai)
	{
		construir_tela(window_pai);
		__indice_sendo_editado = -1;
		//valor vazio
		hildon_entry_set_text ( (HildonEntry*)__tela_valor, "");
		//categoria vazia
		GtkTextBuffer *buffer = gtk_text_view_get_buffer( GTK_TEXT_VIEW(__tela_categoria) );
		gtk_text_buffer_set_text (buffer, "", -1);
		//data de agora
		GDate *gdate = g_date_new ();
		g_date_set_time (gdate, time (NULL));
	    hildon_date_button_set_date ((HildonDateButton*)__tela_data, g_date_get_year (gdate),
	    		g_date_get_month(gdate)-1, g_date_get_day(gdate));
	    g_date_free(gdate);


		gtk_widget_show_all (__tela_window);
	}

	//bootes de numeros
	void clicaram_valor(int valor_clicado)
	{
		double atual = string_conversion::conversao_string2double(hildon_entry_get_text((HildonEntry*)__tela_valor));
		atual = atual + (double)valor_clicado;
		string novo = string_conversion::conversao_double2string(atual);
		hildon_entry_set_text ( (HildonEntry*)__tela_valor, novo.c_str());
	}
	void clicaram_valor_sinal()
	{
		double atual = string_conversion::conversao_string2double(hildon_entry_get_text((HildonEntry*)__tela_valor));
		atual = atual * (double)(-1);
		string novo = string_conversion::conversao_double2string(atual);
		hildon_entry_set_text ( (HildonEntry*)__tela_valor, novo.c_str());
	}
	void clicaram_valor_zero()
	{
		string novo = string_conversion::conversao_double2string(0);
		hildon_entry_set_text ( (HildonEntry*)__tela_valor, novo.c_str());
	}

private:
	void construir_tela(HildonWindow *window_pai);

public:
	//o controle do valor
	GtkWidget *__tela_valor;
	//o controle da categoria
	GtkWidget *__tela_categoria;
	//o controle da data
	GtkWidget *__tela_data;

	//a janela toda
	GtkWidget *__tela_window;

};


#endif
