/*
 * gerenciador do arquivo de categorias
 *
 * funciona com incializacao lazy
 */

#include <string>
using namespace std;

#include "txt.h"
#include "file_category.h"
#include "popup.h"
#include "NoCopyConstructor.h"


/*
 * a tela
 */
class screen_category
{
	singleton(screen_category)
	void _constructor()
	{
		construir_tela_feito = false;
		dialog = NULL;
	}

	void _destructor()
	{
		if(dialog != NULL)
		{
		    gtk_widget_destroy(dialog);
		    dialog = NULL;
		    construir_tela_feito = false;
		}
	}
public:

	class return_type
	{
	public:
		enum return_type_enum
		{
			use, apeend, cancel, remove
		};
		return_type_enum retorno;
		string selecao;
	};

	return_type run(HildonWindow *window_pai)
	{
		construir_tela(window_pai, file_category::get_instance());
	    encher_dados(file_category::get_instance());
		gtk_widget_show_all (dialog);

		//o remover fica direto
		return_type::return_type_enum r;
		while(true)
		{
			r = (return_type::return_type_enum)gtk_dialog_run(GTK_DIALOG(dialog));
			if(r != return_type::remove)
				break;

			//vamos remover
			remover_selecionad(file_category::get_instance());
		}

		gtk_widget_hide (dialog);
		return_type ret;
		ret.retorno = r;
		ret.selecao = getselection();
		return ret;
	}

private:
	string getselection()
	{
	  GtkTreeIter iter;
	  char *value;

	  string ret;
	  GtkTreeSelection *selection = gtk_tree_view_get_selection ( GTK_TREE_VIEW(nosso_tree));
	  GtkTreeModel *model;
	  if (gtk_tree_selection_get_selected(GTK_TREE_SELECTION(selection), &model, &iter))
	  {
		  gtk_tree_model_get(model, &iter, 0, &value,  -1);
		  ret = value;
		  g_free(value);
	  }
	  return ret;
	}

	//remove o item selecionado
	void remover_selecionad(file_category &file_category_instance)
	{
		string remover = getselection();
		vector<string> &dados = file_category_instance.dados();
	    vector<string>::iterator it;
		for ( it=dados.begin() ; it < dados.end(); it++ )
		{
			if(remover == *it)
			{
				dados.erase(it);
				if(!file_category_instance.salvar())
				{
					//avisamos que deu erro
					popup::warn(txt::tx(txt::erro_arquivo_categ_salvando));
				}
				encher_dados(file_category_instance);
				return;
			}
		}
	}


private:
	bool construir_tela_feito;
	GtkWidget *dialog;
	GtkListStore *nosso_store;
    GtkWidget *nosso_tree;
	void construir_tela(HildonWindow *window_pai, file_category &file_category_instance)
	{
		if(construir_tela_feito)
			return;

		//vamos construir a tela
		//tem a lista no meio e 3 botoes: Usar, Adicionar e Cancelar
	    dialog = hildon_note_new_confirmation_add_buttons(
			GTK_WINDOW (window_pai),
			txt::tx(txt::screen_cat_title) ,
			txt::tx(txt::screen_cat_remove), return_type::remove,
			txt::tx(txt::screen_cat_append), return_type::apeend,
			txt::tx(txt::screen_cat_use), return_type::use,
			txt::tx(txt::screen_cat_cancel), return_type::cancel,
			NULL);

		//lista
	    nosso_store = gtk_list_store_new (1, G_TYPE_STRING);

#ifndef WITH_HILDON_2_2
	    nosso_tree=gtk_tree_view_new();
#else
	    nosso_tree=hildon_gtk_tree_view_new(HILDON_UI_MODE_EDIT);
#endif
	    gtk_tree_view_set_model(GTK_TREE_VIEW(nosso_tree), GTK_TREE_MODEL(nosso_store));
	    GtkCellRenderer *renderer;
	    GtkTreeViewColumn *column;
	    renderer = gtk_cell_renderer_text_new ();
	    g_object_set(renderer, "alignment", PANGO_ALIGN_LEFT, NULL);
	    //o jeito é colocar a largura hard-coded, nao escobri como deixar ele usar a largura natural... saco!
	    g_object_set(renderer, "wrap-width", 550, NULL);
	    g_object_set(renderer, "wrap-mode", PANGO_WRAP_WORD_CHAR, NULL);

	    column = gtk_tree_view_column_new_with_attributes ("category", renderer,  "text", 0, NULL);
	    //gtk_tree_view_column_set_alignment (column, 1);
	    gtk_tree_view_append_column (GTK_TREE_VIEW (nosso_tree), column);

	    //scroll
	    GtkWidget *treescroll =hildon_pannable_area_new();

	    //poe na tela
	    GtkWidget *content_area;
		content_area = gtk_dialog_get_content_area (GTK_DIALOG (dialog));
		//ta deprecado, mas é o que funcina!!!
	    hildon_pannable_area_set_size_request_policy( (HildonPannableArea*)treescroll, HILDON_SIZE_REQUEST_CHILDREN );
	    hildon_pannable_area_add_with_viewport ( (HildonPannableArea*)treescroll, nosso_tree);

	    //HildonPannableArea
	    gtk_container_add(GTK_CONTAINER(content_area), treescroll);

	    //nao tem efeito, mas a documentacao diz que tá deprecado
	    gtk_window_set_default_size (GTK_WINDOW(dialog), -1, 1024);

	    construir_tela_feito = true;
	}

	void encher_dados(file_category &file_category_instance)
	{
		//colocamos em nosso_store
		gtk_list_store_clear (nosso_store);

	    GtkTreeIter iter1;  /* Parent iter */
	    GValue value  = {0};
	    g_value_init (&value, G_TYPE_STRING);

	    vector<string> &dados = file_category_instance.dados();
	    vector<string>::iterator it;
		for ( it=dados.begin() ; it < dados.end(); it++ )
		{
			gtk_list_store_append( nosso_store, &iter1);
			g_value_set_static_string (&value, (*it).c_str());
			gtk_list_store_set_value  (nosso_store, &iter1, 0, &value);
	    }

	}

};


