#ifndef string_conversion_h
#define string_conversion_h

#include <libintl.h>
#include <time.h>
#include <langinfo.h>

#include <iostream>
#include <fstream>
#include <string>
#include <vector>
using namespace std;
#include "NoCopyConstructor.h"


class string_conversion : NoCopyConstructor
{
public:
	static string conversao_double2string(double valor)
	{
#define BUFFER_MAXIMO_IMPRIMIR_AUX 200
		static char buffer[BUFFER_MAXIMO_IMPRIMIR_AUX + 10];
		snprintf( buffer, BUFFER_MAXIMO_IMPRIMIR_AUX, "%.2f", (float)valor);
		string ret = buffer;
		return ret;
	}

	static double conversao_string2double(const char *origem)
	{
		float valorlido;
		int lidos = sscanf(origem, "%f", &valorlido);
		if( lidos != 1)
			return false;
		return (double)valorlido;
	}

	static string conversao_int2string(int valor)
	{
#define BUFFER_MAXIMO_IMPRIMIR_AUX 200
		static char buffer[BUFFER_MAXIMO_IMPRIMIR_AUX + 10];
		snprintf( buffer, BUFFER_MAXIMO_IMPRIMIR_AUX, "%d", valor);
		string ret = buffer;
		return ret;
	}

	static string tirar_letras(const string& str,const string& delimiters)
	{
		if(str == "")
			return str;
		size_t found = str.find_first_of(delimiters);
		if(found == string::npos)
			return str;

		string ret;
		for(unsigned int i = 0; i < str.length(); i++)
		{
			if(delimiters.find( str.at(i)) != string::npos)
				ret += " ";
			else
				ret += str.at(i);
		}

		return ret;
	}


};

#endif
