#ifndef file_expenses_h
#define file_expenses_h

#include <libintl.h>
#include <time.h>
#include <langinfo.h>

#include <iostream>
#include <fstream>
#include <string>
#include <vector>
using namespace std;
#include "NoCopyConstructor.h"
#include "string_conversion.h"

#include "includes.h"

vector<string> tokenize_string(const string& str,const string& delimiters);

/*
 * o arquivo de dados
 *
 */
#define assinaturya_arquivo_expenses "creation\tdate\tamount\tcomment"

class file_expenses
{
	singleton(file_expenses)
	void _constructor()
	{
		__ja_salvou = false;
	}
	void _destructor() { }

	//se ja salvamos o arquivo alguma vez
	bool __ja_salvou;
public:
	// ============================================================
	// ============================================================
	//a nossa estrutura de dados,em uma linha
	class dado_item
	{
	private:
		struct tm criacao;
		struct tm data;
		double valor;
		string descricao;
		static string format_data;
	public:
		static bool format_data_calculado;

	public:
		dado_item()
		{
			//vamos inciailizar o formato de data
			if(!format_data_calculado)
			{
				locale_t l;
				l = newlocale (LC_TIME_MASK, setlocale (LC_MESSAGES, NULL), NULL);
				//format = g_locale_to_utf8 (nl_langinfo_l (D_FMT, l), -1, NULL, NULL, NULL);
				format_data = nl_langinfo_l (D_FMT, l);
				freelocale (l);
				format_data_calculado = true;
			}


			//dado_criacao e automatico
			time_t rawtime;
			time ( &rawtime );
			struct tm * timeinfo;
			timeinfo = localtime ( &rawtime );
			memcpy(&criacao, timeinfo, sizeof(criacao));

			//colocamos tb na data do registro
			memcpy(&data, timeinfo, sizeof(data));
		}

#define BUFFER_MAXIMO_IMPRIMIR 200
#define FORMATO_CRIACAO "%Y-%m-%d %H:%M:%S"
		string criacao_arquivo()
		{
			char buffer[BUFFER_MAXIMO_IMPRIMIR + 10];
			strftime( buffer, BUFFER_MAXIMO_IMPRIMIR, FORMATO_CRIACAO, &criacao);
			string ret = buffer;
			return ret;
		}

		//seta a data de criacao como sendo agora
		void data_criacao_agora()
		{
			time_t rawtime;
			time ( &rawtime );
			struct tm * timeinfo;
			timeinfo = localtime ( &rawtime );
			memcpy(&criacao, timeinfo, sizeof(criacao));
		}

		void data_setar(int year_from_1900, int month, int day)
		{
			data.tm_year = year_from_1900;
			data.tm_mon = month;
			data.tm_mday = day;
		}

		string data_tela()
		{
			char buffer[BUFFER_MAXIMO_IMPRIMIR + 10];
			strftime( buffer, BUFFER_MAXIMO_IMPRIMIR, format_data.c_str(), &data);
			string ret = buffer;
			return ret;
		}

		struct tm *data_estrutura()
		{
			return &data;
		}

		void valor_set(double novo)
		{
			valor = novo;
		}


		string valor_tela()
		{
			return string_conversion::conversao_double2string(valor);
		}

		void descricao_set(const char *novo)
		{
			//nao podemos permitir um tab
			//NEM ENTER
			string aux = string_conversion::tirar_letras(novo, "\t\r\n");
			descricao = aux;
		}
		const char *descricao_get()
		{
			return descricao.c_str();
		}

		string registro_para_salvar()
		{
			string ret;
			ret += criacao_arquivo();
			ret += "\t";
			ret += data_tela();
			ret += "\t";
			ret += valor_tela();
			ret += "\t";

			//nao podemos permitir um tab
			string aux = string_conversion::tirar_letras(descricao, "\t\r\n");
			ret += aux;

			return  ret;
		}

		//retorna false se der erro
		bool registro_carregar(string linha)
		{
			vector<string> tokens = tokenize_string(linha, "\t");

			//se a descricao ta vazia, em sem a coluna
			if(tokens.size() == 3)
				tokens.push_back("");

			//4 colunas
			if(tokens.size() != 4)
				return false;
			if( strptime(tokens[0].c_str(), FORMATO_CRIACAO, &criacao) == NULL)
				return false;
			if( strptime(tokens[1].c_str(), format_data.c_str(), &data) == NULL)
				return false;

			float valorlido;
			int lidos = sscanf(tokens[2].c_str(), "%f", &valorlido);
			if( lidos != 1)
				return false;
			valor = (double)valorlido;

			this->descricao_set(tokens[3].c_str());

			return  true;
		}
	};


	// ============================================================
	// ============================================================
	//a classe em si

private:
	//os nossos dados
	vector<dado_item> _dados;
	//nome do arquivo
	string nome_do_arquivo;

public:
	vector<dado_item> &dados()
	{
		return _dados;
	}

	//se der erro, indica a linha onde deu erro
	//-1 nao deu erro
	int inicializar(const char *arquivo)
	{
		nome_do_arquivo = arquivo;
		int linhaslidas = 1;

		//se der erro, ignoramos homericaemnte, só registramos que nao incializou
		_dados.clear();

		filebuf fb;
		fb.open (nome_do_arquivo.c_str(),ios::in);
		istream is(&fb);
		string linha;
		getline(is, linha);
		if(linha != assinaturya_arquivo_expenses)
		{
			//erro!!!!
			fb.close();
			return 0;
		}
		while(!is.eof())
		{
			linhaslidas++;
			getline(is, linha);
			if(linha != "")
			{
				dado_item novo;
				if(!novo.registro_carregar(linha))
				{
					fb.close();
					return linhaslidas;
				}
				_dados.push_back(novo);
			}
		}
		fb.close();
		return -1;
	}

private:
#define NUMERO_MAXIMO_BACKUPS 99
	void gerar_backup()
	{
		//na primeira vez que salva, renomear para .bak
		if(__ja_salvou)
			return;

		string novo_nome = nome_do_arquivo;
		novo_nome += ".bak";

		//renomeamos de bak0 a bak99
		//pegamos o 98, vira 99, o 97 vira 98, etc, e sempre salvamos no 0

		//apagamos o 99, o ultimo
		string novo_nome_apagar = novo_nome;
		novo_nome_apagar += string_conversion::conversao_int2string(NUMERO_MAXIMO_BACKUPS);
		remove(novo_nome_apagar.c_str());

		//procuramos um disponivel
		for(int i = NUMERO_MAXIMO_BACKUPS; i >= 0; i--)
		{
			string novo_nome_atual = novo_nome;
			novo_nome_atual += string_conversion::conversao_int2string(i);
			string novo_nome_atual_menos_um = novo_nome;
			if(i != 0)
				novo_nome_atual_menos_um += string_conversion::conversao_int2string(i-1);
			rename(novo_nome_atual_menos_um.c_str(), novo_nome_atual.c_str() );
		}

		//renomea o que vamos salvar
		rename(nome_do_arquivo.c_str(), novo_nome.c_str() );
	}

public:
	bool salvar()
	{
		//na primeira vez que salva, renomear para .bak
		gerar_backup();

		ofstream out(nome_do_arquivo.c_str(),
				ios::out | ios::binary | ios::trunc);
		if(!out)
			return false;

		out << assinaturya_arquivo_expenses;
		out << "\n";
		vector<dado_item>::iterator it;
		for ( it=_dados.begin() ; it < _dados.end(); it++ )
		{
			out << (*it).registro_para_salvar();
			out << "\n";
		}

		out.close();
		__ja_salvou = true;
		return true;
	}
};

#endif
