#ifndef DIRECTORY_H
#define DIRECTORY_H

#include <QWidget>
#include <QDirModel>
#include <QFileSystemModel>

namespace Ui {
    class Directory;
}

class Directory : public QWidget
{
    Q_OBJECT

public:
    explicit Directory(QWidget *parent = 0);
    ~Directory();
    QString path;
signals:
    void hidden();
    void hiddenDoNothing();

private:
    void loadDir();
    Ui::Directory *ui;
    QDirModel *model;
    QFileSystemModel *fmodel;
    void back();
    void closeEvent(QCloseEvent *);

private slots:
    void on_pushButton_Cancel_clicked();
    void on_pushButton_OK_clicked();
    void on_treeView_clicked(QModelIndex index);
    void on_pushButton_MessStorage_clicked();
    void on_pushButton_MemoryCard_clicked();
};

#endif // DIRECTORY_H
