#include "directory.h"
#include "ui_directory.h"
#include <QModelIndex>
#include <QtDBus>


Directory::Directory(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::Directory)
{
    ui->setupUi(this);
    path="/home/user/MyDocs";
    model = new QDirModel;
    model->setSorting(QDir::DirsFirst|QDir::IgnoreCase|QDir::Name);
    model->setFilter(QDir::AllDirs|QDir::NoDotAndDotDot|QDir::Readable|QDir::Hidden);
    ui->treeView->setModel(model);
    ui->treeView->header()->setStretchLastSection(true);
    ui->treeView->header()->setSortIndicator(0,Qt::AscendingOrder);
    ui->treeView->header()->setSortIndicatorShown(true);
    ui->treeView->header()->setClickable(true);
    loadDir();
}

Directory::~Directory()
{
    delete ui;
}

void Directory::loadDir()
{
    QModelIndex index = model->index(path);
    ui->treeView->setRootIndex(index);
    ui->treeView->expand(index);
    ui->treeView->scrollTo(index);
    ui->treeView->resizeColumnToContents(0);

}

void Directory::on_treeView_clicked(QModelIndex index)
{
    ui->label->setText(model->fileInfo(index).filePath());
    QFileInfo fl(model->fileInfo(index).filePath());
    if(fl.isDir())
    {
        ui->pushButton_OK->setEnabled(true);
        ui->treeView->expand(index);
        ui->treeView->scrollTo(index);

    }
    else
    {
        ui->pushButton_OK->setEnabled(false);
    }
}

void Directory::on_pushButton_OK_clicked()
{
    path = ui->label->text();
    emit hidden();
    this->hide();
}

void Directory::on_pushButton_Cancel_clicked()
{
    emit hiddenDoNothing();
    this->hide();
}

void Directory::closeEvent(QCloseEvent *)
{
    emit hiddenDoNothing();
    this->hide();
}

void Directory::on_pushButton_MessStorage_clicked()
{
    path = "/home/user/MyDocs";
    ui->label->setText(path);
    loadDir();
}

void Directory::on_pushButton_MemoryCard_clicked()
{
    path = "/media";
    ui->label->setText(path);
    loadDir();
}
